/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.graalvm.shadowed.org.jcodings.util;

import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.ascii.AsciiTables;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.util.Hash;

public final class CaseInsensitiveBytesHash<V>
extends Hash<V> {
    public CaseInsensitiveBytesHash() {
    }

    public CaseInsensitiveBytesHash(int size) {
        super(size);
    }

    @Override
    protected void init() {
        this.head = new CaseInsensitiveBytesHashEntry();
    }

    public static int hashCode(byte[] bytes, int p2, int end2) {
        int key2 = 0;
        while (p2 < end2) {
            key2 = (key2 << 16) + (key2 << 6) - key2 + AsciiTables.ToLowerCaseTable[bytes[p2++] & 0xFF];
        }
        key2 += key2 >> 5;
        return key2;
    }

    public V put(byte[] bytes, V value2) {
        return this.put(bytes, 0, bytes.length, value2);
    }

    public V put(byte[] bytes, int p2, int end2, V value2) {
        this.checkResize();
        int hash = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes, p2, end2));
        int i2 = CaseInsensitiveBytesHash.bucketIndex(hash, this.table.length);
        CaseInsensitiveBytesHashEntry entry = (CaseInsensitiveBytesHashEntry)this.table[i2];
        while (entry != null) {
            if (entry.hash == hash && entry.equals(bytes, p2, end2)) {
                entry.value = value2;
                return value2;
            }
            entry = (CaseInsensitiveBytesHashEntry)entry.next;
        }
        this.table[i2] = new CaseInsensitiveBytesHashEntry<V>(hash, this.table[i2], value2, bytes, p2, end2, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(byte[] bytes, V value2) {
        this.putDirect(bytes, 0, bytes.length, value2);
    }

    public void putDirect(byte[] bytes, int p2, int end2, V value2) {
        this.checkResize();
        int hash = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes, p2, end2));
        int i2 = CaseInsensitiveBytesHash.bucketIndex(hash, this.table.length);
        this.table[i2] = new CaseInsensitiveBytesHashEntry<V>(hash, this.table[i2], value2, bytes, p2, end2, this.head);
        ++this.size;
    }

    public V get(byte[] bytes) {
        return this.get(bytes, 0, bytes.length);
    }

    public V get(byte[] bytes, int p2, int end2) {
        int hash = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes, p2, end2));
        CaseInsensitiveBytesHashEntry entry = (CaseInsensitiveBytesHashEntry)this.table[CaseInsensitiveBytesHash.bucketIndex(hash, this.table.length)];
        while (entry != null) {
            if (entry.hash == hash && entry.equals(bytes, p2, end2)) {
                return (V)entry.value;
            }
            entry = (CaseInsensitiveBytesHashEntry)entry.next;
        }
        return null;
    }

    public V delete(byte[] bytes) {
        return this.delete(bytes, 0, bytes.length);
    }

    public V delete(byte[] bytes, int p2, int end2) {
        int hash = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes, p2, end2));
        int i2 = CaseInsensitiveBytesHash.bucketIndex(hash, this.table.length);
        CaseInsensitiveBytesHashEntry entry = (CaseInsensitiveBytesHashEntry)this.table[i2];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash && entry.equals(bytes, p2, end2)) {
            this.table[i2] = entry.next;
            --this.size;
            entry.remove();
            return (V)entry.value;
        }
        while (entry.next != null) {
            Hash.HashEntry tmp = entry.next;
            if (tmp.hash == hash && entry.equals(bytes, p2, end2)) {
                entry.next = entry.next.next;
                --this.size;
                tmp.remove();
                return tmp.value;
            }
            entry = (CaseInsensitiveBytesHashEntry)entry.next;
        }
        return null;
    }

    @Override
    public CaseInsensitiveBytesHashEntryIterator entryIterator() {
        return new CaseInsensitiveBytesHashEntryIterator();
    }

    public static boolean caseInsensitiveEquals(byte[] bytes, int p2, int end2, byte[] oBytes, int oP, int oEnd) {
        if (oEnd - oP != end2 - p2) {
            return false;
        }
        if (oBytes == bytes) {
            return true;
        }
        int q2 = oP;
        while (q2 < oEnd) {
            if (AsciiTables.ToLowerCaseTable[oBytes[q2++] & 0xFF] == AsciiTables.ToLowerCaseTable[bytes[p2++] & 0xFF]) continue;
            return false;
        }
        return true;
    }

    public static boolean caseInsensitiveEquals(byte[] bytes, byte[] oBytes) {
        return CaseInsensitiveBytesHash.caseInsensitiveEquals(bytes, 0, bytes.length, oBytes, 0, oBytes.length);
    }

    public class CaseInsensitiveBytesHashEntryIterator
    extends Hash.HashEntryIterator {
        @Override
        public CaseInsensitiveBytesHashEntry<V> next() {
            return (CaseInsensitiveBytesHashEntry)super.next();
        }
    }

    public static final class CaseInsensitiveBytesHashEntry<V>
    extends Hash.HashEntry<V> {
        public final byte[] bytes;
        public final int p;
        public final int end;

        public CaseInsensitiveBytesHashEntry(int hash, Hash.HashEntry<V> next, V value2, byte[] bytes, int p2, int end2, Hash.HashEntry<V> head2) {
            super(hash, next, value2, head2);
            this.bytes = bytes;
            this.p = p2;
            this.end = end2;
        }

        public CaseInsensitiveBytesHashEntry() {
            this.bytes = null;
            this.end = 0;
            this.p = 0;
        }

        public boolean equals(byte[] bytes, int p2, int end2) {
            return CaseInsensitiveBytesHash.caseInsensitiveEquals(this.bytes, this.p, this.end, bytes, p2, end2);
        }
    }
}

