/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.pkl.thirdparty.jansiAnsiRenderer;

public class jansiAnsi
implements Appendable {
    private static final char FIRST_ESC_CHAR = '\u001b';
    private static final char SECOND_ESC_CHAR = '[';
    public static final String DISABLE = jansiAnsi.class.getName() + ".disable";
    private static Callable<Boolean> detector = () -> !Boolean.getBoolean(DISABLE);
    private static final InheritableThreadLocal<Boolean> holder = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return jansiAnsi.isDetected();
        }
    };
    private final StringBuilder builder;
    private final ArrayList<Integer> attributeOptions = new ArrayList(5);

    public static void setDetector(Callable<Boolean> detector) {
        if (detector == null) {
            throw new IllegalArgumentException();
        }
        jansiAnsi.detector = detector;
    }

    public static boolean isDetected() {
        try {
            return detector.call();
        }
        catch (Exception e2) {
            return true;
        }
    }

    public static void setEnabled(boolean flag2) {
        holder.set(flag2);
    }

    public static boolean isEnabled() {
        return (Boolean)holder.get();
    }

    public static jansiAnsi ansi() {
        if (jansiAnsi.isEnabled()) {
            return new jansiAnsi();
        }
        return new NoAnsi();
    }

    public static jansiAnsi ansi(StringBuilder builder) {
        if (jansiAnsi.isEnabled()) {
            return new jansiAnsi(builder);
        }
        return new NoAnsi(builder);
    }

    public static jansiAnsi ansi(int size) {
        if (jansiAnsi.isEnabled()) {
            return new jansiAnsi(size);
        }
        return new NoAnsi(size);
    }

    public jansiAnsi() {
        this(new StringBuilder(80));
    }

    public jansiAnsi(jansiAnsi parent) {
        this(new StringBuilder(parent.builder));
        this.attributeOptions.addAll(parent.attributeOptions);
    }

    public jansiAnsi(int size) {
        this(new StringBuilder(size));
    }

    public jansiAnsi(StringBuilder builder) {
        this.builder = builder;
    }

    public jansiAnsi fg(Color color) {
        this.attributeOptions.add(color.fg());
        return this;
    }

    public jansiAnsi fg(int color) {
        this.attributeOptions.add(38);
        this.attributeOptions.add(5);
        this.attributeOptions.add(color & 0xFF);
        return this;
    }

    public jansiAnsi fgRgb(int color) {
        return this.fgRgb(color >> 16, color >> 8, color);
    }

    public jansiAnsi fgRgb(int r, int g, int b2) {
        this.attributeOptions.add(38);
        this.attributeOptions.add(2);
        this.attributeOptions.add(r & 0xFF);
        this.attributeOptions.add(g & 0xFF);
        this.attributeOptions.add(b2 & 0xFF);
        return this;
    }

    public jansiAnsi fgBlack() {
        return this.fg(Color.BLACK);
    }

    public jansiAnsi fgBlue() {
        return this.fg(Color.BLUE);
    }

    public jansiAnsi fgCyan() {
        return this.fg(Color.CYAN);
    }

    public jansiAnsi fgDefault() {
        return this.fg(Color.DEFAULT);
    }

    public jansiAnsi fgGreen() {
        return this.fg(Color.GREEN);
    }

    public jansiAnsi fgMagenta() {
        return this.fg(Color.MAGENTA);
    }

    public jansiAnsi fgRed() {
        return this.fg(Color.RED);
    }

    public jansiAnsi fgYellow() {
        return this.fg(Color.YELLOW);
    }

    public jansiAnsi bg(Color color) {
        this.attributeOptions.add(color.bg());
        return this;
    }

    public jansiAnsi bg(int color) {
        this.attributeOptions.add(48);
        this.attributeOptions.add(5);
        this.attributeOptions.add(color & 0xFF);
        return this;
    }

    public jansiAnsi bgRgb(int color) {
        return this.bgRgb(color >> 16, color >> 8, color);
    }

    public jansiAnsi bgRgb(int r, int g, int b2) {
        this.attributeOptions.add(48);
        this.attributeOptions.add(2);
        this.attributeOptions.add(r & 0xFF);
        this.attributeOptions.add(g & 0xFF);
        this.attributeOptions.add(b2 & 0xFF);
        return this;
    }

    public jansiAnsi bgCyan() {
        return this.bg(Color.CYAN);
    }

    public jansiAnsi bgDefault() {
        return this.bg(Color.DEFAULT);
    }

    public jansiAnsi bgGreen() {
        return this.bg(Color.GREEN);
    }

    public jansiAnsi bgMagenta() {
        return this.bg(Color.MAGENTA);
    }

    public jansiAnsi bgRed() {
        return this.bg(Color.RED);
    }

    public jansiAnsi bgYellow() {
        return this.bg(Color.YELLOW);
    }

    public jansiAnsi fgBright(Color color) {
        this.attributeOptions.add(color.fgBright());
        return this;
    }

    public jansiAnsi fgBrightBlack() {
        return this.fgBright(Color.BLACK);
    }

    public jansiAnsi fgBrightBlue() {
        return this.fgBright(Color.BLUE);
    }

    public jansiAnsi fgBrightCyan() {
        return this.fgBright(Color.CYAN);
    }

    public jansiAnsi fgBrightDefault() {
        return this.fgBright(Color.DEFAULT);
    }

    public jansiAnsi fgBrightGreen() {
        return this.fgBright(Color.GREEN);
    }

    public jansiAnsi fgBrightMagenta() {
        return this.fgBright(Color.MAGENTA);
    }

    public jansiAnsi fgBrightRed() {
        return this.fgBright(Color.RED);
    }

    public jansiAnsi fgBrightYellow() {
        return this.fgBright(Color.YELLOW);
    }

    public jansiAnsi bgBright(Color color) {
        this.attributeOptions.add(color.bgBright());
        return this;
    }

    public jansiAnsi bgBrightCyan() {
        return this.bgBright(Color.CYAN);
    }

    public jansiAnsi bgBrightDefault() {
        return this.bgBright(Color.DEFAULT);
    }

    public jansiAnsi bgBrightGreen() {
        return this.bgBright(Color.GREEN);
    }

    public jansiAnsi bgBrightMagenta() {
        return this.bgBright(Color.MAGENTA);
    }

    public jansiAnsi bgBrightRed() {
        return this.bgBright(Color.RED);
    }

    public jansiAnsi bgBrightYellow() {
        return this.bgBright(Color.YELLOW);
    }

    public jansiAnsi a(Attribute attribute) {
        this.attributeOptions.add(attribute.value());
        return this;
    }

    public jansiAnsi cursor(int row, int column) {
        return this.appendEscapeSequence('H', Math.max(1, row), Math.max(1, column));
    }

    public jansiAnsi cursorToColumn(int x) {
        return this.appendEscapeSequence('G', Math.max(1, x));
    }

    public jansiAnsi cursorUp(int y) {
        return y > 0 ? this.appendEscapeSequence('A', y) : (y < 0 ? this.cursorDown(-y) : this);
    }

    public jansiAnsi cursorDown(int y) {
        return y > 0 ? this.appendEscapeSequence('B', y) : (y < 0 ? this.cursorUp(-y) : this);
    }

    public jansiAnsi cursorRight(int x) {
        return x > 0 ? this.appendEscapeSequence('C', x) : (x < 0 ? this.cursorLeft(-x) : this);
    }

    public jansiAnsi cursorLeft(int x) {
        return x > 0 ? this.appendEscapeSequence('D', x) : (x < 0 ? this.cursorRight(-x) : this);
    }

    public jansiAnsi cursorMove(int x, int y) {
        return this.cursorRight(x).cursorDown(y);
    }

    public jansiAnsi cursorDownLine() {
        return this.appendEscapeSequence('E');
    }

    public jansiAnsi cursorDownLine(int n) {
        return n < 0 ? this.cursorUpLine(-n) : this.appendEscapeSequence('E', n);
    }

    public jansiAnsi cursorUpLine() {
        return this.appendEscapeSequence('F');
    }

    public jansiAnsi cursorUpLine(int n) {
        return n < 0 ? this.cursorDownLine(-n) : this.appendEscapeSequence('F', n);
    }

    public jansiAnsi eraseScreen() {
        return this.appendEscapeSequence('J', Erase.ALL.value());
    }

    public jansiAnsi eraseScreen(Erase kind) {
        return this.appendEscapeSequence('J', kind.value());
    }

    public jansiAnsi eraseLine() {
        return this.appendEscapeSequence('K');
    }

    public jansiAnsi eraseLine(Erase kind) {
        return this.appendEscapeSequence('K', kind.value());
    }

    public jansiAnsi scrollUp(int rows) {
        if (rows == Integer.MIN_VALUE) {
            return this.scrollDown(Integer.MAX_VALUE);
        }
        return rows > 0 ? this.appendEscapeSequence('S', rows) : (rows < 0 ? this.scrollDown(-rows) : this);
    }

    public jansiAnsi scrollDown(int rows) {
        if (rows == Integer.MIN_VALUE) {
            return this.scrollUp(Integer.MAX_VALUE);
        }
        return rows > 0 ? this.appendEscapeSequence('T', rows) : (rows < 0 ? this.scrollUp(-rows) : this);
    }

    @Deprecated
    public jansiAnsi restorCursorPosition() {
        return this.restoreCursorPosition();
    }

    public jansiAnsi saveCursorPosition() {
        this.saveCursorPositionSCO();
        return this.saveCursorPositionDEC();
    }

    public jansiAnsi saveCursorPositionSCO() {
        return this.appendEscapeSequence('s');
    }

    public jansiAnsi saveCursorPositionDEC() {
        this.builder.append('\u001b');
        this.builder.append('7');
        return this;
    }

    public jansiAnsi restoreCursorPosition() {
        this.restoreCursorPositionSCO();
        return this.restoreCursorPositionDEC();
    }

    public jansiAnsi restoreCursorPositionSCO() {
        return this.appendEscapeSequence('u');
    }

    public jansiAnsi restoreCursorPositionDEC() {
        this.builder.append('\u001b');
        this.builder.append('8');
        return this;
    }

    public jansiAnsi reset() {
        return this.a(Attribute.RESET);
    }

    public jansiAnsi bold() {
        return this.a(Attribute.INTENSITY_BOLD);
    }

    public jansiAnsi boldOff() {
        return this.a(Attribute.INTENSITY_BOLD_OFF);
    }

    public jansiAnsi a(String value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(boolean value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(char value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(char[] value2, int offset, int len) {
        this.flushAttributes();
        this.builder.append(value2, offset, len);
        return this;
    }

    public jansiAnsi a(char[] value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(CharSequence value2, int start2, int end2) {
        this.flushAttributes();
        this.builder.append(value2, start2, end2);
        return this;
    }

    public jansiAnsi a(CharSequence value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(double value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(float value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(int value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(long value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(Object value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi a(StringBuffer value2) {
        this.flushAttributes();
        this.builder.append(value2);
        return this;
    }

    public jansiAnsi newline() {
        this.flushAttributes();
        this.builder.append(System.getProperty("line.separator"));
        return this;
    }

    public jansiAnsi format(String pattern2, Object ... args2) {
        this.flushAttributes();
        this.builder.append(String.format(pattern2, args2));
        return this;
    }

    public jansiAnsi apply(Consumer fun) {
        fun.apply(this);
        return this;
    }

    public jansiAnsi render(String text) {
        this.a(jansiAnsiRenderer.render(text));
        return this;
    }

    public jansiAnsi render(String text, Object ... args2) {
        this.a(String.format(jansiAnsiRenderer.render(text), args2));
        return this;
    }

    public String toString() {
        this.flushAttributes();
        return this.builder.toString();
    }

    private jansiAnsi appendEscapeSequence(char command2) {
        this.flushAttributes();
        this.builder.append('\u001b');
        this.builder.append('[');
        this.builder.append(command2);
        return this;
    }

    private jansiAnsi appendEscapeSequence(char command2, int option2) {
        this.flushAttributes();
        this.builder.append('\u001b');
        this.builder.append('[');
        this.builder.append(option2);
        this.builder.append(command2);
        return this;
    }

    private jansiAnsi appendEscapeSequence(char command2, Object ... options) {
        this.flushAttributes();
        return this._appendEscapeSequence(command2, options);
    }

    private void flushAttributes() {
        if (this.attributeOptions.isEmpty()) {
            return;
        }
        if (this.attributeOptions.size() == 1 && this.attributeOptions.get(0) == 0) {
            this.builder.append('\u001b');
            this.builder.append('[');
            this.builder.append('m');
        } else {
            this._appendEscapeSequence('m', this.attributeOptions.toArray());
        }
        this.attributeOptions.clear();
    }

    private jansiAnsi _appendEscapeSequence(char command2, Object ... options) {
        this.builder.append('\u001b');
        this.builder.append('[');
        int size = options.length;
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 != 0) {
                this.builder.append(';');
            }
            if (options[i2] == null) continue;
            this.builder.append(options[i2]);
        }
        this.builder.append(command2);
        return this;
    }

    @Override
    public jansiAnsi append(CharSequence csq) {
        this.builder.append(csq);
        return this;
    }

    @Override
    public jansiAnsi append(CharSequence csq, int start2, int end2) {
        this.builder.append(csq, start2, end2);
        return this;
    }

    @Override
    public jansiAnsi append(char c) {
        this.builder.append(c);
        return this;
    }

    private static class NoAnsi
    extends jansiAnsi {
        public NoAnsi() {
        }

        public NoAnsi(int size) {
            super(size);
        }

        public NoAnsi(StringBuilder builder) {
            super(builder);
        }

        @Override
        public jansiAnsi fg(Color color) {
            return this;
        }

        @Override
        public jansiAnsi bg(Color color) {
            return this;
        }

        @Override
        public jansiAnsi fgBright(Color color) {
            return this;
        }

        @Override
        public jansiAnsi bgBright(Color color) {
            return this;
        }

        @Override
        public jansiAnsi fg(int color) {
            return this;
        }

        @Override
        public jansiAnsi fgRgb(int r, int g, int b2) {
            return this;
        }

        @Override
        public jansiAnsi bg(int color) {
            return this;
        }

        @Override
        public jansiAnsi bgRgb(int r, int g, int b2) {
            return this;
        }

        @Override
        public jansiAnsi a(Attribute attribute) {
            return this;
        }

        @Override
        public jansiAnsi cursor(int row, int column) {
            return this;
        }

        @Override
        public jansiAnsi cursorToColumn(int x) {
            return this;
        }

        @Override
        public jansiAnsi cursorUp(int y) {
            return this;
        }

        @Override
        public jansiAnsi cursorRight(int x) {
            return this;
        }

        @Override
        public jansiAnsi cursorDown(int y) {
            return this;
        }

        @Override
        public jansiAnsi cursorLeft(int x) {
            return this;
        }

        @Override
        public jansiAnsi cursorDownLine() {
            return this;
        }

        @Override
        public jansiAnsi cursorDownLine(int n) {
            return this;
        }

        @Override
        public jansiAnsi cursorUpLine() {
            return this;
        }

        @Override
        public jansiAnsi cursorUpLine(int n) {
            return this;
        }

        @Override
        public jansiAnsi eraseScreen() {
            return this;
        }

        @Override
        public jansiAnsi eraseScreen(Erase kind) {
            return this;
        }

        @Override
        public jansiAnsi eraseLine() {
            return this;
        }

        @Override
        public jansiAnsi eraseLine(Erase kind) {
            return this;
        }

        @Override
        public jansiAnsi scrollUp(int rows) {
            return this;
        }

        @Override
        public jansiAnsi scrollDown(int rows) {
            return this;
        }

        @Override
        public jansiAnsi saveCursorPosition() {
            return this;
        }

        @Override
        @Deprecated
        public jansiAnsi restorCursorPosition() {
            return this;
        }

        @Override
        public jansiAnsi restoreCursorPosition() {
            return this;
        }

        @Override
        public jansiAnsi reset() {
            return this;
        }
    }

    @FunctionalInterface
    public static interface Consumer {
        public void apply(jansiAnsi var1);
    }

    public static enum Erase {
        FORWARD(0, "FORWARD"),
        BACKWARD(1, "BACKWARD"),
        ALL(2, "ALL");

        private final int value;
        private final String name;

        private Erase(int index, String name) {
            this.value = index;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Attribute {
        RESET(0, "RESET"),
        INTENSITY_BOLD(1, "INTENSITY_BOLD"),
        INTENSITY_FAINT(2, "INTENSITY_FAINT"),
        ITALIC(3, "ITALIC_ON"),
        UNDERLINE(4, "UNDERLINE_ON"),
        BLINK_SLOW(5, "BLINK_SLOW"),
        BLINK_FAST(6, "BLINK_FAST"),
        NEGATIVE_ON(7, "NEGATIVE_ON"),
        CONCEAL_ON(8, "CONCEAL_ON"),
        STRIKETHROUGH_ON(9, "STRIKETHROUGH_ON"),
        UNDERLINE_DOUBLE(21, "UNDERLINE_DOUBLE"),
        INTENSITY_BOLD_OFF(22, "INTENSITY_BOLD_OFF"),
        ITALIC_OFF(23, "ITALIC_OFF"),
        UNDERLINE_OFF(24, "UNDERLINE_OFF"),
        BLINK_OFF(25, "BLINK_OFF"),
        NEGATIVE_OFF(27, "NEGATIVE_OFF"),
        CONCEAL_OFF(28, "CONCEAL_OFF"),
        STRIKETHROUGH_OFF(29, "STRIKETHROUGH_OFF");

        private final int value;
        private final String name;

        private Attribute(int index, String name) {
            this.value = index;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Color {
        BLACK(0, "BLACK"),
        RED(1, "RED"),
        GREEN(2, "GREEN"),
        YELLOW(3, "YELLOW"),
        BLUE(4, "BLUE"),
        MAGENTA(5, "MAGENTA"),
        CYAN(6, "CYAN"),
        WHITE(7, "WHITE"),
        DEFAULT(9, "DEFAULT");

        private final int value;
        private final String name;

        private Color(int index, String name) {
            this.value = index;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int value() {
            return this.value;
        }

        public int fg() {
            return this.value + 30;
        }

        public int bg() {
            return this.value + 40;
        }

        public int fgBright() {
            return this.value + 90;
        }

        public int bgBright() {
            return this.value + 100;
        }
    }
}

