/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.pkl.thirdparty.jansiAnsiColors;
import org.pkl.thirdparty.jansiAnsiMode;
import org.pkl.thirdparty.jansiAnsiPrintStream;
import org.pkl.thirdparty.jansiAnsiType;
import org.pkl.thirdparty.jansiinternal.CLibrary;
import org.pkl.thirdparty.jansiinternal.Kernel32;
import org.pkl.thirdparty.jansiinternal.MingwSupport;
import org.pkl.thirdparty.jansiio.AnsiOutputStream;
import org.pkl.thirdparty.jansiio.AnsiProcessor;
import org.pkl.thirdparty.jansiio.FastBufferedOutputStream;
import org.pkl.thirdparty.jansiio.WindowsAnsiProcessor;

public class jansiAnsiConsole {
    public static final String JANSI_MODE = "jansi.mode";
    public static final String JANSI_OUT_MODE = "jansi.out.mode";
    public static final String JANSI_ERR_MODE = "jansi.err.mode";
    public static final String JANSI_MODE_STRIP = "strip";
    public static final String JANSI_MODE_FORCE = "force";
    public static final String JANSI_MODE_DEFAULT = "default";
    public static final String JANSI_COLORS = "jansi.colors";
    public static final String JANSI_OUT_COLORS = "jansi.out.colors";
    public static final String JANSI_ERR_COLORS = "jansi.err.colors";
    public static final String JANSI_COLORS_16 = "16";
    public static final String JANSI_COLORS_256 = "256";
    public static final String JANSI_COLORS_TRUECOLOR = "truecolor";
    @Deprecated
    public static final String JANSI_PASSTHROUGH = "jansi.passthrough";
    @Deprecated
    public static final String JANSI_STRIP = "jansi.strip";
    @Deprecated
    public static final String JANSI_FORCE = "jansi.force";
    @Deprecated
    public static final String JANSI_EAGER = "jansi.eager";
    public static final String JANSI_NORESET = "jansi.noreset";
    public static final String JANSI_GRACEFUL = "jansi.graceful";
    @Deprecated
    public static PrintStream system_out = System.out;
    @Deprecated
    public static PrintStream out;
    @Deprecated
    public static PrintStream system_err;
    @Deprecated
    public static PrintStream err;
    static final boolean IS_WINDOWS;
    static final boolean IS_CYGWIN;
    static final boolean IS_MSYSTEM;
    static final boolean IS_CONEMU;
    static final int ENABLE_VIRTUAL_TERMINAL_PROCESSING = 4;
    static int STDOUT_FILENO;
    static int STDERR_FILENO;
    private static boolean initialized;
    private static int installed;
    private static int virtualProcessing;

    public static int getTerminalWidth() {
        int w = jansiAnsiConsole.out().getTerminalWidth();
        if (w <= 0) {
            w = jansiAnsiConsole.err().getTerminalWidth();
        }
        return w;
    }

    private jansiAnsiConsole() {
    }

    private static jansiAnsiPrintStream ansiStream(boolean stdout) {
        String term;
        String colorterm;
        AnsiOutputStream.WidthSupplier width;
        AnsiOutputStream.IoRunnable installer;
        AnsiOutputStream.IoRunnable uninstaller;
        jansiAnsiType type2;
        AnsiProcessor processor;
        boolean withException;
        boolean isAtty;
        FileDescriptor descriptor2 = stdout ? FileDescriptor.out : FileDescriptor.err;
        FastBufferedOutputStream out2 = new FastBufferedOutputStream(new FileOutputStream(descriptor2));
        String enc = System.getProperty(stdout ? "stdout.encoding" : "stderr.encoding");
        if (enc == null) {
            enc = System.getProperty(stdout ? "sun.stdout.encoding" : "sun.stderr.encoding");
        }
        final int fd = stdout ? STDOUT_FILENO : STDERR_FILENO;
        try {
            isAtty = CLibrary.isatty(fd) != 0;
            String term2 = System.getenv("TERM");
            String emacs = System.getenv("INSIDE_EMACS");
            if (isAtty && "dumb".equals(term2) && emacs != null && !emacs.contains("comint")) {
                isAtty = false;
            }
            withException = false;
        }
        catch (Throwable ignore) {
            isAtty = false;
            withException = true;
        }
        boolean isatty = isAtty;
        if (!isatty) {
            processor = null;
            type2 = withException ? jansiAnsiType.Unsupported : jansiAnsiType.Redirected;
            uninstaller = null;
            installer = null;
            width = new AnsiOutputStream.ZeroWidthSupplier();
        } else if (IS_WINDOWS) {
            final long console = Kernel32.GetStdHandle(stdout ? Kernel32.STD_OUTPUT_HANDLE : Kernel32.STD_ERROR_HANDLE);
            int[] mode = new int[1];
            boolean isConsole = Kernel32.GetConsoleMode(console, mode) != 0;
            AnsiOutputStream.WidthSupplier kernel32Width = new AnsiOutputStream.WidthSupplier(){

                @Override
                public int getTerminalWidth() {
                    Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
                    Kernel32.GetConsoleScreenBufferInfo(console, info);
                    return info.windowWidth();
                }
            };
            if (isConsole && Kernel32.SetConsoleMode(console, mode[0] | 4) != 0) {
                Kernel32.SetConsoleMode(console, mode[0]);
                processor = null;
                type2 = jansiAnsiType.VirtualTerminal;
                installer = () -> {
                    Class<jansiAnsiConsole> clazz = jansiAnsiConsole.class;
                    synchronized (jansiAnsiConsole.class) {
                        ++virtualProcessing;
                        Kernel32.SetConsoleMode(console, mode[0] | 4);
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return;
                    }
                };
                uninstaller = () -> {
                    Class<jansiAnsiConsole> clazz = jansiAnsiConsole.class;
                    synchronized (jansiAnsiConsole.class) {
                        if (--virtualProcessing == 0) {
                            Kernel32.SetConsoleMode(console, mode[0]);
                        }
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        return;
                    }
                };
                width = kernel32Width;
            } else if ((IS_CONEMU || IS_CYGWIN || IS_MSYSTEM) && !isConsole) {
                processor = null;
                type2 = jansiAnsiType.Native;
                uninstaller = null;
                installer = null;
                MingwSupport mingw = new MingwSupport();
                String name = mingw.getConsoleName(stdout);
                width = name != null && !name.isEmpty() ? () -> mingw.getTerminalWidth(name) : () -> -1;
            } else {
                jansiAnsiType ttype;
                AnsiProcessor proc2;
                try {
                    proc2 = new WindowsAnsiProcessor((OutputStream)out2, console);
                    ttype = jansiAnsiType.Emulation;
                }
                catch (Throwable ignore) {
                    proc2 = new AnsiProcessor(out2);
                    ttype = jansiAnsiType.Unsupported;
                }
                processor = proc2;
                type2 = ttype;
                uninstaller = null;
                installer = null;
                width = kernel32Width;
            }
        } else {
            processor = null;
            type2 = jansiAnsiType.Native;
            uninstaller = null;
            installer = null;
            width = new AnsiOutputStream.WidthSupplier(){

                @Override
                public int getTerminalWidth() {
                    CLibrary.WinSize sz = new CLibrary.WinSize();
                    CLibrary.ioctl(fd, CLibrary.TIOCGWINSZ, sz);
                    return sz.ws_col;
                }
            };
        }
        String jansiMode = System.getProperty(stdout ? JANSI_OUT_MODE : JANSI_ERR_MODE, System.getProperty(JANSI_MODE));
        jansiAnsiMode mode = JANSI_MODE_FORCE.equals(jansiMode) ? jansiAnsiMode.Force : (JANSI_MODE_STRIP.equals(jansiMode) ? jansiAnsiMode.Strip : (jansiMode != null ? (isatty ? jansiAnsiMode.Default : jansiAnsiMode.Strip) : (jansiAnsiConsole.getBoolean(JANSI_PASSTHROUGH) ? jansiAnsiMode.Force : (jansiAnsiConsole.getBoolean(JANSI_STRIP) ? jansiAnsiMode.Strip : (jansiAnsiConsole.getBoolean(JANSI_FORCE) ? jansiAnsiMode.Force : (isatty ? jansiAnsiMode.Default : jansiAnsiMode.Strip))))));
        String jansiColors = System.getProperty(stdout ? JANSI_OUT_COLORS : JANSI_ERR_COLORS, System.getProperty(JANSI_COLORS));
        jansiAnsiColors colors = JANSI_COLORS_TRUECOLOR.equals(jansiColors) ? jansiAnsiColors.TrueColor : (JANSI_COLORS_256.equals(jansiColors) ? jansiAnsiColors.Colors256 : (jansiColors != null ? jansiAnsiColors.Colors16 : ((colorterm = System.getenv("COLORTERM")) != null && (colorterm.contains(JANSI_COLORS_TRUECOLOR) || colorterm.contains("24bit")) ? jansiAnsiColors.TrueColor : ((term = System.getenv("TERM")) != null && term.contains("-direct") ? jansiAnsiColors.TrueColor : (term != null && term.contains("-256color") ? jansiAnsiColors.Colors256 : jansiAnsiColors.Colors16)))));
        boolean resetAtUninstall = type2 != jansiAnsiType.Unsupported && !jansiAnsiConsole.getBoolean(JANSI_NORESET);
        Charset cs = Charset.defaultCharset();
        if (enc != null) {
            try {
                cs = Charset.forName(enc);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return jansiAnsiConsole.newPrintStream(new AnsiOutputStream(out2, width, mode, processor, type2, colors, cs, installer, uninstaller, resetAtUninstall), cs.name());
    }

    private static jansiAnsiPrintStream newPrintStream(AnsiOutputStream out2, String enc) {
        if (enc != null) {
            try {
                return new jansiAnsiPrintStream(out2, true, enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new jansiAnsiPrintStream(out2, true);
    }

    static boolean getBoolean(String name) {
        boolean result2 = false;
        try {
            String val = System.getProperty(name);
            result2 = val.isEmpty() || Boolean.parseBoolean(val);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result2;
    }

    public static jansiAnsiPrintStream out() {
        jansiAnsiConsole.initStreams();
        return (jansiAnsiPrintStream)out;
    }

    public static PrintStream sysOut() {
        return system_out;
    }

    public static jansiAnsiPrintStream err() {
        jansiAnsiConsole.initStreams();
        return (jansiAnsiPrintStream)err;
    }

    public static PrintStream sysErr() {
        return system_err;
    }

    public static synchronized void systemInstall() {
        if (installed == 0) {
            jansiAnsiConsole.initStreams();
            try {
                ((jansiAnsiPrintStream)out).install();
                ((jansiAnsiPrintStream)err).install();
            }
            catch (IOException e2) {
                throw new IOError(e2);
            }
            System.setOut(out);
            System.setErr(err);
        }
        ++installed;
    }

    public static synchronized boolean isInstalled() {
        return installed > 0;
    }

    public static synchronized void systemUninstall() {
        if (--installed == 0) {
            try {
                ((jansiAnsiPrintStream)out).uninstall();
                ((jansiAnsiPrintStream)err).uninstall();
            }
            catch (IOException e2) {
                throw new IOError(e2);
            }
            initialized = false;
            System.setOut(system_out);
            System.setErr(system_err);
        }
    }

    static synchronized void initStreams() {
        if (!initialized) {
            out = jansiAnsiConsole.ansiStream(true);
            err = jansiAnsiConsole.ansiStream(false);
            initialized = true;
        }
    }

    static {
        system_err = System.err;
        IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/");
        IS_MSYSTEM = IS_WINDOWS && System.getenv("MSYSTEM") != null && (System.getenv("MSYSTEM").startsWith("MINGW") || System.getenv("MSYSTEM").equals("MSYS"));
        IS_CONEMU = IS_WINDOWS && System.getenv("ConEmuPID") != null;
        STDOUT_FILENO = 1;
        STDERR_FILENO = 2;
        if (jansiAnsiConsole.getBoolean(JANSI_EAGER)) {
            jansiAnsiConsole.initStreams();
        }
    }
}

