/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.pkl.thirdparty.jansiAnsi;
import org.pkl.thirdparty.jansiAnsiColors;
import org.pkl.thirdparty.jansiAnsiConsole;
import org.pkl.thirdparty.jansiAnsiMode;
import org.pkl.thirdparty.jansiAnsiType;
import org.pkl.thirdparty.jansiinternal.CLibrary;
import org.pkl.thirdparty.jansiinternal.JansiLoader;
import org.pkl.thirdparty.jansiinternal.Kernel32;
import org.pkl.thirdparty.jansiinternal.MingwSupport;

public class jansiAnsiMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String ... args2) throws IOException {
        System.out.println("Jansi " + jansiAnsiMain.getJansiVersion());
        System.out.println();
        System.out.println("library.jansi.path= " + System.getProperty("library.jansi.path", ""));
        System.out.println("library.jansi.version= " + System.getProperty("library.jansi.version", ""));
        boolean loaded = JansiLoader.initialize();
        if (loaded) {
            System.out.println("Jansi native library loaded from " + JansiLoader.getNativeLibraryPath());
            if (JansiLoader.getNativeLibrarySourceUrl() != null) {
                System.out.println("   which was auto-extracted from " + JansiLoader.getNativeLibrarySourceUrl());
            }
        } else {
            Enum[] prev = System.getProperty("jansi.graceful");
            try {
                System.setProperty("jansi.graceful", "false");
                JansiLoader.initialize();
            }
            catch (Throwable e2) {
                e2.printStackTrace(System.out);
            }
            finally {
                if (prev != null) {
                    System.setProperty("jansi.graceful", (String)prev);
                } else {
                    System.clearProperty("jansi.graceful");
                }
            }
        }
        System.out.println();
        System.out.println("os.name= " + System.getProperty("os.name") + ", os.version= " + System.getProperty("os.version") + ", os.arch= " + System.getProperty("os.arch"));
        System.out.println("file.encoding= " + System.getProperty("file.encoding"));
        System.out.println("sun.stdout.encoding= " + System.getProperty("sun.stdout.encoding") + ", sun.stderr.encoding= " + System.getProperty("sun.stderr.encoding"));
        System.out.println("stdout.encoding= " + System.getProperty("stdout.encoding") + ", stderr.encoding= " + System.getProperty("stderr.encoding"));
        System.out.println("java.version= " + System.getProperty("java.version") + ", java.vendor= " + System.getProperty("java.vendor") + ", java.home= " + System.getProperty("java.home"));
        System.out.println("Console: " + System.console());
        System.out.println();
        System.out.println("jansi.graceful= " + System.getProperty("jansi.graceful", ""));
        System.out.println("jansi.mode= " + System.getProperty("jansi.mode", ""));
        System.out.println("jansi.out.mode= " + System.getProperty("jansi.out.mode", ""));
        System.out.println("jansi.err.mode= " + System.getProperty("jansi.err.mode", ""));
        System.out.println("jansi.colors= " + System.getProperty("jansi.colors", ""));
        System.out.println("jansi.out.colors= " + System.getProperty("jansi.out.colors", ""));
        System.out.println("jansi.err.colors= " + System.getProperty("jansi.err.colors", ""));
        System.out.println("jansi.passthrough= " + jansiAnsiConsole.getBoolean("jansi.passthrough"));
        System.out.println("jansi.strip= " + jansiAnsiConsole.getBoolean("jansi.strip"));
        System.out.println("jansi.force= " + jansiAnsiConsole.getBoolean("jansi.force"));
        System.out.println("jansi.noreset= " + jansiAnsiConsole.getBoolean("jansi.noreset"));
        System.out.println(jansiAnsi.DISABLE + "= " + jansiAnsiConsole.getBoolean(jansiAnsi.DISABLE));
        System.out.println();
        System.out.println("IS_WINDOWS: " + jansiAnsiConsole.IS_WINDOWS);
        if (jansiAnsiConsole.IS_WINDOWS) {
            System.out.println("IS_CONEMU: " + jansiAnsiConsole.IS_CONEMU);
            System.out.println("IS_CYGWIN: " + jansiAnsiConsole.IS_CYGWIN);
            System.out.println("IS_MSYSTEM: " + jansiAnsiConsole.IS_MSYSTEM);
        }
        System.out.println();
        jansiAnsiMain.diagnoseTty(false);
        jansiAnsiMain.diagnoseTty(true);
        jansiAnsiConsole.systemInstall();
        System.out.println();
        System.out.println("Resulting Jansi modes for stout/stderr streams:");
        System.out.println("  - System.out: " + jansiAnsiConsole.out().toString());
        System.out.println("  - System.err: " + jansiAnsiConsole.err().toString());
        System.out.println("Processor types description:");
        for (jansiAnsiType jansiAnsiType2 : jansiAnsiType.values()) {
            System.out.println("  - " + (Object)((Object)jansiAnsiType2) + ": " + jansiAnsiType2.getDescription());
        }
        System.out.println("Colors support description:");
        for (Enum enum_ : jansiAnsiColors.values()) {
            System.out.println("  - " + enum_ + ": " + ((jansiAnsiColors)enum_).getDescription());
        }
        System.out.println("Modes description:");
        for (Enum enum_ : jansiAnsiMode.values()) {
            System.out.println("  - " + enum_ + ": " + ((jansiAnsiMode)enum_).getDescription());
        }
        try {
            void var5_17;
            String arg;
            void var5_15;
            File f;
            System.out.println();
            jansiAnsiMain.testAnsi(false);
            jansiAnsiMain.testAnsi(true);
            if (args2.length == 0) {
                jansiAnsiMain.printJansiLogoDemo();
                return;
            }
            System.out.println();
            if (args2.length == 1 && (f = new File(args2[0])).exists()) {
                System.out.println(jansiAnsi.ansi().bold().a("\"" + args2[0] + "\" content:").reset());
                jansiAnsiMain.writeFileContent(f);
                return;
            }
            System.out.println(jansiAnsi.ansi().bold().a("original args:").reset());
            int i2 = 1;
            String[] stringArray = args2;
            int n = stringArray.length;
            boolean bl = false;
            while (var5_15 < n) {
                arg = stringArray[var5_15];
                jansiAnsiConsole.system_out.print(i2++ + ": ");
                jansiAnsiConsole.system_out.println(arg);
                ++var5_15;
            }
            System.out.println(jansiAnsi.ansi().bold().a("Jansi filtered args:").reset());
            i2 = 1;
            stringArray = args2;
            n = stringArray.length;
            boolean bl2 = false;
            while (var5_17 < n) {
                arg = stringArray[var5_17];
                System.out.print(i2++ + ": ");
                System.out.println(arg);
                ++var5_17;
            }
        }
        finally {
            jansiAnsiConsole.systemUninstall();
        }
    }

    private static String getJansiVersion() {
        Package p2 = jansiAnsiMain.class.getPackage();
        return p2 == null ? null : p2.getImplementationVersion();
    }

    private static void diagnoseTty(boolean stderr) {
        int width;
        int isatty;
        if (jansiAnsiConsole.IS_WINDOWS) {
            long console = Kernel32.GetStdHandle(stderr ? Kernel32.STD_ERROR_HANDLE : Kernel32.STD_OUTPUT_HANDLE);
            int[] mode = new int[1];
            isatty = Kernel32.GetConsoleMode(console, mode);
            if ((jansiAnsiConsole.IS_CONEMU || jansiAnsiConsole.IS_CYGWIN || jansiAnsiConsole.IS_MSYSTEM) && isatty == 0) {
                MingwSupport mingw = new MingwSupport();
                String name = mingw.getConsoleName(!stderr);
                if (name != null && !name.isEmpty()) {
                    isatty = 1;
                    width = mingw.getTerminalWidth(name);
                } else {
                    isatty = 0;
                    width = 0;
                }
            } else {
                Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
                Kernel32.GetConsoleScreenBufferInfo(console, info);
                width = info.windowWidth();
            }
        } else {
            int fd = stderr ? CLibrary.STDERR_FILENO : CLibrary.STDOUT_FILENO;
            isatty = CLibrary.LOADED ? CLibrary.isatty(fd) : 0;
            CLibrary.WinSize ws = new CLibrary.WinSize();
            CLibrary.ioctl(fd, CLibrary.TIOCGWINSZ, ws);
            width = ws.ws_col;
        }
        System.out.println("isatty(STD" + (stderr ? "ERR" : "OUT") + "_FILENO): " + isatty + ", System." + (stderr ? "err" : "out") + " " + (isatty == 0 ? "is *NOT*" : "is") + " a terminal");
        System.out.println("width(STD" + (stderr ? "ERR" : "OUT") + "_FILENO): " + width);
    }

    private static void testAnsi(boolean stderr) {
        int i2;
        PrintStream s2 = stderr ? System.err : System.out;
        s2.print("test on System." + (stderr ? "err" : "out") + ":");
        for (jansiAnsi.Color c : jansiAnsi.Color.values()) {
            s2.print(" " + jansiAnsi.ansi().fg(c) + (Object)((Object)c) + jansiAnsi.ansi().reset());
        }
        s2.println();
        s2.print("            bright:");
        for (jansiAnsi.Color c : jansiAnsi.Color.values()) {
            s2.print(" " + jansiAnsi.ansi().fgBright(c) + (Object)((Object)c) + jansiAnsi.ansi().reset());
        }
        s2.println();
        s2.print("              bold:");
        for (jansiAnsi.Color c : jansiAnsi.Color.values()) {
            s2.print(" " + jansiAnsi.ansi().bold().fg(c) + (Object)((Object)c) + jansiAnsi.ansi().reset());
        }
        s2.println();
        s2.print("             faint:");
        for (jansiAnsi.Color c : jansiAnsi.Color.values()) {
            s2.print(" " + jansiAnsi.ansi().a(jansiAnsi.Attribute.INTENSITY_FAINT).fg(c) + (Object)((Object)c) + jansiAnsi.ansi().reset());
        }
        s2.println();
        s2.print("        bold+faint:");
        for (jansiAnsi.Color c : jansiAnsi.Color.values()) {
            s2.print(" " + jansiAnsi.ansi().bold().a(jansiAnsi.Attribute.INTENSITY_FAINT).fg(c) + (Object)((Object)c) + jansiAnsi.ansi().reset());
        }
        s2.println();
        jansiAnsi ansi = jansiAnsi.ansi();
        ansi.a("        256 colors: ");
        for (i2 = 0; i2 < 216; ++i2) {
            if (i2 > 0 && i2 % 36 == 0) {
                ansi.reset();
                ansi.newline();
                ansi.a("                    ");
            } else if (i2 > 0 && i2 % 6 == 0) {
                ansi.reset();
                ansi.a("  ");
            }
            int a0 = i2 % 6;
            int a1 = i2 / 6 % 6;
            int a2 = i2 / 36;
            ansi.bg(16 + a0 + a2 * 6 + a1 * 36).a(' ');
        }
        ansi.reset();
        s2.println(ansi);
        ansi = jansiAnsi.ansi();
        ansi.a("         truecolor: ");
        for (i2 = 0; i2 < 256; ++i2) {
            if (i2 > 0 && i2 % 48 == 0) {
                ansi.reset();
                ansi.newline();
                ansi.a("                    ");
            }
            int r = 255 - i2;
            int g = i2 * 2 > 255 ? 255 - 2 * i2 : 2 * i2;
            int b2 = i2;
            ansi.bgRgb(r, g, b2).fgRgb(255 - r, 255 - g, 255 - b2).a(i2 % 2 == 0 ? (char)'/' : '\\');
        }
        ansi.reset();
        s2.println(ansi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPomPropertiesVersion(String path2) throws IOException {
        InputStream in = jansiAnsiMain.class.getResourceAsStream("/META-INF/maven/" + path2 + "/pom.properties");
        if (in == null) {
            return null;
        }
        try {
            Properties p2 = new Properties();
            p2.load(in);
            String string = p2.getProperty("version");
            return string;
        }
        finally {
            jansiAnsiMain.closeQuietly(in);
        }
    }

    private static void printJansiLogoDemo() throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(jansiAnsiMain.class.getResourceAsStream("jansi.txt"), StandardCharsets.UTF_8));
        try {
            String l;
            while ((l = in.readLine()) != null) {
                System.out.println(l);
            }
        }
        finally {
            jansiAnsiMain.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileContent(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            byte[] buf = new byte[1024];
            int l = 0;
            while ((l = ((InputStream)in).read(buf)) >= 0) {
                System.out.write(buf, 0, l);
            }
        }
        finally {
            jansiAnsiMain.closeQuietly(in);
        }
    }

    private static void closeQuietly(Closeable c) {
        try {
            c.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }
}

