/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty;

import java.io.IOException;
import java.util.Locale;
import org.pkl.thirdparty.jansiAnsi;

public class jansiAnsiRenderer {
    public static final String BEGIN_TOKEN = "@|";
    public static final String END_TOKEN = "|@";
    public static final String CODE_TEXT_SEPARATOR = " ";
    public static final String CODE_LIST_SEPARATOR = ",";
    private static final int BEGIN_TOKEN_LEN = 2;
    private static final int END_TOKEN_LEN = 2;

    public static String render(String input2) throws IllegalArgumentException {
        try {
            return jansiAnsiRenderer.render(input2, new StringBuilder()).toString();
        }
        catch (IOException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static Appendable render(String input2, Appendable target) throws IOException {
        int i2 = 0;
        while (true) {
            int j;
            if ((j = input2.indexOf(BEGIN_TOKEN, i2)) == -1) {
                if (i2 == 0) {
                    target.append(input2);
                    return target;
                }
                target.append(input2.substring(i2));
                return target;
            }
            target.append(input2.substring(i2, j));
            int k = input2.indexOf(END_TOKEN, j);
            if (k == -1) {
                target.append(input2);
                return target;
            }
            if (k < (j += 2)) {
                throw new IllegalArgumentException("Invalid input string found.");
            }
            String spec = input2.substring(j, k);
            String[] items = spec.split(CODE_TEXT_SEPARATOR, 2);
            if (items.length == 1) {
                target.append(input2);
                return target;
            }
            String replacement = jansiAnsiRenderer.render(items[1], items[0].split(CODE_LIST_SEPARATOR));
            target.append(replacement);
            i2 = k + 2;
        }
    }

    public static String render(String text, String ... codes) {
        return jansiAnsiRenderer.render(jansiAnsi.ansi(), codes).a(text).reset().toString();
    }

    public static String renderCodes(String ... codes) {
        return jansiAnsiRenderer.render(jansiAnsi.ansi(), codes).toString();
    }

    public static String renderCodes(String codes) {
        return jansiAnsiRenderer.renderCodes(codes.split("\\s"));
    }

    private static jansiAnsi render(jansiAnsi ansi, String ... names2) {
        for (String name : names2) {
            Code code2 = Code.valueOf(name.toUpperCase(Locale.ENGLISH));
            if (code2.isColor()) {
                if (code2.isBackground()) {
                    ansi.bg(code2.getColor());
                    continue;
                }
                ansi.fg(code2.getColor());
                continue;
            }
            if (!code2.isAttribute()) continue;
            ansi.a(code2.getAttribute());
        }
        return ansi;
    }

    public static boolean test(String text) {
        return text != null && text.contains(BEGIN_TOKEN);
    }

    private jansiAnsiRenderer() {
    }

    public static enum Code {
        BLACK(jansiAnsi.Color.BLACK),
        RED(jansiAnsi.Color.RED),
        GREEN(jansiAnsi.Color.GREEN),
        YELLOW(jansiAnsi.Color.YELLOW),
        BLUE(jansiAnsi.Color.BLUE),
        MAGENTA(jansiAnsi.Color.MAGENTA),
        CYAN(jansiAnsi.Color.CYAN),
        WHITE(jansiAnsi.Color.WHITE),
        DEFAULT(jansiAnsi.Color.DEFAULT),
        FG_BLACK(jansiAnsi.Color.BLACK, false),
        FG_RED(jansiAnsi.Color.RED, false),
        FG_GREEN(jansiAnsi.Color.GREEN, false),
        FG_YELLOW(jansiAnsi.Color.YELLOW, false),
        FG_BLUE(jansiAnsi.Color.BLUE, false),
        FG_MAGENTA(jansiAnsi.Color.MAGENTA, false),
        FG_CYAN(jansiAnsi.Color.CYAN, false),
        FG_WHITE(jansiAnsi.Color.WHITE, false),
        FG_DEFAULT(jansiAnsi.Color.DEFAULT, false),
        BG_BLACK(jansiAnsi.Color.BLACK, true),
        BG_RED(jansiAnsi.Color.RED, true),
        BG_GREEN(jansiAnsi.Color.GREEN, true),
        BG_YELLOW(jansiAnsi.Color.YELLOW, true),
        BG_BLUE(jansiAnsi.Color.BLUE, true),
        BG_MAGENTA(jansiAnsi.Color.MAGENTA, true),
        BG_CYAN(jansiAnsi.Color.CYAN, true),
        BG_WHITE(jansiAnsi.Color.WHITE, true),
        BG_DEFAULT(jansiAnsi.Color.DEFAULT, true),
        RESET(jansiAnsi.Attribute.RESET),
        INTENSITY_BOLD(jansiAnsi.Attribute.INTENSITY_BOLD),
        INTENSITY_FAINT(jansiAnsi.Attribute.INTENSITY_FAINT),
        ITALIC(jansiAnsi.Attribute.ITALIC),
        UNDERLINE(jansiAnsi.Attribute.UNDERLINE),
        BLINK_SLOW(jansiAnsi.Attribute.BLINK_SLOW),
        BLINK_FAST(jansiAnsi.Attribute.BLINK_FAST),
        BLINK_OFF(jansiAnsi.Attribute.BLINK_OFF),
        NEGATIVE_ON(jansiAnsi.Attribute.NEGATIVE_ON),
        NEGATIVE_OFF(jansiAnsi.Attribute.NEGATIVE_OFF),
        CONCEAL_ON(jansiAnsi.Attribute.CONCEAL_ON),
        CONCEAL_OFF(jansiAnsi.Attribute.CONCEAL_OFF),
        UNDERLINE_DOUBLE(jansiAnsi.Attribute.UNDERLINE_DOUBLE),
        UNDERLINE_OFF(jansiAnsi.Attribute.UNDERLINE_OFF),
        BOLD(jansiAnsi.Attribute.INTENSITY_BOLD),
        FAINT(jansiAnsi.Attribute.INTENSITY_FAINT);

        private final Enum<?> n;
        private final boolean background;

        private Code(Enum<?> n2, boolean background) {
            this.n = n2;
            this.background = background;
        }

        private Code(Enum<?> n2) {
            this(n2, false);
        }

        public boolean isColor() {
            return this.n instanceof jansiAnsi.Color;
        }

        public jansiAnsi.Color getColor() {
            return (jansiAnsi.Color)this.n;
        }

        public boolean isAttribute() {
            return this.n instanceof jansiAnsi.Attribute;
        }

        public jansiAnsi.Attribute getAttribute() {
            return (jansiAnsi.Attribute)this.n;
        }

        public boolean isBackground() {
            return this.background;
        }
    }
}

