/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.javapoet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import org.pkl.thirdparty.javapoet.ClassName;
import org.pkl.thirdparty.javapoet.CodeBlock;
import org.pkl.thirdparty.javapoet.CodeWriter;
import org.pkl.thirdparty.javapoet.TypeName;
import org.pkl.thirdparty.javapoet.Util;

public final class AnnotationSpec {
    public final TypeName type;
    public final Map<String, List<CodeBlock>> members;

    private AnnotationSpec(Builder builder) {
        this.type = builder.type;
        this.members = Util.immutableMultimap(builder.members);
    }

    void emit(CodeWriter codeWriter, boolean inline) throws IOException {
        String memberSeparator;
        String whitespace = inline ? "" : "\n";
        String string = memberSeparator = inline ? ", " : ",\n";
        if (this.members.isEmpty()) {
            codeWriter.emit("@$T", this.type);
        } else if (this.members.size() == 1 && this.members.containsKey("value")) {
            codeWriter.emit("@$T(", this.type);
            this.emitAnnotationValues(codeWriter, whitespace, memberSeparator, this.members.get("value"));
            codeWriter.emit(")");
        } else {
            codeWriter.emit("@$T(" + whitespace, this.type);
            codeWriter.indent(2);
            Iterator<Map.Entry<String, List<CodeBlock>>> i2 = this.members.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry<String, List<CodeBlock>> entry = i2.next();
                codeWriter.emit("$L = ", entry.getKey());
                this.emitAnnotationValues(codeWriter, whitespace, memberSeparator, entry.getValue());
                if (!i2.hasNext()) continue;
                codeWriter.emit(memberSeparator);
            }
            codeWriter.unindent(2);
            codeWriter.emit(whitespace + ")");
        }
    }

    private void emitAnnotationValues(CodeWriter codeWriter, String whitespace, String memberSeparator, List<CodeBlock> values2) throws IOException {
        if (values2.size() == 1) {
            codeWriter.indent(2);
            codeWriter.emit(values2.get(0));
            codeWriter.unindent(2);
            return;
        }
        codeWriter.emit("{" + whitespace);
        codeWriter.indent(2);
        boolean first2 = true;
        for (CodeBlock codeBlock : values2) {
            if (!first2) {
                codeWriter.emit(memberSeparator);
            }
            codeWriter.emit(codeBlock);
            first2 = false;
        }
        codeWriter.unindent(2);
        codeWriter.emit(whitespace + "}");
    }

    public static AnnotationSpec get(Annotation annotation) {
        return AnnotationSpec.get(annotation, false);
    }

    public static AnnotationSpec get(Annotation annotation, boolean includeDefaultValues) {
        Builder builder = AnnotationSpec.builder(annotation.annotationType());
        try {
            Method[] methods2 = annotation.annotationType().getDeclaredMethods();
            Arrays.sort(methods2, Comparator.comparing(Method::getName));
            for (Method method : methods2) {
                Object value2 = method.invoke((Object)annotation, new Object[0]);
                if (!includeDefaultValues && Objects.deepEquals(value2, method.getDefaultValue())) continue;
                if (value2.getClass().isArray()) {
                    for (int i2 = 0; i2 < Array.getLength(value2); ++i2) {
                        builder.addMemberForValue(method.getName(), Array.get(value2, i2));
                    }
                    continue;
                }
                if (value2 instanceof Annotation) {
                    builder.addMember(method.getName(), "$L", AnnotationSpec.get((Annotation)value2));
                    continue;
                }
                builder.addMemberForValue(method.getName(), value2);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Reflecting " + annotation + " failed!", e2);
        }
        return builder.build();
    }

    public static AnnotationSpec get(AnnotationMirror annotation) {
        TypeElement element = (TypeElement)annotation.getAnnotationType().asElement();
        Builder builder = AnnotationSpec.builder(ClassName.get(element));
        Visitor visitor2 = new Visitor(builder);
        for (ExecutableElement executableElement : annotation.getElementValues().keySet()) {
            String name = executableElement.getSimpleName().toString();
            AnnotationValue value2 = annotation.getElementValues().get(executableElement);
            value2.accept(visitor2, name);
        }
        return builder.build();
    }

    public static Builder builder(ClassName type2) {
        Util.checkNotNull(type2, "type == null", new Object[0]);
        return new Builder(type2);
    }

    public static Builder builder(Class<?> type2) {
        return AnnotationSpec.builder(ClassName.get(type2));
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type);
        for (Map.Entry<String, List<CodeBlock>> entry : this.members.entrySet()) {
            builder.members.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder out2 = new StringBuilder();
        try {
            CodeWriter codeWriter = new CodeWriter(out2);
            codeWriter.emit("$L", this);
            return out2.toString();
        }
        catch (IOException e2) {
            throw new AssertionError();
        }
    }

    private static class Visitor
    extends SimpleAnnotationValueVisitor8<Builder, String> {
        final Builder builder;

        Visitor(Builder builder) {
            super(builder);
            this.builder = builder;
        }

        @Override
        protected Builder defaultAction(Object o, String name) {
            return this.builder.addMemberForValue(name, o);
        }

        @Override
        public Builder visitAnnotation(AnnotationMirror a2, String name) {
            return this.builder.addMember(name, "$L", AnnotationSpec.get(a2));
        }

        @Override
        public Builder visitEnumConstant(VariableElement c, String name) {
            return this.builder.addMember(name, "$T.$L", c.asType(), c.getSimpleName());
        }

        @Override
        public Builder visitType(TypeMirror t, String name) {
            return this.builder.addMember(name, "$T.class", t);
        }

        @Override
        public Builder visitArray(List<? extends AnnotationValue> values2, String name) {
            for (AnnotationValue annotationValue : values2) {
                annotationValue.accept(this, name);
            }
            return this.builder;
        }
    }

    public static final class Builder {
        private final TypeName type;
        public final Map<String, List<CodeBlock>> members = new LinkedHashMap<String, List<CodeBlock>>();

        private Builder(TypeName type2) {
            this.type = type2;
        }

        public Builder addMember(String name, String format, Object ... args2) {
            return this.addMember(name, CodeBlock.of(format, args2));
        }

        public Builder addMember(String name, CodeBlock codeBlock) {
            List values2 = this.members.computeIfAbsent(name, k -> new ArrayList());
            values2.add(codeBlock);
            return this;
        }

        Builder addMemberForValue(String memberName, Object value2) {
            Util.checkNotNull(memberName, "memberName == null", new Object[0]);
            Util.checkNotNull(value2, "value == null, constant non-null value expected for %s", memberName);
            Util.checkArgument(SourceVersion.isName(memberName), "not a valid name: %s", memberName);
            if (value2 instanceof Class) {
                return this.addMember(memberName, "$T.class", value2);
            }
            if (value2 instanceof Enum) {
                return this.addMember(memberName, "$T.$L", value2.getClass(), ((Enum)value2).name());
            }
            if (value2 instanceof String) {
                return this.addMember(memberName, "$S", value2);
            }
            if (value2 instanceof Float) {
                return this.addMember(memberName, "$Lf", value2);
            }
            if (value2 instanceof Character) {
                return this.addMember(memberName, "'$L'", Util.characterLiteralWithoutSingleQuotes(((Character)value2).charValue()));
            }
            return this.addMember(memberName, "$L", value2);
        }

        public AnnotationSpec build() {
            for (String name : this.members.keySet()) {
                Util.checkNotNull(name, "name == null", new Object[0]);
                Util.checkArgument(SourceVersion.isName(name), "not a valid name: %s", name);
            }
            return new AnnotationSpec(this);
        }
    }
}

