/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.javapoet;

import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import org.pkl.thirdparty.javapoet.AnnotationSpec;
import org.pkl.thirdparty.javapoet.CodeWriter;
import org.pkl.thirdparty.javapoet.TypeName;
import org.pkl.thirdparty.javapoet.TypeVariableName;
import org.pkl.thirdparty.javapoet.Util;

public final class ArrayTypeName
extends TypeName {
    public final TypeName componentType;

    private ArrayTypeName(TypeName componentType) {
        this(componentType, new ArrayList<AnnotationSpec>());
    }

    private ArrayTypeName(TypeName componentType, List<AnnotationSpec> annotations2) {
        super(annotations2);
        this.componentType = Util.checkNotNull(componentType, "rawType == null", new Object[0]);
    }

    @Override
    public ArrayTypeName annotated(List<AnnotationSpec> annotations2) {
        return new ArrayTypeName(this.componentType, this.concatAnnotations(annotations2));
    }

    @Override
    public TypeName withoutAnnotations() {
        return new ArrayTypeName(this.componentType);
    }

    @Override
    CodeWriter emit(CodeWriter out2) throws IOException {
        return this.emit(out2, false);
    }

    CodeWriter emit(CodeWriter out2, boolean varargs) throws IOException {
        this.emitLeafType(out2);
        return this.emitBrackets(out2, varargs);
    }

    private CodeWriter emitLeafType(CodeWriter out2) throws IOException {
        if (TypeName.asArray(this.componentType) != null) {
            return TypeName.asArray(this.componentType).emitLeafType(out2);
        }
        return this.componentType.emit(out2);
    }

    private CodeWriter emitBrackets(CodeWriter out2, boolean varargs) throws IOException {
        if (this.isAnnotated()) {
            out2.emit(" ");
            this.emitAnnotations(out2);
        }
        if (TypeName.asArray(this.componentType) == null) {
            return out2.emit(varargs ? "..." : "[]");
        }
        out2.emit("[]");
        return TypeName.asArray(this.componentType).emitBrackets(out2, varargs);
    }

    public static ArrayTypeName of(TypeName componentType) {
        return new ArrayTypeName(componentType);
    }

    public static ArrayTypeName of(Type componentType) {
        return ArrayTypeName.of(TypeName.get(componentType));
    }

    public static ArrayTypeName get(ArrayType mirror) {
        return ArrayTypeName.get(mirror, new LinkedHashMap<TypeParameterElement, TypeVariableName>());
    }

    static ArrayTypeName get(ArrayType mirror, Map<TypeParameterElement, TypeVariableName> typeVariables) {
        return new ArrayTypeName(ArrayTypeName.get(mirror.getComponentType(), typeVariables));
    }

    public static ArrayTypeName get(GenericArrayType type2) {
        return ArrayTypeName.get(type2, new LinkedHashMap<Type, TypeVariableName>());
    }

    static ArrayTypeName get(GenericArrayType type2, Map<Type, TypeVariableName> map2) {
        return ArrayTypeName.of(ArrayTypeName.get(type2.getGenericComponentType(), map2));
    }
}

