/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.javapoet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.SimpleElementVisitor8;
import org.pkl.thirdparty.javapoet.AnnotationSpec;
import org.pkl.thirdparty.javapoet.CodeWriter;
import org.pkl.thirdparty.javapoet.TypeName;
import org.pkl.thirdparty.javapoet.Util;

public final class ClassName
extends TypeName
implements Comparable<ClassName> {
    public static final ClassName OBJECT = ClassName.get(Object.class);
    private static final String NO_PACKAGE = "";
    final String packageName;
    final ClassName enclosingClassName;
    final String simpleName;
    private List<String> simpleNames;
    final String canonicalName;

    private ClassName(String packageName, ClassName enclosingClassName, String simpleName2) {
        this(packageName, enclosingClassName, simpleName2, Collections.emptyList());
    }

    private ClassName(String packageName, ClassName enclosingClassName, String simpleName2, List<AnnotationSpec> annotations2) {
        super(annotations2);
        this.packageName = Objects.requireNonNull(packageName, "packageName == null");
        this.enclosingClassName = enclosingClassName;
        this.simpleName = simpleName2;
        this.canonicalName = enclosingClassName != null ? enclosingClassName.canonicalName + '.' + simpleName2 : (packageName.isEmpty() ? simpleName2 : packageName + '.' + simpleName2);
    }

    @Override
    public ClassName annotated(List<AnnotationSpec> annotations2) {
        return new ClassName(this.packageName, this.enclosingClassName, this.simpleName, this.concatAnnotations(annotations2));
    }

    @Override
    public ClassName withoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        ClassName resultEnclosingClassName = this.enclosingClassName != null ? this.enclosingClassName.withoutAnnotations() : null;
        return new ClassName(this.packageName, resultEnclosingClassName, this.simpleName);
    }

    @Override
    public boolean isAnnotated() {
        return super.isAnnotated() || this.enclosingClassName != null && this.enclosingClassName.isAnnotated();
    }

    public String packageName() {
        return this.packageName;
    }

    public ClassName enclosingClassName() {
        return this.enclosingClassName;
    }

    public ClassName topLevelClassName() {
        return this.enclosingClassName != null ? this.enclosingClassName.topLevelClassName() : this;
    }

    public String reflectionName() {
        return this.enclosingClassName != null ? this.enclosingClassName.reflectionName() + '$' + this.simpleName : (this.packageName.isEmpty() ? this.simpleName : this.packageName + '.' + this.simpleName);
    }

    public List<String> simpleNames() {
        if (this.simpleNames != null) {
            return this.simpleNames;
        }
        if (this.enclosingClassName == null) {
            this.simpleNames = Collections.singletonList(this.simpleName);
        } else {
            ArrayList<String> mutableNames = new ArrayList<String>();
            mutableNames.addAll(this.enclosingClassName().simpleNames());
            mutableNames.add(this.simpleName);
            this.simpleNames = Collections.unmodifiableList(mutableNames);
        }
        return this.simpleNames;
    }

    public ClassName peerClass(String name) {
        return new ClassName(this.packageName, this.enclosingClassName, name);
    }

    public ClassName nestedClass(String name) {
        return new ClassName(this.packageName, this, name);
    }

    public String simpleName() {
        return this.simpleName;
    }

    public String canonicalName() {
        return this.canonicalName;
    }

    public static ClassName get(Class<?> clazz) {
        Util.checkNotNull(clazz, "clazz == null", new Object[0]);
        Util.checkArgument(!clazz.isPrimitive(), "primitive types cannot be represented as a ClassName", new Object[0]);
        Util.checkArgument(!Void.TYPE.equals(clazz), "'void' type cannot be represented as a ClassName", new Object[0]);
        Util.checkArgument(!clazz.isArray(), "array types cannot be represented as a ClassName", new Object[0]);
        String anonymousSuffix = NO_PACKAGE;
        while (clazz.isAnonymousClass()) {
            int lastDollar = clazz.getName().lastIndexOf(36);
            anonymousSuffix = clazz.getName().substring(lastDollar) + anonymousSuffix;
            clazz = clazz.getEnclosingClass();
        }
        String name = clazz.getSimpleName() + anonymousSuffix;
        if (clazz.getEnclosingClass() == null) {
            int lastDot = clazz.getName().lastIndexOf(46);
            String packageName = lastDot != -1 ? clazz.getName().substring(0, lastDot) : NO_PACKAGE;
            return new ClassName(packageName, null, name);
        }
        return ClassName.get(clazz.getEnclosingClass()).nestedClass(name);
    }

    public static ClassName bestGuess(String classNameString) {
        int p2 = 0;
        while (p2 < classNameString.length() && Character.isLowerCase(classNameString.codePointAt(p2))) {
            Util.checkArgument((p2 = classNameString.indexOf(46, p2) + 1) != 0, "couldn't make a guess for %s", classNameString);
        }
        String packageName = p2 == 0 ? NO_PACKAGE : classNameString.substring(0, p2 - 1);
        ClassName className = null;
        for (String simpleName2 : classNameString.substring(p2).split("\\.", -1)) {
            Util.checkArgument(!simpleName2.isEmpty() && Character.isUpperCase(simpleName2.codePointAt(0)), "couldn't make a guess for %s", classNameString);
            className = new ClassName(packageName, className, simpleName2);
        }
        return className;
    }

    public static ClassName get(String packageName, String simpleName2, String ... simpleNames) {
        ClassName className = new ClassName(packageName, null, simpleName2);
        for (String name : simpleNames) {
            className = className.nestedClass(name);
        }
        return className;
    }

    public static ClassName get(final TypeElement element) {
        Util.checkNotNull(element, "element == null", new Object[0]);
        final String simpleName2 = element.getSimpleName().toString();
        return element.getEnclosingElement().accept(new SimpleElementVisitor8<ClassName, Void>(){

            @Override
            public ClassName visitPackage(PackageElement packageElement, Void p2) {
                return new ClassName(packageElement.getQualifiedName().toString(), null, simpleName2);
            }

            @Override
            public ClassName visitType(TypeElement enclosingClass, Void p2) {
                return ClassName.get(enclosingClass).nestedClass(simpleName2);
            }

            @Override
            public ClassName visitUnknown(Element unknown, Void p2) {
                return ClassName.get(ClassName.NO_PACKAGE, simpleName2, new String[0]);
            }

            @Override
            public ClassName defaultAction(Element enclosingElement, Void p2) {
                throw new IllegalArgumentException("Unexpected type nesting: " + element);
            }
        }, null);
    }

    @Override
    public int compareTo(ClassName o) {
        return this.canonicalName.compareTo(o.canonicalName);
    }

    @Override
    CodeWriter emit(CodeWriter out2) throws IOException {
        boolean charsEmitted = false;
        for (ClassName className : this.enclosingClasses()) {
            String simpleName2;
            if (charsEmitted) {
                out2.emit(".");
                simpleName2 = className.simpleName;
            } else {
                if (!className.isAnnotated() && className != this) continue;
                String qualifiedName2 = out2.lookupName(className);
                int dot = qualifiedName2.lastIndexOf(46);
                if (dot != -1) {
                    out2.emitAndIndent(qualifiedName2.substring(0, dot + 1));
                    simpleName2 = qualifiedName2.substring(dot + 1);
                    charsEmitted = true;
                } else {
                    simpleName2 = qualifiedName2;
                }
            }
            if (className.isAnnotated()) {
                if (charsEmitted) {
                    out2.emit(" ");
                }
                className.emitAnnotations(out2);
            }
            out2.emit(simpleName2);
            charsEmitted = true;
        }
        return out2;
    }

    private List<ClassName> enclosingClasses() {
        ArrayList<ClassName> result2 = new ArrayList<ClassName>();
        ClassName c = this;
        while (c != null) {
            result2.add(c);
            c = c.enclosingClassName;
        }
        Collections.reverse(result2);
        return result2;
    }
}

