/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.jline.reader.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pkl.thirdparty.jline.reader.CompletingParsedLine;
import org.pkl.thirdparty.jline.reader.EOFError;
import org.pkl.thirdparty.jline.reader.ParsedLine;
import org.pkl.thirdparty.jline.reader.Parser;

public class DefaultParser
implements Parser {
    private char[] quoteChars = new char[]{'\'', '\"'};
    private char[] escapeChars = new char[]{'\\'};
    private boolean eofOnUnclosedQuote;
    private boolean eofOnEscapedNewLine;
    private char[] openingBrackets = null;
    private char[] closingBrackets = null;
    private String[] lineCommentDelims = null;
    private BlockCommentDelims blockCommentDelims = null;
    private String regexVariable = "[a-zA-Z_]+[a-zA-Z0-9_-]*((\\.|\\['|\\[\"|\\[)[a-zA-Z0-9_-]*(|']|\"]|]))?";
    private String regexCommand = "[:]?[a-zA-Z]+[a-zA-Z0-9_-]*";
    private int commandGroup = 4;

    public DefaultParser lineCommentDelims(String[] lineCommentDelims) {
        this.lineCommentDelims = lineCommentDelims;
        return this;
    }

    public DefaultParser blockCommentDelims(BlockCommentDelims blockCommentDelims) {
        this.blockCommentDelims = blockCommentDelims;
        return this;
    }

    public DefaultParser quoteChars(char[] chars2) {
        this.quoteChars = chars2;
        return this;
    }

    public DefaultParser escapeChars(char[] chars2) {
        this.escapeChars = chars2;
        return this;
    }

    public DefaultParser eofOnUnclosedQuote(boolean eofOnUnclosedQuote) {
        this.eofOnUnclosedQuote = eofOnUnclosedQuote;
        return this;
    }

    public DefaultParser eofOnUnclosedBracket(Bracket ... brackets) {
        this.setEofOnUnclosedBracket(brackets);
        return this;
    }

    public DefaultParser eofOnEscapedNewLine(boolean eofOnEscapedNewLine) {
        this.eofOnEscapedNewLine = eofOnEscapedNewLine;
        return this;
    }

    public DefaultParser regexVariable(String regexVariable) {
        this.regexVariable = regexVariable;
        return this;
    }

    public DefaultParser regexCommand(String regexCommand) {
        this.regexCommand = regexCommand;
        return this;
    }

    public DefaultParser commandGroup(int commandGroup) {
        this.commandGroup = commandGroup;
        return this;
    }

    public void setQuoteChars(char[] chars2) {
        this.quoteChars = chars2;
    }

    public char[] getQuoteChars() {
        return this.quoteChars;
    }

    public void setEscapeChars(char[] chars2) {
        this.escapeChars = chars2;
    }

    public char[] getEscapeChars() {
        return this.escapeChars;
    }

    public void setLineCommentDelims(String[] lineCommentDelims) {
        this.lineCommentDelims = lineCommentDelims;
    }

    public String[] getLineCommentDelims() {
        return this.lineCommentDelims;
    }

    public void setBlockCommentDelims(BlockCommentDelims blockCommentDelims) {
        this.blockCommentDelims = blockCommentDelims;
    }

    public BlockCommentDelims getBlockCommentDelims() {
        return this.blockCommentDelims;
    }

    public void setEofOnUnclosedQuote(boolean eofOnUnclosedQuote) {
        this.eofOnUnclosedQuote = eofOnUnclosedQuote;
    }

    public boolean isEofOnUnclosedQuote() {
        return this.eofOnUnclosedQuote;
    }

    public void setEofOnEscapedNewLine(boolean eofOnEscapedNewLine) {
        this.eofOnEscapedNewLine = eofOnEscapedNewLine;
    }

    public boolean isEofOnEscapedNewLine() {
        return this.eofOnEscapedNewLine;
    }

    public void setEofOnUnclosedBracket(Bracket ... brackets) {
        if (brackets == null) {
            this.openingBrackets = null;
            this.closingBrackets = null;
        } else {
            HashSet<Bracket> bs = new HashSet<Bracket>(Arrays.asList(brackets));
            this.openingBrackets = new char[bs.size()];
            this.closingBrackets = new char[bs.size()];
            int i2 = 0;
            for (Bracket b2 : bs) {
                switch (b2) {
                    case ROUND: {
                        this.openingBrackets[i2] = 40;
                        this.closingBrackets[i2] = 41;
                        break;
                    }
                    case CURLY: {
                        this.openingBrackets[i2] = 123;
                        this.closingBrackets[i2] = 125;
                        break;
                    }
                    case SQUARE: {
                        this.openingBrackets[i2] = 91;
                        this.closingBrackets[i2] = 93;
                        break;
                    }
                    case ANGLE: {
                        this.openingBrackets[i2] = 60;
                        this.closingBrackets[i2] = 62;
                    }
                }
                ++i2;
            }
        }
    }

    public void setRegexVariable(String regexVariable) {
        this.regexVariable = regexVariable;
    }

    public void setRegexCommand(String regexCommand) {
        this.regexCommand = regexCommand;
    }

    public void setCommandGroup(int commandGroup) {
        this.commandGroup = commandGroup;
    }

    @Override
    public boolean validCommandName(String name) {
        return name != null && name.matches(this.regexCommand);
    }

    @Override
    public boolean validVariableName(String name) {
        return name != null && this.regexVariable != null && name.matches(this.regexVariable);
    }

    @Override
    public String getCommand(String line) {
        boolean checkCommandOnly;
        String out2 = "";
        boolean bl = checkCommandOnly = this.regexVariable == null;
        if (!checkCommandOnly) {
            Pattern patternCommand = Pattern.compile("^\\s*" + this.regexVariable + "=(" + this.regexCommand + ")(\\s+|$)");
            Matcher matcher = patternCommand.matcher(line);
            if (matcher.find()) {
                out2 = matcher.group(this.commandGroup);
            } else {
                checkCommandOnly = true;
            }
        }
        if (checkCommandOnly && !(out2 = line.trim().split("\\s+")[0]).matches(this.regexCommand)) {
            out2 = "";
        }
        return out2;
    }

    @Override
    public String getVariable(String line) {
        Pattern patternCommand;
        Matcher matcher;
        String out2 = null;
        if (this.regexVariable != null && (matcher = (patternCommand = Pattern.compile("^\\s*(" + this.regexVariable + ")\\s*=[^=~].*")).matcher(line)).find()) {
            out2 = matcher.group(1);
        }
        return out2;
    }

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context2) {
        LinkedList<String> words2 = new LinkedList<String>();
        StringBuilder current2 = new StringBuilder();
        int wordCursor = -1;
        int wordIndex = -1;
        int quoteStart = -1;
        int rawWordCursor = -1;
        int rawWordLength = -1;
        int rawWordStart = 0;
        BracketChecker bracketChecker = new BracketChecker(cursor);
        boolean quotedWord = false;
        boolean lineCommented = false;
        boolean blockCommented = false;
        boolean blockCommentInRightOrder = true;
        String blockCommentEnd = this.blockCommentDelims == null ? null : this.blockCommentDelims.end;
        String blockCommentStart = this.blockCommentDelims == null ? null : this.blockCommentDelims.start;
        for (int i2 = 0; line != null && i2 < line.length(); ++i2) {
            if (i2 == cursor) {
                wordIndex = words2.size();
                wordCursor = current2.length();
                rawWordCursor = i2 - rawWordStart;
            }
            if (quoteStart < 0 && this.isQuoteChar(line, i2) && !lineCommented && !blockCommented) {
                quoteStart = i2;
                if (current2.length() == 0) {
                    quotedWord = true;
                    if (context2 != Parser.ParseContext.SPLIT_LINE) continue;
                    current2.append(line.charAt(i2));
                    continue;
                }
                current2.append(line.charAt(i2));
                continue;
            }
            if (quoteStart >= 0 && line.charAt(quoteStart) == line.charAt(i2) && !this.isEscaped(line, i2)) {
                if (!quotedWord || context2 == Parser.ParseContext.SPLIT_LINE) {
                    current2.append(line.charAt(i2));
                } else if (rawWordCursor >= 0 && rawWordLength < 0) {
                    rawWordLength = i2 - rawWordStart + 1;
                }
                quoteStart = -1;
                quotedWord = false;
                continue;
            }
            if (quoteStart < 0 && this.isDelimiter(line, i2)) {
                if (lineCommented) {
                    if (!this.isCommentDelim(line, i2, System.lineSeparator())) continue;
                    lineCommented = false;
                    continue;
                }
                if (blockCommented) {
                    if (!this.isCommentDelim(line, i2, blockCommentEnd)) continue;
                    blockCommented = false;
                    continue;
                }
                rawWordLength = this.handleDelimiterAndGetRawWordLength(current2, words2, rawWordStart, rawWordCursor, rawWordLength, i2);
                rawWordStart = i2 + 1;
                continue;
            }
            if (quoteStart < 0 && !blockCommented && (lineCommented || this.isLineCommentStarted(line, i2))) {
                lineCommented = true;
                continue;
            }
            if (quoteStart < 0 && !lineCommented && (blockCommented || this.isCommentDelim(line, i2, blockCommentStart))) {
                if (blockCommented) {
                    if (blockCommentEnd == null || !this.isCommentDelim(line, i2, blockCommentEnd)) continue;
                    blockCommented = false;
                    i2 += blockCommentEnd.length() - 1;
                    continue;
                }
                blockCommented = true;
                rawWordLength = this.handleDelimiterAndGetRawWordLength(current2, words2, rawWordStart, rawWordCursor, rawWordLength, i2);
                rawWordStart = (i2 += blockCommentStart == null ? 0 : blockCommentStart.length() - 1) + 1;
                continue;
            }
            if (quoteStart < 0 && !lineCommented && this.isCommentDelim(line, i2, blockCommentEnd)) {
                current2.append(line.charAt(i2));
                blockCommentInRightOrder = false;
                continue;
            }
            if (!this.isEscapeChar(line, i2)) {
                current2.append(line.charAt(i2));
                if (quoteStart >= 0) continue;
                bracketChecker.check(line, i2);
                continue;
            }
            if (context2 != Parser.ParseContext.SPLIT_LINE) continue;
            current2.append(line.charAt(i2));
        }
        if (current2.length() > 0 || cursor == line.length()) {
            words2.add(current2.toString());
            if (rawWordCursor >= 0 && rawWordLength < 0) {
                rawWordLength = line.length() - rawWordStart;
            }
        }
        if (cursor == line.length()) {
            wordIndex = words2.size() - 1;
            wordCursor = ((String)words2.get(words2.size() - 1)).length();
            rawWordLength = rawWordCursor = cursor - rawWordStart;
        }
        if (context2 != Parser.ParseContext.COMPLETE && context2 != Parser.ParseContext.SPLIT_LINE) {
            if (this.eofOnEscapedNewLine && this.isEscapeChar(line, line.length() - 1)) {
                throw new EOFError(-1, -1, "Escaped new line", "newline");
            }
            if (this.eofOnUnclosedQuote && quoteStart >= 0) {
                throw new EOFError(-1, -1, "Missing closing quote", line.charAt(quoteStart) == '\'' ? "quote" : "dquote");
            }
            if (blockCommented) {
                throw new EOFError(-1, -1, "Missing closing block comment delimiter", "add: " + blockCommentEnd);
            }
            if (!blockCommentInRightOrder) {
                throw new EOFError(-1, -1, "Missing opening block comment delimiter", "missing: " + blockCommentStart);
            }
            if (bracketChecker.isClosingBracketMissing() || bracketChecker.isOpeningBracketMissing()) {
                String message = null;
                String missing = null;
                if (bracketChecker.isClosingBracketMissing()) {
                    message = "Missing closing brackets";
                    missing = "add: " + bracketChecker.getMissingClosingBrackets();
                } else {
                    message = "Missing opening bracket";
                    missing = "missing: " + bracketChecker.getMissingOpeningBracket();
                }
                throw new EOFError(-1, -1, message, missing, bracketChecker.getOpenBrackets(), bracketChecker.getNextClosingBracket());
            }
        }
        String openingQuote = quotedWord ? line.substring(quoteStart, quoteStart + 1) : null;
        return new ArgumentList(line, words2, wordIndex, wordCursor, cursor, openingQuote, rawWordCursor, rawWordLength);
    }

    public boolean isDelimiter(CharSequence buffer, int pos) {
        return !this.isQuoted(buffer, pos) && !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    private int handleDelimiterAndGetRawWordLength(StringBuilder current2, List<String> words2, int rawWordStart, int rawWordCursor, int rawWordLength, int pos) {
        if (current2.length() > 0) {
            words2.add(current2.toString());
            current2.setLength(0);
            if (rawWordCursor >= 0 && rawWordLength < 0) {
                return pos - rawWordStart;
            }
        }
        return rawWordLength;
    }

    public boolean isQuoted(CharSequence buffer, int pos) {
        return false;
    }

    public boolean isQuoteChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        if (this.quoteChars != null) {
            for (char e2 : this.quoteChars) {
                if (e2 != buffer.charAt(pos)) continue;
                return !this.isEscaped(buffer, pos);
            }
        }
        return false;
    }

    private boolean isCommentDelim(CharSequence buffer, int pos, String pattern2) {
        int length2;
        if (pos < 0) {
            return false;
        }
        if (pattern2 != null && (length2 = pattern2.length()) <= buffer.length() - pos) {
            for (int i2 = 0; i2 < length2; ++i2) {
                if (pattern2.charAt(i2) == buffer.charAt(pos + i2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isLineCommentStarted(CharSequence buffer, int pos) {
        if (this.lineCommentDelims != null) {
            for (String comment : this.lineCommentDelims) {
                if (!this.isCommentDelim(buffer, pos, comment)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEscapeChar(char ch) {
        if (this.escapeChars != null) {
            for (char e2 : this.escapeChars) {
                if (e2 != ch) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEscapeChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        char ch = buffer.charAt(pos);
        return this.isEscapeChar(ch) && !this.isEscaped(buffer, pos);
    }

    public boolean isEscaped(CharSequence buffer, int pos) {
        if (pos <= 0) {
            return false;
        }
        return this.isEscapeChar(buffer, pos - 1);
    }

    public boolean isDelimiterChar(CharSequence buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }

    private boolean isRawEscapeChar(char key2) {
        if (this.escapeChars != null) {
            for (char e2 : this.escapeChars) {
                if (e2 != key2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRawQuoteChar(char key2) {
        if (this.quoteChars != null) {
            for (char e2 : this.quoteChars) {
                if (e2 != key2) continue;
                return true;
            }
        }
        return false;
    }

    public static class BlockCommentDelims {
        private final String start;
        private final String end;

        public BlockCommentDelims(String start2, String end2) {
            if (start2 == null || end2 == null || start2.isEmpty() || end2.isEmpty() || start2.equals(end2)) {
                throw new IllegalArgumentException("Bad block comment delimiter!");
            }
            this.start = start2;
            this.end = end2;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }
    }

    public static enum Bracket {
        ROUND,
        CURLY,
        SQUARE,
        ANGLE;

    }

    private class BracketChecker {
        private int missingOpeningBracket = -1;
        private List<Integer> nested = new ArrayList<Integer>();
        private int openBrackets = 0;
        private int cursor;
        private String nextClosingBracket;

        public BracketChecker(int cursor) {
            this.cursor = cursor;
        }

        public void check(CharSequence buffer, int pos) {
            if (DefaultParser.this.openingBrackets == null || pos < 0) {
                return;
            }
            int bid = this.bracketId(DefaultParser.this.openingBrackets, buffer, pos);
            if (bid >= 0) {
                this.nested.add(bid);
            } else {
                bid = this.bracketId(DefaultParser.this.closingBrackets, buffer, pos);
                if (bid >= 0) {
                    if (!this.nested.isEmpty() && bid == this.nested.get(this.nested.size() - 1)) {
                        this.nested.remove(this.nested.size() - 1);
                    } else {
                        this.missingOpeningBracket = bid;
                    }
                }
            }
            if (this.cursor > pos) {
                this.openBrackets = this.nested.size();
                if (this.nested.size() > 0) {
                    this.nextClosingBracket = String.valueOf(DefaultParser.this.closingBrackets[this.nested.get(this.nested.size() - 1)]);
                }
            }
        }

        public boolean isOpeningBracketMissing() {
            return this.missingOpeningBracket != -1;
        }

        public String getMissingOpeningBracket() {
            if (!this.isOpeningBracketMissing()) {
                return null;
            }
            return Character.toString(DefaultParser.this.openingBrackets[this.missingOpeningBracket]);
        }

        public boolean isClosingBracketMissing() {
            return !this.nested.isEmpty();
        }

        public String getMissingClosingBrackets() {
            if (!this.isClosingBracketMissing()) {
                return null;
            }
            StringBuilder out2 = new StringBuilder();
            for (int i2 = this.nested.size() - 1; i2 > -1; --i2) {
                out2.append(DefaultParser.this.closingBrackets[this.nested.get(i2)]);
            }
            return out2.toString();
        }

        public int getOpenBrackets() {
            return this.openBrackets;
        }

        public String getNextClosingBracket() {
            return this.nested.size() == 2 ? this.nextClosingBracket : null;
        }

        private int bracketId(char[] brackets, CharSequence buffer, int pos) {
            for (int i2 = 0; i2 < brackets.length; ++i2) {
                if (buffer.charAt(pos) != brackets[i2]) continue;
                return i2;
            }
            return -1;
        }
    }

    public class ArgumentList
    implements ParsedLine,
    CompletingParsedLine {
        private final String line;
        private final List<String> words;
        private final int wordIndex;
        private final int wordCursor;
        private final int cursor;
        private final String openingQuote;
        private final int rawWordCursor;
        private final int rawWordLength;

        @Deprecated
        public ArgumentList(String line, List<String> words2, int wordIndex, int wordCursor, int cursor) {
            this(line, words2, wordIndex, wordCursor, cursor, null, wordCursor, words2.get(wordIndex).length());
        }

        public ArgumentList(String line, List<String> words2, int wordIndex, int wordCursor, int cursor, String openingQuote, int rawWordCursor, int rawWordLength) {
            this.line = line;
            this.words = Collections.unmodifiableList(Objects.requireNonNull(words2));
            this.wordIndex = wordIndex;
            this.wordCursor = wordCursor;
            this.cursor = cursor;
            this.openingQuote = openingQuote;
            this.rawWordCursor = rawWordCursor;
            this.rawWordLength = rawWordLength;
        }

        @Override
        public int wordIndex() {
            return this.wordIndex;
        }

        @Override
        public String word() {
            if (this.wordIndex < 0 || this.wordIndex >= this.words.size()) {
                return "";
            }
            return this.words.get(this.wordIndex);
        }

        @Override
        public int wordCursor() {
            return this.wordCursor;
        }

        @Override
        public List<String> words() {
            return this.words;
        }

        @Override
        public int cursor() {
            return this.cursor;
        }

        @Override
        public String line() {
            return this.line;
        }

        @Override
        public CharSequence escape(CharSequence candidate, boolean complete) {
            int i3;
            StringBuilder sb = new StringBuilder(candidate);
            String quote = this.openingQuote;
            boolean middleQuotes = false;
            if (this.openingQuote == null) {
                for (i3 = 0; i3 < sb.length(); ++i3) {
                    if (!DefaultParser.this.isQuoteChar(sb, i3)) continue;
                    middleQuotes = true;
                    break;
                }
            }
            if (DefaultParser.this.escapeChars != null) {
                if (DefaultParser.this.escapeChars.length > 0) {
                    Predicate<Integer> needToBeEscaped = this.openingQuote != null ? i2 -> DefaultParser.this.isRawEscapeChar(sb.charAt((int)i2)) || String.valueOf(sb.charAt((int)i2)).equals(this.openingQuote) : (middleQuotes ? i2 -> DefaultParser.this.isRawEscapeChar(sb.charAt((int)i2)) : i2 -> DefaultParser.this.isDelimiterChar(sb, (int)i2) || DefaultParser.this.isRawEscapeChar(sb.charAt((int)i2)) || DefaultParser.this.isRawQuoteChar(sb.charAt((int)i2)));
                    for (i3 = 0; i3 < sb.length(); ++i3) {
                        if (!needToBeEscaped.test(i3)) continue;
                        sb.insert(i3++, DefaultParser.this.escapeChars[0]);
                    }
                }
            } else if (this.openingQuote == null && !middleQuotes) {
                for (i3 = 0; i3 < sb.length(); ++i3) {
                    if (!DefaultParser.this.isDelimiterChar(sb, i3)) continue;
                    quote = "'";
                    break;
                }
            }
            if (quote != null) {
                sb.insert(0, quote);
                if (complete) {
                    sb.append(quote);
                }
            }
            return sb;
        }

        @Override
        public int rawWordCursor() {
            return this.rawWordCursor;
        }

        @Override
        public int rawWordLength() {
            return this.rawWordLength;
        }
    }
}

