/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.jline.reader.impl.completer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.pkl.thirdparty.jline.reader.Candidate;
import org.pkl.thirdparty.jline.reader.Completer;
import org.pkl.thirdparty.jline.reader.LineReader;
import org.pkl.thirdparty.jline.reader.ParsedLine;

public class AggregateCompleter
implements Completer {
    private final Collection<Completer> completers;

    public AggregateCompleter(Completer ... completers) {
        this(Arrays.asList(completers));
    }

    public AggregateCompleter(Collection<Completer> completers) {
        assert (completers != null);
        this.completers = completers;
    }

    public Collection<Completer> getCompleters() {
        return this.completers;
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        Objects.requireNonNull(line);
        Objects.requireNonNull(candidates);
        this.completers.forEach(c -> c.complete(reader, line, candidates));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{completers=" + this.completers + '}';
    }
}

