/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.jline.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.IntConsumer;
import org.pkl.thirdparty.jline.terminal.Attributes;
import org.pkl.thirdparty.jline.terminal.Cursor;
import org.pkl.thirdparty.jline.terminal.Size;
import org.pkl.thirdparty.jline.terminal.Terminal;
import org.pkl.thirdparty.jline.terminal.impl.AbstractTerminal;
import org.pkl.thirdparty.jline.terminal.impl.CursorSupport;
import org.pkl.thirdparty.jline.terminal.spi.Pty;

public abstract class AbstractPosixTerminal
extends AbstractTerminal {
    protected final Pty pty;
    protected final Attributes originalAttributes;

    public AbstractPosixTerminal(String name, String type2, Pty pty) throws IOException {
        this(name, type2, pty, null, Terminal.SignalHandler.SIG_DFL);
    }

    public AbstractPosixTerminal(String name, String type2, Pty pty, Charset encoding, Terminal.SignalHandler signalHandler) throws IOException {
        super(name, type2, encoding, signalHandler);
        Objects.requireNonNull(pty);
        this.pty = pty;
        this.originalAttributes = this.pty.getAttr();
    }

    public Pty getPty() {
        return this.pty;
    }

    @Override
    public Attributes getAttributes() {
        try {
            return this.pty.getAttr();
        }
        catch (IOException e2) {
            throw new IOError(e2);
        }
    }

    @Override
    public void setAttributes(Attributes attr) {
        try {
            this.pty.setAttr(attr);
        }
        catch (IOException e2) {
            throw new IOError(e2);
        }
    }

    @Override
    public Size getSize() {
        try {
            return this.pty.getSize();
        }
        catch (IOException e2) {
            throw new IOError(e2);
        }
    }

    @Override
    public void setSize(Size size) {
        try {
            this.pty.setSize(size);
        }
        catch (IOException e2) {
            throw new IOError(e2);
        }
    }

    @Override
    protected void doClose() throws IOException {
        super.doClose();
        this.pty.setAttr(this.originalAttributes);
        this.pty.close();
    }

    @Override
    public Cursor getCursorPosition(IntConsumer discarded) {
        return CursorSupport.getCursorPosition(this, discarded);
    }
}

