/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.jline.terminal.impl;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ServiceLoader;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.pkl.thirdparty.jline.terminal.Attributes;
import org.pkl.thirdparty.jline.terminal.Terminal;
import org.pkl.thirdparty.jline.terminal.impl.AbstractPosixTerminal;
import org.pkl.thirdparty.jline.terminal.spi.TerminalProvider;
import org.pkl.thirdparty.jline.utils.OSUtils;

public class Diag {
    public static void main(String[] args2) {
        Diag.diag(System.out);
    }

    static void diag(PrintStream out2) {
        TerminalProvider provider;
        out2.println("System properties");
        out2.println("=================");
        out2.println("os.name =         " + System.getProperty("os.name"));
        out2.println("OSTYPE =          " + System.getenv("OSTYPE"));
        out2.println("MSYSTEM =         " + System.getenv("MSYSTEM"));
        out2.println("PWD =             " + System.getenv("PWD"));
        out2.println("ConEmuPID =       " + System.getenv("ConEmuPID"));
        out2.println("WSL_DISTRO_NAME = " + System.getenv("WSL_DISTRO_NAME"));
        out2.println("WSL_INTEROP =     " + System.getenv("WSL_INTEROP"));
        out2.println();
        out2.println("OSUtils");
        out2.println("=================");
        out2.println("IS_WINDOWS = " + OSUtils.IS_WINDOWS);
        out2.println("IS_CYGWIN =  " + OSUtils.IS_CYGWIN);
        out2.println("IS_MSYSTEM = " + OSUtils.IS_MSYSTEM);
        out2.println("IS_WSL =     " + OSUtils.IS_WSL);
        out2.println("IS_WSL1 =    " + OSUtils.IS_WSL1);
        out2.println("IS_WSL2 =    " + OSUtils.IS_WSL2);
        out2.println("IS_CONEMU =  " + OSUtils.IS_CONEMU);
        out2.println("IS_OSX =     " + OSUtils.IS_OSX);
        out2.println();
        out2.println("JnaSupport");
        out2.println("=================");
        try {
            provider = TerminalProvider.load("jna");
            Diag.testProvider(out2, provider);
        }
        catch (Throwable t) {
            out2.println("JNA support not available: " + t);
        }
        out2.println();
        out2.println("JansiSupport");
        out2.println("=================");
        try {
            provider = TerminalProvider.load("jansi");
            Diag.testProvider(out2, provider);
        }
        catch (Throwable t) {
            out2.println("Jansi support not available: " + t);
        }
        out2.println();
        out2.println("Exec Support");
        out2.println("=================");
        try {
            provider = TerminalProvider.load("exec");
            Diag.testProvider(out2, provider);
        }
        catch (Throwable t) {
            out2.println("Exec support not available: " + t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testProvider(PrintStream out2, TerminalProvider provider) {
        block19: {
            try {
                out2.println("StdIn stream =    " + provider.isSystemStream(TerminalProvider.Stream.Input));
                out2.println("StdOut stream =   " + provider.isSystemStream(TerminalProvider.Stream.Output));
                out2.println("StdErr stream =   " + provider.isSystemStream(TerminalProvider.Stream.Error));
            }
            catch (Throwable t2) {
                out2.println("Unable to check stream: " + t2);
            }
            try {
                out2.println("StdIn stream name =     " + provider.systemStreamName(TerminalProvider.Stream.Input));
                out2.println("StdOut stream name =    " + provider.systemStreamName(TerminalProvider.Stream.Output));
                out2.println("StdErr stream name =    " + provider.systemStreamName(TerminalProvider.Stream.Error));
            }
            catch (Throwable t2) {
                out2.println("Unable to check stream names: " + t2);
            }
            try (Terminal terminal = provider.sysTerminal("diag", "xterm", false, StandardCharsets.UTF_8, false, Terminal.SignalHandler.SIG_DFL, false, TerminalProvider.Stream.Output);){
                if (terminal != null) {
                    Attributes attr = terminal.enterRawMode();
                    try {
                        out2.println("Terminal size: " + terminal.getSize());
                        Future t = new ForkJoinPool(1).submit(() -> terminal.reader().read(1L));
                        int r = (Integer)((ForkJoinTask)t).get(1000L, TimeUnit.MILLISECONDS);
                        StringBuilder sb = new StringBuilder();
                        sb.append("The terminal seems to work: ");
                        sb.append("terminal ").append(terminal.getClass().getName());
                        if (terminal instanceof AbstractPosixTerminal) {
                            sb.append(" with pty ").append(((AbstractPosixTerminal)terminal).getPty().getClass().getName());
                        }
                        out2.println(sb);
                        terminal.setAttributes(attr);
                        break block19;
                    }
                    catch (Throwable t3) {
                        try {
                            out2.println("Unable to read from terminal: " + t3);
                            t3.printStackTrace();
                            break block19;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            terminal.setAttributes(attr);
                        }
                    }
                }
                out2.println("Not supported by provider");
            }
            catch (Throwable t2) {
                out2.println("Unable to open terminal: " + t2);
                t2.printStackTrace();
            }
        }
    }

    static <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }
}

