/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.jline.terminal.impl.exec;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import org.pkl.thirdparty.jline.terminal.Attributes;
import org.pkl.thirdparty.jline.terminal.Size;
import org.pkl.thirdparty.jline.terminal.Terminal;
import org.pkl.thirdparty.jline.terminal.impl.ExecPty;
import org.pkl.thirdparty.jline.terminal.impl.ExternalTerminal;
import org.pkl.thirdparty.jline.terminal.impl.PosixSysTerminal;
import org.pkl.thirdparty.jline.terminal.spi.Pty;
import org.pkl.thirdparty.jline.terminal.spi.TerminalProvider;
import org.pkl.thirdparty.jline.utils.ExecHelper;
import org.pkl.thirdparty.jline.utils.OSUtils;

public class ExecTerminalProvider
implements TerminalProvider {
    @Override
    public String name() {
        return "exec";
    }

    public Pty current(TerminalProvider.Stream consoleStream) throws IOException {
        return ExecPty.current(consoleStream);
    }

    @Override
    public Terminal sysTerminal(String name, String type2, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        if (OSUtils.IS_WINDOWS) {
            return this.winSysTerminal(name, type2, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, consoleStream);
        }
        return this.posixSysTerminal(name, type2, ansiPassThrough, encoding, nativeSignals, signalHandler, paused, consoleStream);
    }

    public Terminal winSysTerminal(String name, String type2, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        if (OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) {
            Pty pty = this.current(consoleStream);
            return new PosixSysTerminal(name, type2, pty, encoding, nativeSignals, signalHandler);
        }
        return null;
    }

    public Terminal posixSysTerminal(String name, String type2, boolean ansiPassThrough, Charset encoding, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused, TerminalProvider.Stream consoleStream) throws IOException {
        Pty pty = this.current(consoleStream);
        return new PosixSysTerminal(name, type2, pty, encoding, nativeSignals, signalHandler);
    }

    @Override
    public Terminal newTerminal(String name, String type2, InputStream in, OutputStream out2, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused, Attributes attributes2, Size size) throws IOException {
        return new ExternalTerminal(name, type2, in, out2, encoding, signalHandler, paused, attributes2, size);
    }

    @Override
    public boolean isSystemStream(TerminalProvider.Stream stream) {
        try {
            return this.isWindowsSystemStream(stream) || this.isPosixSystemStream(stream);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isWindowsSystemStream(TerminalProvider.Stream stream) {
        return this.systemStreamName(stream) != null;
    }

    public boolean isPosixSystemStream(TerminalProvider.Stream stream) {
        try {
            Process p2 = new ProcessBuilder(OSUtils.TEST_COMMAND, "-t", Integer.toString(stream.ordinal())).inheritIO().start();
            return p2.waitFor() == 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public String systemStreamName(TerminalProvider.Stream stream) {
        try {
            ProcessBuilder.Redirect input2 = stream == TerminalProvider.Stream.Input ? ProcessBuilder.Redirect.INHERIT : this.getRedirect(stream == TerminalProvider.Stream.Output ? FileDescriptor.out : FileDescriptor.err);
            Process p2 = new ProcessBuilder(OSUtils.TTY_COMMAND).redirectInput(input2).start();
            String result2 = ExecHelper.waitAndCapture(p2);
            if (p2.exitValue() == 0) {
                return result2.trim();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private ProcessBuilder.Redirect getRedirect(FileDescriptor fd) throws ReflectiveOperationException {
        Class<?> rpi = Class.forName("java.lang.ProcessBuilder$RedirectPipeImpl");
        Constructor<?> cns = rpi.getDeclaredConstructor(new Class[0]);
        cns.setAccessible(true);
        ProcessBuilder.Redirect input2 = (ProcessBuilder.Redirect)cns.newInstance(new Object[0]);
        Field f = rpi.getDeclaredField("fd");
        f.setAccessible(true);
        f.set(input2, fd);
        return input2;
    }
}

