/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.jline.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Objects;
import org.pkl.thirdparty.jline.utils.Log;

public final class ExecHelper {
    private ExecHelper() {
    }

    public static String exec(boolean redirectInput, String ... cmd) throws IOException {
        Objects.requireNonNull(cmd);
        try {
            Log.trace("Running: ", cmd);
            ProcessBuilder pb2 = new ProcessBuilder(cmd);
            if (redirectInput) {
                pb2.redirectInput(ProcessBuilder.Redirect.INHERIT);
            }
            Process p2 = pb2.start();
            String result2 = ExecHelper.waitAndCapture(p2);
            Log.trace("Result: ", result2);
            if (p2.exitValue() != 0) {
                if (result2.endsWith("\n")) {
                    result2 = result2.substring(0, result2.length() - 1);
                }
                throw new IOException("Error executing '" + String.join((CharSequence)" ", cmd) + "': " + result2);
            }
            return result2;
        }
        catch (InterruptedException e2) {
            throw (IOException)new InterruptedIOException("Command interrupted").initCause(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String waitAndCapture(Process p2) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        InputStream in = null;
        InputStream err = null;
        OutputStream out2 = null;
        try {
            int c;
            in = p2.getInputStream();
            while ((c = in.read()) != -1) {
                bout.write(c);
            }
            err = p2.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
            }
            out2 = p2.getOutputStream();
            p2.waitFor();
        }
        catch (Throwable throwable) {
            ExecHelper.close(in, out2, err);
            throw throwable;
        }
        ExecHelper.close(in, out2, err);
        return bout.toString();
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

