/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal;

import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.KType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.KTypeImpl;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.FqName;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"createMutableCollectionKType", "Lorg/pkl/thirdparty/kotlin/reflect/KType;", "type", "createNothingType", "createPlatformKType", "lowerBound", "upperBound", "readOnlyToMutable", "Lorg/pkl/thirdparty/kotlin/reflect/jvm/internal/impl/descriptors/ClassDescriptor;", "kotlin-reflection"})
public final class TypeOfImplKt {
    @NotNull
    public static final KType createPlatformKType(@NotNull KType lowerBound, @NotNull KType upperBound) {
        Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
        Intrinsics.checkNotNullParameter(upperBound, "upperBound");
        KotlinType kotlinType = ((KTypeImpl)lowerBound).getType();
        Intrinsics.checkNotNull(kotlinType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        SimpleType simpleType2 = (SimpleType)kotlinType;
        KotlinType kotlinType2 = ((KTypeImpl)upperBound).getType();
        Intrinsics.checkNotNull(kotlinType2, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        return new KTypeImpl(KotlinTypeFactory.flexibleType(simpleType2, (SimpleType)kotlinType2), null, 2, null);
    }

    @NotNull
    public static final KType createMutableCollectionKType(@NotNull KType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        KotlinType kotlinType = ((KTypeImpl)type2).getType();
        if (!(kotlinType instanceof SimpleType)) {
            boolean bl = false;
            String string = "Non-simple type cannot be a mutable collection type: " + type2;
            throw new IllegalArgumentException(string.toString());
        }
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            throw new IllegalArgumentException("Non-class type cannot be a mutable collection type: " + type2);
        }
        ClassDescriptor classifier2 = classDescriptor;
        SimpleType simpleType2 = (SimpleType)kotlinType;
        TypeConstructor typeConstructor2 = TypeOfImplKt.readOnlyToMutable(classifier2).getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "classifier.readOnlyToMutable().typeConstructor");
        return new KTypeImpl(KotlinTypeFactory.simpleType$default(simpleType2, null, typeConstructor2, null, false, 26, null), null, 2, null);
    }

    private static final ClassDescriptor readOnlyToMutable(ClassDescriptor $this$readOnlyToMutable) {
        FqName fqName2 = JavaToKotlinClassMap.INSTANCE.readOnlyToMutable(DescriptorUtilsKt.getFqNameUnsafe($this$readOnlyToMutable));
        if (fqName2 == null) {
            throw new IllegalArgumentException("Not a readonly collection: " + $this$readOnlyToMutable);
        }
        FqName fqName3 = fqName2;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getBuiltIns($this$readOnlyToMutable).getBuiltInClassByFqName(fqName3);
        Intrinsics.checkNotNullExpressionValue(classDescriptor, "builtIns.getBuiltInClassByFqName(fqName)");
        return classDescriptor;
    }

    @NotNull
    public static final KType createNothingType(@NotNull KType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        KotlinType kotlinType = ((KTypeImpl)type2).getType();
        if (!(kotlinType instanceof SimpleType)) {
            boolean bl = false;
            String string = "Non-simple type cannot be a Nothing type: " + type2;
            throw new IllegalArgumentException(string.toString());
        }
        SimpleType simpleType2 = (SimpleType)kotlinType;
        TypeConstructor typeConstructor2 = TypeUtilsKt.getBuiltIns(kotlinType).getNothing().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "kotlinType.builtIns.nothing.typeConstructor");
        return new KTypeImpl(KotlinTypeFactory.simpleType$default(simpleType2, null, typeConstructor2, null, false, 26, null), null, 2, null);
    }
}

