/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.impl;

import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.FqName;

public abstract class PackageFragmentDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements PackageFragmentDescriptor {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final String debugString;

    public PackageFragmentDescriptorImpl(@NotNull ModuleDescriptor module, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        super(module, Annotations.Companion.getEMPTY(), fqName2.shortNameOrSpecial(), SourceElement.NO_SOURCE);
        this.fqName = fqName2;
        this.debugString = "package " + this.fqName + " of " + module;
    }

    @Override
    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    @Override
    public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitPackageFragmentDescriptor(this, data2);
    }

    @Override
    @NotNull
    public ModuleDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = super.getContainingDeclaration();
        Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ModuleDescriptor");
        return (ModuleDescriptor)declarationDescriptor;
    }

    @Override
    @NotNull
    public SourceElement getSource() {
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
        return sourceElement;
    }

    @Override
    @NotNull
    public String toString() {
        return this.debugString;
    }
}

