/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.collections.SetsKt;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.FqName;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.Name;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindExclude;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeImpl;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;

public class SubpackagesScope
extends MemberScopeImpl {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final FqName fqName;

    public SubpackagesScope(@NotNull ModuleDescriptor moduleDescriptor, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        this.moduleDescriptor = moduleDescriptor;
        this.fqName = fqName2;
    }

    @Nullable
    protected final PackageViewDescriptor getPackage(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (name.isSpecial()) {
            return null;
        }
        FqName fqName2 = this.fqName.child(name);
        Intrinsics.checkNotNullExpressionValue(fqName2, "fqName.child(name)");
        PackageViewDescriptor packageViewDescriptor = this.moduleDescriptor.getPackage(fqName2);
        if (packageViewDescriptor.isEmpty()) {
            return null;
        }
        return packageViewDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        if (!kindFilter.acceptsKinds(DescriptorKindFilter.Companion.getPACKAGES_MASK())) {
            return org.pkl.thirdparty.kotlin.collections.CollectionsKt.emptyList();
        }
        if (this.fqName.isRoot() && kindFilter.getExcludes().contains(DescriptorKindExclude.TopLevelPackages.INSTANCE)) {
            return org.pkl.thirdparty.kotlin.collections.CollectionsKt.emptyList();
        }
        Collection<FqName> subFqNames = this.moduleDescriptor.getSubPackagesOf(this.fqName, nameFilter);
        ArrayList result2 = new ArrayList(subFqNames.size());
        for (FqName subFqName : subFqNames) {
            Name shortName;
            Intrinsics.checkNotNullExpressionValue(subFqName.shortName(), "subFqName.shortName()");
            if (!nameFilter.invoke(shortName).booleanValue()) continue;
            CollectionsKt.addIfNotNull(result2, this.getPackage(shortName));
        }
        return result2;
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    @NotNull
    public String toString() {
        return "subpackages of " + this.fqName + " from " + this.moduleDescriptor;
    }
}

