/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.util.Set;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaPackage;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.java.JavaClassFinder;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.ClassId;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.FqName;
import org.pkl.thirdparty.kotlin.text.StringsKt;

public final class ReflectJavaClassFinder
implements JavaClassFinder {
    @NotNull
    private final ClassLoader classLoader;

    public ReflectJavaClassFinder(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        ClassId classId = request.getClassId();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classId.packageFqName");
        FqName packageFqName = fqName2;
        String string = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "classId.relativeClassName.asString()");
        String relativeClassName = StringsKt.replace$default(string, '.', '$', false, 4, null);
        String name = packageFqName.isRoot() ? relativeClassName : packageFqName.asString() + '.' + relativeClassName;
        Class<?> klass = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, name);
        return klass != null ? (JavaClass)new ReflectJavaClass(klass) : null;
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName2, boolean mayHaveAnnotations) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return new ReflectJavaPackage(fqName2);
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return null;
    }
}

