/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.Function;
import org.pkl.thirdparty.kotlin.TuplesKt;
import org.pkl.thirdparty.kotlin.collections.ArraysKt;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.collections.MapsKt;
import org.pkl.thirdparty.kotlin.jvm.JvmClassMappingKt;
import org.pkl.thirdparty.kotlin.jvm.functions.Function0;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.functions.Function10;
import org.pkl.thirdparty.kotlin.jvm.functions.Function11;
import org.pkl.thirdparty.kotlin.jvm.functions.Function12;
import org.pkl.thirdparty.kotlin.jvm.functions.Function13;
import org.pkl.thirdparty.kotlin.jvm.functions.Function14;
import org.pkl.thirdparty.kotlin.jvm.functions.Function15;
import org.pkl.thirdparty.kotlin.jvm.functions.Function16;
import org.pkl.thirdparty.kotlin.jvm.functions.Function17;
import org.pkl.thirdparty.kotlin.jvm.functions.Function18;
import org.pkl.thirdparty.kotlin.jvm.functions.Function19;
import org.pkl.thirdparty.kotlin.jvm.functions.Function2;
import org.pkl.thirdparty.kotlin.jvm.functions.Function20;
import org.pkl.thirdparty.kotlin.jvm.functions.Function21;
import org.pkl.thirdparty.kotlin.jvm.functions.Function22;
import org.pkl.thirdparty.kotlin.jvm.functions.Function3;
import org.pkl.thirdparty.kotlin.jvm.functions.Function4;
import org.pkl.thirdparty.kotlin.jvm.functions.Function5;
import org.pkl.thirdparty.kotlin.jvm.functions.Function6;
import org.pkl.thirdparty.kotlin.jvm.functions.Function7;
import org.pkl.thirdparty.kotlin.jvm.functions.Function8;
import org.pkl.thirdparty.kotlin.jvm.functions.Function9;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.jvm.internal.Reflection;
import org.pkl.thirdparty.kotlin.reflect.KClass;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.ClassId;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.FqName;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.Name;
import org.pkl.thirdparty.kotlin.sequences.SequencesKt;
import org.pkl.thirdparty.kotlin.text.StringsKt;

public final class ReflectClassUtilKt {
    @NotNull
    private static final List<KClass<? extends Object>> PRIMITIVE_CLASSES;
    @NotNull
    private static final Map<Class<? extends Object>, Class<? extends Object>> WRAPPER_TO_PRIMITIVE;
    @NotNull
    private static final Map<Class<? extends Object>, Class<? extends Object>> PRIMITIVE_TO_WRAPPER;
    @NotNull
    private static final Map<Class<? extends Function<?>>, Integer> FUNCTION_CLASSES;

    @NotNull
    public static final ClassLoader getSafeClassLoader(@NotNull Class<?> $this$safeClassLoader) {
        Intrinsics.checkNotNullParameter($this$safeClassLoader, "<this>");
        ClassLoader classLoader = $this$safeClassLoader.getClassLoader();
        if (classLoader == null) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue(classLoader2, "getSystemClassLoader()");
        }
        return classLoader;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(@NotNull Class<?> $this$isEnumClassOrSpecializedEnumEntryClass) {
        Intrinsics.checkNotNullParameter($this$isEnumClassOrSpecializedEnumEntryClass, "<this>");
        return Enum.class.isAssignableFrom($this$isEnumClassOrSpecializedEnumEntryClass);
    }

    @Nullable
    public static final Class<?> getPrimitiveByWrapper(@NotNull Class<?> $this$primitiveByWrapper) {
        Intrinsics.checkNotNullParameter($this$primitiveByWrapper, "<this>");
        return WRAPPER_TO_PRIMITIVE.get($this$primitiveByWrapper);
    }

    @Nullable
    public static final Class<?> getWrapperByPrimitive(@NotNull Class<?> $this$wrapperByPrimitive) {
        Intrinsics.checkNotNullParameter($this$wrapperByPrimitive, "<this>");
        return PRIMITIVE_TO_WRAPPER.get($this$wrapperByPrimitive);
    }

    @Nullable
    public static final Integer getFunctionClassArity(@NotNull Class<?> $this$functionClassArity) {
        Intrinsics.checkNotNullParameter($this$functionClassArity, "<this>");
        return FUNCTION_CLASSES.get($this$functionClassArity);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final ClassId getClassId(@NotNull Class<?> $this$classId) {
        Object object;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter($this$classId, "<this>");
                if ($this$classId.isPrimitive()) {
                    throw new IllegalArgumentException("Can't compute ClassId for primitive type: " + $this$classId);
                }
                if ($this$classId.isArray()) {
                    throw new IllegalArgumentException("Can't compute ClassId for array type: " + $this$classId);
                }
                if ($this$classId.getEnclosingMethod() != null || $this$classId.getEnclosingConstructor() != null) break block6;
                String string = $this$classId.getSimpleName();
                Intrinsics.checkNotNullExpressionValue(string, "simpleName");
                if (!(((CharSequence)string).length() == 0)) break block7;
            }
            FqName fqName2 = new FqName($this$classId.getName());
            object = new ClassId(fqName2.parent(), FqName.topLevel(fqName2.shortName()), true);
            return object;
        }
        Class<?> clazz = $this$classId.getDeclaringClass();
        if (clazz == null || (clazz = ReflectClassUtilKt.getClassId(clazz)) == null || (clazz = ((ClassId)((Object)clazz)).createNestedClassId(Name.identifier($this$classId.getSimpleName()))) == null) {
            clazz = ClassId.topLevel(new FqName($this$classId.getName()));
        }
        object = clazz;
        Intrinsics.checkNotNullExpressionValue(clazz, "declaringClass?.classId?\u2026Id.topLevel(FqName(name))");
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String getDesc(@NotNull Class<?> $this$desc) {
        String string;
        block33: {
            Intrinsics.checkNotNullParameter($this$desc, "<this>");
            if (!$this$desc.isPrimitive()) break block33;
            String string2 = $this$desc.getName();
            if (string2 == null) throw new IllegalArgumentException("Unsupported primitive type: " + $this$desc);
            int n = -1;
            switch (string2.hashCode()) {
                case 64711720: {
                    if (string2.equals("boolean")) {
                        n = 1;
                    }
                    break;
                }
                case 3625364: {
                    if (string2.equals("void")) {
                        n = 2;
                    }
                    break;
                }
                case 3039496: {
                    if (string2.equals("byte")) {
                        n = 3;
                    }
                    break;
                }
                case -1325958191: {
                    if (string2.equals("double")) {
                        n = 4;
                    }
                    break;
                }
                case 3052374: {
                    if (string2.equals("char")) {
                        n = 5;
                    }
                    break;
                }
                case 109413500: {
                    if (string2.equals("short")) {
                        n = 6;
                    }
                    break;
                }
                case 97526364: {
                    if (string2.equals("float")) {
                        n = 7;
                    }
                    break;
                }
                case 104431: {
                    if (string2.equals("int")) {
                        n = 8;
                    }
                    break;
                }
                case 3327612: {
                    if (string2.equals("long")) {
                        n = 9;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return "Z";
                }
                case 5: {
                    return "C";
                }
                case 3: {
                    return "B";
                }
                case 6: {
                    return "S";
                }
                case 8: {
                    return "I";
                }
                case 7: {
                    return "F";
                }
                case 9: {
                    return "J";
                }
                case 4: {
                    return "D";
                }
                case 2: {
                    return "V";
                }
                default: {
                    throw new IllegalArgumentException("Unsupported primitive type: " + $this$desc);
                }
            }
        }
        if ($this$desc.isArray()) {
            String string3 = $this$desc.getName();
            Intrinsics.checkNotNullExpressionValue(string3, "name");
            string = StringsKt.replace$default(string3, '.', '/', false, 4, null);
            return string;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append('L');
            String string4 = $this$desc.getName();
            Intrinsics.checkNotNullExpressionValue(string4, "name");
            string = stringBuilder.append(StringsKt.replace$default(string4, '.', '/', false, 4, null)).append(';').toString();
        }
        return string;
    }

    @NotNull
    public static final List<Type> getParameterizedTypeArguments(@NotNull Type $this$parameterizedTypeArguments) {
        Intrinsics.checkNotNullParameter($this$parameterizedTypeArguments, "<this>");
        if (!($this$parameterizedTypeArguments instanceof ParameterizedType)) {
            return CollectionsKt.emptyList();
        }
        if (((ParameterizedType)$this$parameterizedTypeArguments).getOwnerType() == null) {
            Type[] typeArray = ((ParameterizedType)$this$parameterizedTypeArguments).getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue(typeArray, "actualTypeArguments");
            return ArraysKt.toList((Object[])typeArray);
        }
        return SequencesKt.toList(SequencesKt.flatMap(SequencesKt.generateSequence($this$parameterizedTypeArguments, (Function1)parameterizedTypeArguments.1.INSTANCE), parameterizedTypeArguments.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapIndexedTo$iv$iv;
        KClass it;
        boolean bl;
        Collection collection;
        Object $this$mapTo$iv$iv;
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Character.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE)};
        PRIMITIVE_CLASSES = CollectionsKt.listOf(kClassArray);
        Class[] $this$map$iv = (Class[])PRIMITIVE_CLASSES;
        boolean $i$f$map = false;
        Class[] classArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            KClass kClass = (KClass)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(TuplesKt.to(JvmClassMappingKt.getJavaObjectType(it), JvmClassMappingKt.getJavaPrimitiveType(it)));
        }
        WRAPPER_TO_PRIMITIVE = MapsKt.toMap((List)destination$iv$iv);
        $this$map$iv = PRIMITIVE_CLASSES;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (KClass)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(TuplesKt.to(JvmClassMappingKt.getJavaPrimitiveType(it), JvmClassMappingKt.getJavaObjectType(it)));
        }
        PRIMITIVE_TO_WRAPPER = MapsKt.toMap((List)destination$iv$iv);
        $this$map$iv = new Class[]{Function0.class, Function1.class, Function2.class, Function3.class, Function4.class, Function5.class, Function6.class, Function7.class, Function8.class, Function9.class, Function10.class, Function11.class, Function12.class, Function13.class, Function14.class, Function15.class, Function16.class, Function17.class, Function18.class, Function19.class, Function20.class, Function21.class, Function22.class};
        Iterable $this$mapIndexed$iv = CollectionsKt.listOf($this$map$iv);
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i2;
            void clazz;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Class clazz2 = (Class)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TuplesKt.to(clazz, (int)i2));
        }
        FUNCTION_CLASSES = MapsKt.toMap((List)var3_3);
    }
}

