/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.java;

import java.util.Map;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.java.NullabilityAnnotationStates;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.FqName;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.storage.LockBasedStorageManager;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;

public final class NullabilityAnnotationStatesImpl<T>
implements NullabilityAnnotationStates<T> {
    @NotNull
    private final Map<FqName, T> states;
    @NotNull
    private final LockBasedStorageManager storageManager;
    @NotNull
    private final MemoizedFunctionToNullable<FqName, T> cache;

    public NullabilityAnnotationStatesImpl(@NotNull Map<FqName, ? extends T> states) {
        Intrinsics.checkNotNullParameter(states, "states");
        this.states = states;
        this.storageManager = new LockBasedStorageManager("Java nullability annotation states");
        MemoizedFunctionToNullable memoizedFunctionToNullable = this.storageManager.createMemoizedFunctionWithNullableValues(new Function1<FqName, T>(this){
            final /* synthetic */ NullabilityAnnotationStatesImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final T invoke(FqName it) {
                Intrinsics.checkNotNullExpressionValue(it, "it");
                return FqNamesUtilKt.findValueForMostSpecificFqname(it, this.this$0.getStates());
            }
        });
        Intrinsics.checkNotNullExpressionValue(memoizedFunctionToNullable, "storageManager.createMem\u2026cificFqname(states)\n    }");
        this.cache = memoizedFunctionToNullable;
    }

    @NotNull
    public final Map<FqName, T> getStates() {
        return this.states;
    }

    @Override
    @Nullable
    public T get(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return (T)this.cache.invoke(fqName2);
    }
}

