/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.Pair;
import org.pkl.thirdparty.kotlin._Assertions;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawSubstitution;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.RawType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.pkl.thirdparty.kotlin.text.StringsKt;

public final class RawTypeImpl
extends FlexibleType
implements RawType {
    private RawTypeImpl(SimpleType lowerBound, SimpleType upperBound, boolean disableAssertion) {
        super(lowerBound, upperBound);
        if (!disableAssertion) {
            boolean bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(lowerBound, upperBound);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Lower bound " + lowerBound + " of a flexible type must be a subtype of the upper bound " + upperBound;
                throw new AssertionError((Object)string);
            }
        }
    }

    public RawTypeImpl(@NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
        Intrinsics.checkNotNullParameter(upperBound, "upperBound");
        this(lowerBound, upperBound, false);
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        return this.getLowerBound();
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        ClassifierDescriptor classifierDescriptor = this.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            throw new IllegalStateException(("Incorrect classifier: " + this.getConstructor().getDeclarationDescriptor()).toString());
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        MemberScope memberScope2 = classDescriptor2.getMemberScope(new RawSubstitution(null, 1, null));
        Intrinsics.checkNotNullExpressionValue(memberScope2, "classDescriptor.getMemberScope(RawSubstitution())");
        return memberScope2;
    }

    @Override
    @NotNull
    public RawTypeImpl replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter(newAttributes, "newAttributes");
        return new RawTypeImpl(this.getLowerBound().replaceAttributes(newAttributes), this.getUpperBound().replaceAttributes(newAttributes));
    }

    @Override
    @NotNull
    public RawTypeImpl makeNullableAsSpecified(boolean newNullability) {
        return new RawTypeImpl(this.getLowerBound().makeNullableAsSpecified(newNullability), this.getUpperBound().makeNullableAsSpecified(newNullability));
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options) {
        boolean bl;
        String newArgs2;
        String upperRendered;
        String lowerRendered;
        block6: {
            Intrinsics.checkNotNullParameter(renderer, "renderer");
            Intrinsics.checkNotNullParameter(options, "options");
            lowerRendered = renderer.renderType(this.getLowerBound());
            upperRendered = renderer.renderType(this.getUpperBound());
            if (options.getDebugMode()) {
                return "raw (" + lowerRendered + ".." + upperRendered + ')';
            }
            if (this.getUpperBound().getArguments().isEmpty()) {
                return renderer.renderFlexibleType(lowerRendered, upperRendered, TypeUtilsKt.getBuiltIns(this));
            }
            List<String> lowerArgs = RawTypeImpl.render$renderArguments(renderer, this.getLowerBound());
            List<String> upperArgs = RawTypeImpl.render$renderArguments(renderer, this.getUpperBound());
            newArgs2 = CollectionsKt.joinToString$default(lowerArgs, ", ", null, null, 0, null, render.newArgs.1.INSTANCE, 30, null);
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)lowerArgs, (Iterable)upperArgs);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (RawTypeImpl.render$onlyOutDiffers((String)it.getFirst(), (String)it.getSecond())) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        String newUpper = bl ? RawTypeImpl.render$replaceArgs(upperRendered, newArgs2) : upperRendered;
        String newLower = RawTypeImpl.render$replaceArgs(lowerRendered, newArgs2);
        if (Intrinsics.areEqual(newLower, newUpper)) {
            return newLower;
        }
        return renderer.renderFlexibleType(newLower, newUpper, TypeUtilsKt.getBuiltIns(this));
    }

    @Override
    @NotNull
    public FlexibleType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getLowerBound());
        Intrinsics.checkNotNull(kotlinType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        SimpleType simpleType2 = (SimpleType)kotlinType;
        KotlinType kotlinType2 = kotlinTypeRefiner.refineType(this.getUpperBound());
        Intrinsics.checkNotNull(kotlinType2, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        return new RawTypeImpl(simpleType2, (SimpleType)kotlinType2, true);
    }

    private static final boolean render$onlyOutDiffers(String first2, String second2) {
        return Intrinsics.areEqual(first2, StringsKt.removePrefix(second2, (CharSequence)"out ")) || Intrinsics.areEqual(second2, "*");
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> render$renderArguments(DescriptorRenderer $renderer, KotlinType type2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = type2.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($renderer.renderTypeProjection((TypeProjection)it));
        }
        return (List)destination$iv$iv;
    }

    private static final String render$replaceArgs(String $this$render_u24replaceArgs, String newArgs2) {
        if (!StringsKt.contains$default((CharSequence)$this$render_u24replaceArgs, '<', false, 2, null)) {
            return $this$render_u24replaceArgs;
        }
        return StringsKt.substringBefore$default($this$render_u24replaceArgs, '<', null, 2, null) + '<' + newArgs2 + '>' + StringsKt.substringAfterLast$default($this$render_u24replaceArgs, '>', null, 2, null);
    }
}

