/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.kotlin;

import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin._Assertions;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.ClassId;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;

public final class JavaClassDataFinder
implements ClassDataFinder {
    @NotNull
    private final KotlinClassFinder kotlinClassFinder;
    @NotNull
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkNotNullParameter(kotlinClassFinder, "kotlinClassFinder");
        Intrinsics.checkNotNullParameter(deserializedDescriptorResolver, "deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinClass2 = kotlinJvmBinaryClass;
        boolean bl = Intrinsics.areEqual(kotlinClass2.getClassId(), classId);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Class with incorrect id found: expected " + classId + ", actual " + kotlinClass2.getClassId();
            throw new AssertionError((Object)string);
        }
        return this.deserializedDescriptorResolver.readClassData$descriptors_jvm(kotlinClass2);
    }
}

