/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.load.kotlin.header;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.collections.ArraysKt;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.collections.MapsKt;
import org.pkl.thirdparty.kotlin.jvm.JvmStatic;
import org.pkl.thirdparty.kotlin.jvm.internal.DefaultConstructorMarker;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.ranges.RangesKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;

public final class KotlinClassHeader {
    @NotNull
    private final Kind kind;
    @NotNull
    private final JvmMetadataVersion metadataVersion;
    @Nullable
    private final String[] data;
    @Nullable
    private final String[] incompatibleData;
    @Nullable
    private final String[] strings;
    @Nullable
    private final String extraString;
    private final int extraInt;
    @Nullable
    private final String packageName;
    @Nullable
    private final byte[] serializedIr;

    public KotlinClassHeader(@NotNull Kind kind, @NotNull JvmMetadataVersion metadataVersion, @Nullable String[] data2, @Nullable String[] incompatibleData, @Nullable String[] strings, @Nullable String extraString, int extraInt, @Nullable String packageName, @Nullable byte[] serializedIr) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        this.kind = kind;
        this.metadataVersion = metadataVersion;
        this.data = data2;
        this.incompatibleData = incompatibleData;
        this.strings = strings;
        this.extraString = extraString;
        this.extraInt = extraInt;
        this.packageName = packageName;
        this.serializedIr = serializedIr;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public final JvmMetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Nullable
    public final String[] getData() {
        return this.data;
    }

    @Nullable
    public final String[] getIncompatibleData() {
        return this.incompatibleData;
    }

    @Nullable
    public final String[] getStrings() {
        return this.strings;
    }

    @Nullable
    public final String getMultifileClassName() {
        String string;
        String it = string = this.extraString;
        boolean bl = false;
        return this.kind == Kind.MULTIFILE_CLASS_PART ? string : null;
    }

    @NotNull
    public final List<String> getMultifilePartNames() {
        String[] stringArray;
        String[] it = stringArray = this.data;
        boolean bl = false;
        Object object = this.kind == Kind.MULTIFILE_CLASS ? stringArray : null;
        List<String> list = object != null ? ArraysKt.asList(object) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isUnstableJvmIrBinary() {
        return this.has(this.extraInt, 16) && !this.has(this.extraInt, 32);
    }

    public final boolean isUnstableFirBinary() {
        return this.has(this.extraInt, 64) && !this.has(this.extraInt, 32);
    }

    public final boolean isPreRelease() {
        return this.has(this.extraInt, 2);
    }

    @NotNull
    public String toString() {
        return (Object)((Object)this.kind) + " version=" + this.metadataVersion;
    }

    private final boolean has(int $this$has, int flag2) {
        return ($this$has & flag2) != 0;
    }

    public static final class Kind
    extends Enum<Kind> {
        @NotNull
        public static final Companion Companion;
        private final int id;
        @NotNull
        private static final Map<Integer, Kind> entryById;
        public static final /* enum */ Kind UNKNOWN;
        public static final /* enum */ Kind CLASS;
        public static final /* enum */ Kind FILE_FACADE;
        public static final /* enum */ Kind SYNTHETIC_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS_PART;
        private static final /* synthetic */ Kind[] $VALUES;

        private Kind(int id2) {
            this.id = id2;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value2) {
            return Enum.valueOf(Kind.class, value2);
        }

        @JvmStatic
        @NotNull
        public static final Kind getById(int id2) {
            return Companion.getById(id2);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            UNKNOWN = new Kind(0);
            CLASS = new Kind(1);
            FILE_FACADE = new Kind(2);
            SYNTHETIC_CLASS = new Kind(3);
            MULTIFILE_CLASS = new Kind(4);
            MULTIFILE_CLASS_PART = new Kind(5);
            $VALUES = kindArray = new Kind[]{Kind.UNKNOWN, Kind.CLASS, Kind.FILE_FACADE, Kind.SYNTHETIC_CLASS, Kind.MULTIFILE_CLASS, Kind.MULTIFILE_CLASS_PART};
            Companion = new Companion(null);
            Kind[] $this$associateBy$iv = Kind.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associateBy$iv.length), 16);
            Kind[] kindArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            int n = ((void)$this$associateByTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void p0;
                void element$iv$iv;
                void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[j];
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(p0.id, element$iv$iv);
            }
            entryById = destination$iv$iv;
        }

        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Kind getById(int id2) {
                Kind kind = (Kind)((Object)entryById.get(id2));
                if (kind == null) {
                    kind = UNKNOWN;
                }
                return kind;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

