/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.jvm.internal.DefaultConstructorMarker;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;

public abstract class JvmMemberSignature {
    private JvmMemberSignature() {
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getDesc();

    @NotNull
    public final String toString() {
        return this.asString();
    }

    @NotNull
    public abstract String asString();

    public /* synthetic */ JvmMemberSignature(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Method
    extends JvmMemberSignature {
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        public Method(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(desc, "desc");
            super(null);
            this.name = name;
            this.desc = desc;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String getDesc() {
            return this.desc;
        }

        @Override
        @NotNull
        public String asString() {
            return this.getName() + this.getDesc();
        }

        public int hashCode() {
            int result2 = this.getName().hashCode();
            result2 = result2 * 31 + this.getDesc().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Method)) {
                return false;
            }
            Method method = (Method)other;
            if (!Intrinsics.areEqual(this.getName(), method.getName())) {
                return false;
            }
            return Intrinsics.areEqual(this.getDesc(), method.getDesc());
        }
    }

    public static final class Field
    extends JvmMemberSignature {
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        public Field(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(desc, "desc");
            super(null);
            this.name = name;
            this.desc = desc;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public String getDesc() {
            return this.desc;
        }

        @Override
        @NotNull
        public String asString() {
            return this.getName() + ':' + this.getDesc();
        }

        @NotNull
        public final String component1() {
            return this.getName();
        }

        @NotNull
        public final String component2() {
            return this.getDesc();
        }

        public int hashCode() {
            int result2 = this.getName().hashCode();
            result2 = result2 * 31 + this.getDesc().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Field)) {
                return false;
            }
            Field field = (Field)other;
            if (!Intrinsics.areEqual(this.getName(), field.getName())) {
                return false;
            }
            return Intrinsics.areEqual(this.getDesc(), field.getDesc());
        }
    }
}

