/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.List;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.Name;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;

public interface ClassifierNamePolicy {
    @NotNull
    public String renderClassifier(@NotNull ClassifierDescriptor var1, @NotNull DescriptorRenderer var2);

    public static final class SHORT
    implements ClassifierNamePolicy {
        @NotNull
        public static final SHORT INSTANCE = new SHORT();

        private SHORT() {
        }

        @Override
        @NotNull
        public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
            Intrinsics.checkNotNullParameter(classifier2, "classifier");
            Intrinsics.checkNotNullParameter(renderer, "renderer");
            if (classifier2 instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifier2).getName();
                Intrinsics.checkNotNullExpressionValue(name, "classifier.name");
                return renderer.renderName(name, false);
            }
            ArrayList<Name> qualifiedNameElements = new ArrayList<Name>();
            DeclarationDescriptor current2 = classifier2;
            do {
                qualifiedNameElements.add(current2.getName());
            } while ((current2 = current2.getContainingDeclaration()) instanceof ClassDescriptor);
            return RenderingUtilsKt.renderFqName(CollectionsKt.asReversedMutable((List)qualifiedNameElements));
        }
    }

    public static final class FULLY_QUALIFIED
    implements ClassifierNamePolicy {
        @NotNull
        public static final FULLY_QUALIFIED INSTANCE = new FULLY_QUALIFIED();

        private FULLY_QUALIFIED() {
        }

        @Override
        @NotNull
        public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
            Intrinsics.checkNotNullParameter(classifier2, "classifier");
            Intrinsics.checkNotNullParameter(renderer, "renderer");
            if (classifier2 instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifier2).getName();
                Intrinsics.checkNotNullExpressionValue(name, "classifier.name");
                return renderer.renderName(name, false);
            }
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classifier2);
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "getFqName(classifier)");
            return renderer.renderFqName(fqNameUnsafe);
        }
    }

    public static final class SOURCE_CODE_QUALIFIED
    implements ClassifierNamePolicy {
        @NotNull
        public static final SOURCE_CODE_QUALIFIED INSTANCE = new SOURCE_CODE_QUALIFIED();

        private SOURCE_CODE_QUALIFIED() {
        }

        @Override
        @NotNull
        public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
            Intrinsics.checkNotNullParameter(classifier2, "classifier");
            Intrinsics.checkNotNullParameter(renderer, "renderer");
            return this.qualifiedNameForSourceCode(classifier2);
        }

        private final String qualifiedNameForSourceCode(ClassifierDescriptor descriptor2) {
            Name name = descriptor2.getName();
            Intrinsics.checkNotNullExpressionValue(name, "descriptor.name");
            String nameString = RenderingUtilsKt.render(name);
            if (descriptor2 instanceof TypeParameterDescriptor) {
                return nameString;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.containingDeclaration");
            String qualifier = this.qualifierName(declarationDescriptor);
            return qualifier != null && !Intrinsics.areEqual(qualifier, "") ? qualifier + '.' + nameString : nameString;
        }

        private final String qualifierName(DeclarationDescriptor descriptor2) {
            String string;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof ClassDescriptor) {
                string = this.qualifiedNameForSourceCode((ClassifierDescriptor)descriptor2);
            } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                FqNameUnsafe fqNameUnsafe = ((PackageFragmentDescriptor)descriptor2).getFqName().toUnsafe();
                Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "descriptor.fqName.toUnsafe()");
                string = RenderingUtilsKt.render(fqNameUnsafe);
            } else {
                string = null;
            }
            return string;
        }
    }
}

