/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.SimpleType;

public final class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char value2) {
        super(Character.valueOf(value2));
    }

    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module) {
        Intrinsics.checkNotNullParameter(module, "module");
        SimpleType simpleType2 = module.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "module.builtIns.charType");
        return simpleType2;
    }

    @Override
    @NotNull
    public String toString() {
        String string = "\\u%04X ('%s')";
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        return string2;
    }

    private final String getPrintablePart(char c) {
        char c2 = c;
        return c2 == '\b' ? "\\b" : (c2 == '\t' ? "\\t" : (c2 == '\n' ? "\\n" : (c2 == '\f' ? "\\f" : (c2 == '\r' ? "\\r" : (this.isPrintableUnicode(c) ? String.valueOf(c) : "?")))));
    }

    private final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }
}

