/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers;

import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ImplicitReceiver;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ThisClassReceiver;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.SimpleType;

public class ImplicitClassReceiver
implements ImplicitReceiver,
ThisClassReceiver {
    @NotNull
    private final ClassDescriptor classDescriptor;
    @NotNull
    private final ImplicitClassReceiver original;
    @NotNull
    private final ClassDescriptor declarationDescriptor;

    public ImplicitClassReceiver(@NotNull ClassDescriptor classDescriptor, @Nullable ImplicitClassReceiver original) {
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        this.classDescriptor = classDescriptor;
        ImplicitClassReceiver implicitClassReceiver = original;
        if (implicitClassReceiver == null) {
            implicitClassReceiver = this;
        }
        this.original = implicitClassReceiver;
        this.declarationDescriptor = this.classDescriptor;
    }

    @Override
    @NotNull
    public final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    @NotNull
    public SimpleType getType() {
        SimpleType simpleType2 = this.classDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "classDescriptor.defaultType");
        return simpleType2;
    }

    public boolean equals(@Nullable Object other) {
        ImplicitClassReceiver implicitClassReceiver = other instanceof ImplicitClassReceiver ? (ImplicitClassReceiver)other : null;
        return Intrinsics.areEqual(this.classDescriptor, implicitClassReceiver != null ? implicitClassReceiver.classDescriptor : null);
    }

    public int hashCode() {
        return this.classDescriptor.hashCode();
    }

    @NotNull
    public String toString() {
        return "Class{" + this.getType() + '}';
    }
}

