/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.collections.MapsKt;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.ranges.RangesKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.ClassId;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;

public final class ProtoBasedClassDataFinder
implements ClassDataFinder {
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final Function1<ClassId, SourceElement> classSource;
    @NotNull
    private final Map<ClassId, ProtoBuf.Class> classIdToProto;

    /*
     * WARNING - void declaration
     */
    public ProtoBasedClassDataFinder(@NotNull ProtoBuf.PackageFragment proto, @NotNull NameResolver nameResolver, @NotNull BinaryVersion metadataVersion, @NotNull Function1<? super ClassId, ? extends SourceElement> classSource) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Intrinsics.checkNotNullParameter(classSource, "classSource");
        this.nameResolver = nameResolver;
        this.metadataVersion = metadataVersion;
        this.classSource = classSource;
        List<ProtoBuf.Class> list = proto.getClass_List();
        Intrinsics.checkNotNullExpressionValue(list, "proto.class_List");
        Iterable iterable = list;
        ProtoBasedClassDataFinder protoBasedClassDataFinder = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        void var8_9 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void klass;
            ProtoBuf.Class clazz = (ProtoBuf.Class)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(NameResolverUtilKt.getClassId(this.nameResolver, klass.getFqName()), element$iv$iv);
        }
        protoBasedClassDataFinder.classIdToProto = destination$iv$iv;
    }

    @NotNull
    public final Collection<ClassId> getAllClassIds() {
        return this.classIdToProto.keySet();
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        ProtoBuf.Class clazz = this.classIdToProto.get(classId);
        if (clazz == null) {
            return null;
        }
        ProtoBuf.Class classProto = clazz;
        return new ClassData(this.nameResolver, classProto, this.metadataVersion, this.classSource.invoke(classId));
    }
}

