/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types;

import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin._Assertions;
import org.pkl.thirdparty.kotlin.jvm.internal.DefaultConstructorMarker;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeParameterDescriptorImpl;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.CustomTypeParameter;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.checker.NewTypeVariableConstructor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.checker.NullabilityChecker;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.model.DefinitelyNotNullTypeMarker;

public final class DefinitelyNotNullType
extends DelegatingSimpleType
implements CustomTypeParameter,
DefinitelyNotNullTypeMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleType original;
    private final boolean useCorrectedNullabilityForTypeParameters;

    private DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters) {
        this.original = original;
        this.useCorrectedNullabilityForTypeParameters = useCorrectedNullabilityForTypeParameters;
    }

    @NotNull
    public final SimpleType getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    protected SimpleType getDelegate() {
        return this.original;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    public boolean isTypeParameter() {
        return this.getDelegate().getConstructor() instanceof NewTypeVariableConstructor || this.getDelegate().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    @Override
    @NotNull
    public KotlinType substitutionResult(@NotNull KotlinType replacement) {
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(replacement.unwrap(), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public SimpleType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter(newAttributes, "newAttributes");
        return new DefinitelyNotNullType(this.getDelegate().replaceAttributes(newAttributes), this.useCorrectedNullabilityForTypeParameters);
    }

    @Override
    @NotNull
    public SimpleType makeNullableAsSpecified(boolean newNullability) {
        return newNullability ? this.getDelegate().makeNullableAsSpecified(newNullability) : (SimpleType)this;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getDelegate() + " & Any";
    }

    @Override
    @NotNull
    public DefinitelyNotNullType replaceDelegate(@NotNull SimpleType delegate2) {
        Intrinsics.checkNotNullParameter(delegate2, "delegate");
        return new DefinitelyNotNullType(delegate2, this.useCorrectedNullabilityForTypeParameters);
    }

    public /* synthetic */ DefinitelyNotNullType(SimpleType original, boolean useCorrectedNullabilityForTypeParameters, DefaultConstructorMarker $constructor_marker) {
        this(original, useCorrectedNullabilityForTypeParameters);
    }

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DefinitelyNotNullType makeDefinitelyNotNull(@NotNull UnwrappedType type2, boolean useCorrectedNullabilityForTypeParameters) {
            DefinitelyNotNullType definitelyNotNullType;
            Intrinsics.checkNotNullParameter(type2, "type");
            if (type2 instanceof DefinitelyNotNullType) {
                definitelyNotNullType = (DefinitelyNotNullType)type2;
            } else if (this.makesSenseToBeDefinitelyNotNull(type2, useCorrectedNullabilityForTypeParameters)) {
                if (type2 instanceof FlexibleType) {
                    boolean bl = Intrinsics.areEqual(((FlexibleType)type2).getLowerBound().getConstructor(), ((FlexibleType)type2).getUpperBound().getConstructor());
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl2 = false;
                        String string = "DefinitelyNotNullType for flexible type (" + type2 + ") can be created only from type variable with the same constructor for bounds";
                        throw new AssertionError((Object)string);
                    }
                }
                definitelyNotNullType = new DefinitelyNotNullType(FlexibleTypesKt.lowerIfFlexible(type2).makeNullableAsSpecified(false), useCorrectedNullabilityForTypeParameters, null);
            } else {
                definitelyNotNullType = null;
            }
            return definitelyNotNullType;
        }

        public static /* synthetic */ DefinitelyNotNullType makeDefinitelyNotNull$default(Companion companion, UnwrappedType unwrappedType, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.makeDefinitelyNotNull(unwrappedType, bl);
        }

        private final boolean makesSenseToBeDefinitelyNotNull(UnwrappedType type2, boolean useCorrectedNullabilityForFlexibleTypeParameters) {
            if (!this.canHaveUndefinedNullability(type2)) {
                return false;
            }
            if (type2 instanceof StubTypeForBuilderInference) {
                return TypeUtils.isNullableType(type2);
            }
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            TypeParameterDescriptorImpl typeParameterDescriptorImpl = classifierDescriptor instanceof TypeParameterDescriptorImpl ? (TypeParameterDescriptorImpl)classifierDescriptor : null;
            boolean bl = typeParameterDescriptorImpl != null ? !typeParameterDescriptorImpl.isInitialized() : false;
            if (bl) {
                return true;
            }
            if (useCorrectedNullabilityForFlexibleTypeParameters && type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                return TypeUtils.isNullableType(type2);
            }
            return !NullabilityChecker.INSTANCE.isSubtypeOfAny(type2);
        }

        private final boolean canHaveUndefinedNullability(UnwrappedType $this$canHaveUndefinedNullability) {
            return $this$canHaveUndefinedNullability.getConstructor() instanceof NewTypeVariableConstructor || $this$canHaveUndefinedNullability.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor || $this$canHaveUndefinedNullability instanceof NewCapturedType || $this$canHaveUndefinedNullability instanceof StubTypeForBuilderInference;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

