/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types;

import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.model.DynamicTypeMarker;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class DynamicType
extends FlexibleType
implements DynamicTypeMarker {
    @NotNull
    private final TypeAttributes attributes;

    public DynamicType(@NotNull KotlinBuiltIns builtIns, @NotNull TypeAttributes attributes2) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(attributes2, "attributes");
        SimpleType simpleType2 = builtIns.getNothingType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.nothingType");
        SimpleType simpleType3 = builtIns.getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue(simpleType3, "builtIns.nullableAnyType");
        super(simpleType2, simpleType3);
        this.attributes = attributes2;
    }

    @Override
    @NotNull
    public TypeAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        return this.getUpperBound();
    }

    @Override
    @NotNull
    public DynamicType makeNullableAsSpecified(boolean newNullability) {
        return this;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    @NotNull
    public DynamicType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter(newAttributes, "newAttributes");
        return new DynamicType(TypeUtilsKt.getBuiltIns(this.getDelegate()), newAttributes);
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options) {
        Intrinsics.checkNotNullParameter(renderer, "renderer");
        Intrinsics.checkNotNullParameter(options, "options");
        return "dynamic";
    }

    @Override
    @NotNull
    public DynamicType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return this;
    }
}

