/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types;

import java.util.Collection;
import java.util.List;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin._Assertions;
import org.pkl.thirdparty.kotlin.jvm.internal.DefaultConstructorMarker;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;

public final class IndexedParametersSubstitution
extends TypeSubstitution {
    @NotNull
    private final TypeParameterDescriptor[] parameters;
    @NotNull
    private final TypeProjection[] arguments;
    private final boolean approximateContravariantCapturedTypes;

    public IndexedParametersSubstitution(@NotNull TypeParameterDescriptor[] parameters2, @NotNull TypeProjection[] arguments2, boolean approximateContravariantCapturedTypes) {
        boolean bl;
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        this.parameters = parameters2;
        this.arguments = arguments2;
        this.approximateContravariantCapturedTypes = approximateContravariantCapturedTypes;
        boolean bl2 = bl = this.parameters.length <= this.arguments.length;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Number of arguments should not be less than number of parameters, but: parameters=" + this.parameters.length + ", args=" + this.arguments.length;
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ IndexedParametersSubstitution(TypeParameterDescriptor[] typeParameterDescriptorArray, TypeProjection[] typeProjectionArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(typeParameterDescriptorArray, typeProjectionArray, bl);
    }

    @NotNull
    public final TypeParameterDescriptor[] getParameters() {
        return this.parameters;
    }

    @NotNull
    public final TypeProjection[] getArguments() {
        return this.arguments;
    }

    public IndexedParametersSubstitution(@NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull List<? extends TypeProjection> argumentsList) {
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(argumentsList, "argumentsList");
        Collection $this$toTypedArray$iv = parameters2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TypeParameterDescriptor[] typeParameterDescriptorArray = thisCollection$iv.toArray(new TypeParameterDescriptor[0]);
        Intrinsics.checkNotNull(typeParameterDescriptorArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        $this$toTypedArray$iv = argumentsList;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        TypeProjection[] typeProjectionArray = thisCollection$iv.toArray(new TypeProjection[0]);
        Intrinsics.checkNotNull(typeProjectionArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        this(typeParameterDescriptorArray, typeProjectionArray, false, 4, null);
    }

    @Override
    public boolean isEmpty() {
        return this.arguments.length == 0;
    }

    @Override
    public boolean approximateContravariantCapturedTypes() {
        return this.approximateContravariantCapturedTypes;
    }

    @Override
    @Nullable
    public TypeProjection get(@NotNull KotlinType key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        ClassifierDescriptor classifierDescriptor = key2.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return null;
        }
        TypeParameterDescriptor parameter = typeParameterDescriptor;
        int index = parameter.getIndex();
        if (index < this.parameters.length && Intrinsics.areEqual(this.parameters[index].getTypeConstructor(), parameter.getTypeConstructor())) {
            return this.arguments[index];
        }
        return null;
    }
}

