/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.collections.SetsKt;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.name.Name;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.error.ErrorFunctionDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public class ErrorScope
implements MemberScope {
    @NotNull
    private final ErrorScopeKind kind;
    @NotNull
    private final String debugMessage;

    public ErrorScope(@NotNull ErrorScopeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        this.kind = kind;
        String[] stringArray = Arrays.copyOf(formatParams, formatParams.length);
        String string = String.format(this.kind.getDebugMessage(), Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        this.debugMessage = string;
    }

    @NotNull
    protected final String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    @NotNull
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        String string = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[]{name};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        Name name2 = Name.special(string2);
        Intrinsics.checkNotNullExpressionValue(name2, "special(ErrorEntity.ERRO\u2026S.debugText.format(name))");
        return new ErrorClassDescriptor(name2);
    }

    @NotNull
    public Set<PropertyDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return ErrorUtils.INSTANCE.getErrorPropertyGroup();
    }

    @NotNull
    public Set<SimpleFunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return SetsKt.setOf(new ErrorFunctionDescriptor(ErrorUtils.INSTANCE.getErrorClass()));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Set<Name> getFunctionNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<Name> getVariableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    @Override
    public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
    }

    @NotNull
    public String toString() {
        return "ErrorScope{" + this.debugMessage + '}';
    }
}

