/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.jvm.JvmOverloads;
import org.pkl.thirdparty.kotlin.jvm.internal.DefaultConstructorMarker;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;

public final class ErrorType
extends SimpleType {
    @NotNull
    private final TypeConstructor constructor;
    @NotNull
    private final MemberScope memberScope;
    @NotNull
    private final ErrorTypeKind kind;
    @NotNull
    private final List<TypeProjection> arguments;
    private final boolean isMarkedNullable;
    @NotNull
    private final String[] formatParams;
    @NotNull
    private final String debugMessage;

    @JvmOverloads
    public ErrorType(@NotNull TypeConstructor constructor, @NotNull MemberScope memberScope2, @NotNull ErrorTypeKind kind, @NotNull List<? extends TypeProjection> arguments2, boolean isMarkedNullable, String ... formatParams) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(memberScope2, "memberScope");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        this.constructor = constructor;
        this.memberScope = memberScope2;
        this.kind = kind;
        this.arguments = arguments2;
        this.isMarkedNullable = isMarkedNullable;
        this.formatParams = formatParams;
        String string = this.kind.getDebugMessage();
        String[] stringArray = this.formatParams;
        stringArray = Arrays.copyOf(stringArray, stringArray.length);
        String string2 = String.format(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        this.debugMessage = string2;
    }

    public /* synthetic */ ErrorType(TypeConstructor typeConstructor2, MemberScope memberScope2, ErrorTypeKind errorTypeKind, List list, boolean bl, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(typeConstructor2, memberScope2, errorTypeKind, list, bl, stringArray);
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        return this.memberScope;
    }

    @NotNull
    public final ErrorTypeKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    @NotNull
    public final String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    @NotNull
    public TypeAttributes getAttributes() {
        return TypeAttributes.Companion.getEmpty();
    }

    @Override
    @NotNull
    public SimpleType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter(newAttributes, "newAttributes");
        return this;
    }

    @Override
    @NotNull
    public SimpleType makeNullableAsSpecified(boolean newNullability) {
        String[] stringArray = this.formatParams;
        return new ErrorType(this.getConstructor(), this.getMemberScope(), this.kind, this.getArguments(), newNullability, Arrays.copyOf(stringArray, stringArray.length));
    }

    @Override
    @NotNull
    public ErrorType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return this;
    }
}

