/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.util;

import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.util.Check;

final class IsKPropertyCheck
implements Check {
    @NotNull
    public static final IsKPropertyCheck INSTANCE = new IsKPropertyCheck();
    @NotNull
    private static final String description = "second parameter must be of type KProperty<*> or its supertype";

    private IsKPropertyCheck() {
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @Override
    public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
        boolean bl;
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        ValueParameterDescriptor secondParameter = functionDescriptor.getValueParameters().get(1);
        Intrinsics.checkNotNullExpressionValue(secondParameter, "secondParameter");
        KotlinType kotlinType = ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(secondParameter));
        if (kotlinType != null) {
            KotlinType kotlinType2 = secondParameter.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "secondParameter.type");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, TypeUtilsKt.makeNotNullable(kotlinType2));
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }
}

