/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.List;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import org.pkl.thirdparty.kotlin.reflect.jvm.internal.impl.util.Check;

final class NoDefaultAndVarargsCheck
implements Check {
    @NotNull
    public static final NoDefaultAndVarargsCheck INSTANCE = new NoDefaultAndVarargsCheck();
    @NotNull
    private static final String description = "should not have varargs or parameters with default values";

    private NoDefaultAndVarargsCheck() {
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @Override
    public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
            List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "functionDescriptor.valueParameters");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (!DescriptorUtilsKt.declaresOrInheritsDefaultValue(it) && it.getVarargElementType() == null) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }
}

