/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlinx.html.dom;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.Lazy;
import org.pkl.thirdparty.kotlin.LazyKt;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.Unit;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlinx.html.Entities;
import org.pkl.thirdparty.kotlinx.html.Tag;
import org.pkl.thirdparty.kotlinx.html.TagConsumer;
import org.pkl.thirdparty.kotlinx.html.Unsafe;
import org.pkl.thirdparty.kotlinx.html.dom.HTMLDOMBuilder;
import org.pkl.thirdparty.kotlinx.html.org.w3c.dom.events.Event;
import org.pkl.thirdparty.w3c.domDocument;
import org.pkl.thirdparty.w3c.domElement;
import org.pkl.thirdparty.w3c.domNode;
import org.xml.sax.InputSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0002H\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0016J!\u0010$\u001a\u00020\u00172\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00170&\u00a2\u0006\u0002\b(H\u0016J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J,\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00170&H\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010.\u001a\u00020\u0017*\u00020\u0002H\u0002R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0013j\b\u0012\u0004\u0012\u00020\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/pkl/thirdparty/kotlinx/html/dom/HTMLDOMBuilder;", "Lorg/pkl/thirdparty/kotlinx/html/TagConsumer;", "Lorg/pkl/thirdparty/w3c/domElement;", "document", "Lorg/pkl/thirdparty/w3c/domDocument;", "(Lorg/w3c/dom/Document;)V", "UnsafeImpl", "org/pkl/thirdparty/kotlinx/html/dom/HTMLDOMBuilder$UnsafeImpl$1", "Lorg/pkl/thirdparty/kotlinx/html/dom/HTMLDOMBuilder$UnsafeImpl$1;", "getDocument", "()Lorg/w3c/dom/Document;", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "getDocumentBuilder", "()Ljavax/xml/parsers/DocumentBuilder;", "documentBuilder$delegate", "Lorg/pkl/thirdparty/kotlin/Lazy;", "lastLeaved", "path", "Ljava/util/ArrayList;", "Lorg/pkl/thirdparty/kotlin/collections/ArrayList;", "finalize", "onTagAttributeChange", "", "tag", "Lorg/pkl/thirdparty/kotlinx/html/Tag;", "attribute", "", "value", "onTagComment", "content", "", "onTagContent", "onTagContentEntity", "entity", "Lorg/pkl/thirdparty/kotlinx/html/Entities;", "onTagContentUnsafe", "block", "Lorg/pkl/thirdparty/kotlin/Function1;", "Lorg/pkl/thirdparty/kotlinx/html/Unsafe;", "Lorg/pkl/thirdparty/kotlin/ExtensionFunctionType;", "onTagEnd", "onTagEvent", "event", "Lorg/pkl/thirdparty/kotlinx/html/org/w3c/dom/events/Event;", "onTagStart", "setIdAttributeName", "kotlinx-html"})
public final class HTMLDOMBuilder
implements TagConsumer<domElement> {
    @NotNull
    private final domDocument document;
    @NotNull
    private final ArrayList<domElement> path;
    @Nullable
    private domElement lastLeaved;
    @NotNull
    private final Lazy documentBuilder$delegate;
    @NotNull
    private final UnsafeImpl.1 UnsafeImpl;

    public HTMLDOMBuilder(@NotNull domDocument document) {
        Intrinsics.checkNotNullParameter(document, "document");
        this.document = document;
        this.path = new ArrayList();
        this.documentBuilder$delegate = LazyKt.lazy(documentBuilder.2.INSTANCE);
        this.UnsafeImpl = new Unsafe(this){
            final /* synthetic */ HTMLDOMBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public void unaryPlus(@NotNull String $this$unaryPlus) {
                Intrinsics.checkNotNullParameter($this$unaryPlus, "<this>");
                domElement element = HTMLDOMBuilder.access$getDocumentBuilder(this.this$0).parse(new InputSource(new StringReader("<unsafeRoot>" + $this$unaryPlus + "</unsafeRoot>"))).getDocumentElement();
                domNode importNode = this.this$0.getDocument().importNode((domNode)element, true);
                if (!Intrinsics.areEqual(importNode.getNodeName(), "unsafeRoot")) {
                    boolean bl = false;
                    String string = "the document factory hasn't created an unsafeRoot node";
                    throw new IllegalStateException(string.toString());
                }
                domElement last2 = (domElement)CollectionsKt.last(HTMLDOMBuilder.access$getPath$p(this.this$0));
                while (importNode.hasChildNodes()) {
                    last2.appendChild(importNode.removeChild(importNode.getFirstChild()));
                }
            }

            public void unaryPlus(@NotNull Entities $this$unaryPlus) {
                Unsafe.DefaultImpls.unaryPlus(this, $this$unaryPlus);
            }

            public void raw(@NotNull String s2) {
                Unsafe.DefaultImpls.raw((Unsafe)this, s2);
            }

            public void raw(@NotNull Entities entity) {
                Unsafe.DefaultImpls.raw((Unsafe)this, entity);
            }

            public void raw(@NotNull Number n) {
                Unsafe.DefaultImpls.raw((Unsafe)this, n);
            }
        };
    }

    @NotNull
    public final domDocument getDocument() {
        return this.document;
    }

    private final DocumentBuilder getDocumentBuilder() {
        Lazy lazy = this.documentBuilder$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-documentBuilder>(...)");
        return (DocumentBuilder)t;
    }

    @Override
    public void onTagStart(@NotNull Tag tag) {
        domElement domElement2;
        Intrinsics.checkNotNullParameter(tag, "tag");
        if (tag.getNamespace() != null) {
            String string = tag.getNamespace();
            Intrinsics.checkNotNull(string);
            domElement2 = this.document.createElementNS(string, tag.getTagName());
        } else {
            domElement2 = this.document.createElement(tag.getTagName());
        }
        domElement element = domElement2;
        Iterable $this$forEach$iv = tag.getAttributesEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            element.setAttribute((String)it.getKey(), (String)it.getValue());
        }
        if (!((Collection)this.path).isEmpty()) {
            ((domElement)CollectionsKt.last((List)this.path)).appendChild((domNode)element);
        }
        this.path.add(element);
    }

    @Override
    public void onTagAttributeChange(@NotNull Tag tag, @NotNull String attribute, @Nullable String value2) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current tag");
        }
        domElement node = (domElement)CollectionsKt.last((List)this.path);
        boolean bl = false;
        if (value2 == null) {
            node.removeAttribute(attribute);
        } else {
            node.setAttribute(attribute, value2);
        }
    }

    @Override
    public void onTagEvent(@NotNull Tag tag, @NotNull String event, @NotNull Function1<? super Event, Unit> value2) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(value2, "value");
        throw new UnsupportedOperationException("You can't assign lambda event handler on JVM");
    }

    @Override
    public void onTagEnd(@NotNull Tag tag) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(tag, "tag");
                if (this.path.isEmpty()) break block2;
                String string = ((domElement)CollectionsKt.last((List)this.path)).getTagName();
                Intrinsics.checkNotNullExpressionValue(string, "path.last().tagName");
                String string2 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase()");
                String string3 = tag.getTagName().toLowerCase();
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase()");
                if (Intrinsics.areEqual(string2, string3)) break block3;
            }
            throw new IllegalStateException("We haven't entered tag " + tag.getTagName() + " but trying to leave");
        }
        domElement domElement2 = this.path.remove(CollectionsKt.getLastIndex((List)this.path));
        Intrinsics.checkNotNullExpressionValue(domElement2, "path.removeAt(path.lastIndex)");
        domElement element = domElement2;
        this.setIdAttributeName(element);
        this.lastLeaved = element;
    }

    @Override
    public void onTagContent(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter(content, "content");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current DOM node");
        }
        ((domElement)CollectionsKt.last((List)this.path)).appendChild((domNode)this.document.createTextNode(((Object)content).toString()));
    }

    @Override
    public void onTagComment(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter(content, "content");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current DOM node");
        }
        ((domElement)CollectionsKt.last((List)this.path)).appendChild((domNode)this.document.createComment(((Object)content).toString()));
    }

    @Override
    public void onTagContentEntity(@NotNull Entities entity) {
        Intrinsics.checkNotNullParameter((Object)entity, "entity");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current DOM node");
        }
        ((domElement)CollectionsKt.last((List)this.path)).appendChild((domNode)this.document.createEntityReference(entity.name()));
    }

    @Override
    @NotNull
    public domElement finalize() {
        domElement domElement2 = this.lastLeaved;
        if (domElement2 == null) {
            throw new IllegalStateException("No tags were emitted");
        }
        return domElement2;
    }

    @Override
    public void onTagContentUnsafe(@NotNull Function1<? super Unsafe, Unit> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        block.invoke(this.UnsafeImpl);
    }

    private final void setIdAttributeName(domElement $this$setIdAttributeName) {
        if ($this$setIdAttributeName.hasAttribute("id")) {
            $this$setIdAttributeName.setIdAttribute("id", true);
        }
    }

    @Override
    public void onTagError(@NotNull Tag tag, @NotNull Throwable exception) {
        TagConsumer.DefaultImpls.onTagError(this, tag, exception);
    }

    public static final /* synthetic */ DocumentBuilder access$getDocumentBuilder(HTMLDOMBuilder $this) {
        return $this.getDocumentBuilder();
    }

    public static final /* synthetic */ ArrayList access$getPath$p(HTMLDOMBuilder $this) {
        return $this.path;
    }
}

