/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.kotlinx.serialization.json.internal;

import java.util.Map;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.NoWhenBranchMatchedException;
import org.pkl.thirdparty.kotlin.Unit;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlinx.serialization.json.Json;
import org.pkl.thirdparty.kotlinx.serialization.json.JsonArray;
import org.pkl.thirdparty.kotlinx.serialization.json.JsonArraySerializer;
import org.pkl.thirdparty.kotlinx.serialization.json.JsonElement;
import org.pkl.thirdparty.kotlinx.serialization.json.JsonObject;
import org.pkl.thirdparty.kotlinx.serialization.json.JsonObjectSerializer;
import org.pkl.thirdparty.kotlinx.serialization.json.JsonPrimitive;
import org.pkl.thirdparty.kotlinx.serialization.json.internal.JsonExceptionsKt;
import org.pkl.thirdparty.kotlinx.serialization.json.internal.JsonTreeEncoder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/pkl/thirdparty/kotlinx/serialization/json/internal/JsonTreeMapEncoder;", "Lorg/pkl/thirdparty/kotlinx/serialization/json/internal/JsonTreeEncoder;", "json", "Lorg/pkl/thirdparty/kotlinx/serialization/json/Json;", "nodeConsumer", "Lorg/pkl/thirdparty/kotlin/Function1;", "Lorg/pkl/thirdparty/kotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/Json;Lkotlin/jvm/functions/Function1;)V", "isKey", "", "tag", "", "getCurrent", "putElement", "key", "element", "kotlinx-serialization-json"})
final class JsonTreeMapEncoder
extends JsonTreeEncoder {
    private String tag;
    private boolean isKey;

    public JsonTreeMapEncoder(@NotNull Json json2, @NotNull Function1<? super JsonElement, Unit> nodeConsumer) {
        Intrinsics.checkNotNullParameter(json2, "json");
        Intrinsics.checkNotNullParameter(nodeConsumer, "nodeConsumer");
        super(json2, nodeConsumer);
        this.isKey = true;
    }

    @Override
    public void putElement(@NotNull String key2, @NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter(key2, "key");
        Intrinsics.checkNotNullParameter(element, "element");
        if (this.isKey) {
            JsonElement jsonElement = element;
            if (!(jsonElement instanceof JsonPrimitive)) {
                if (jsonElement instanceof JsonObject) {
                    throw JsonExceptionsKt.InvalidKeyKindException(JsonObjectSerializer.INSTANCE.getDescriptor());
                }
                if (jsonElement instanceof JsonArray) {
                    throw JsonExceptionsKt.InvalidKeyKindException(JsonArraySerializer.INSTANCE.getDescriptor());
                }
                throw new NoWhenBranchMatchedException();
            }
            this.tag = ((JsonPrimitive)element).getContent();
            this.isKey = false;
        } else {
            Map<String, JsonElement> map2 = this.getContent();
            String string = this.tag;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("tag");
                string = null;
            }
            map2.put(string, element);
            this.isKey = true;
        }
    }

    @Override
    @NotNull
    public JsonElement getCurrent() {
        return new JsonObject(this.getContent());
    }
}

