/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.msgpack.value.impl;

import java.io.IOException;
import java.util.Arrays;
import org.pkl.thirdparty.msgpack.core.MessagePacker;
import org.pkl.thirdparty.msgpack.value.ImmutableStringValue;
import org.pkl.thirdparty.msgpack.value.Value;
import org.pkl.thirdparty.msgpack.value.ValueType;
import org.pkl.thirdparty.msgpack.value.impl.AbstractImmutableRawValue;

public class ImmutableStringValueImpl
extends AbstractImmutableRawValue
implements ImmutableStringValue {
    public ImmutableStringValueImpl(byte[] byArray) {
        super(byArray);
    }

    public ImmutableStringValueImpl(String string) {
        super(string);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public ImmutableStringValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableStringValue asStringValue() {
        return this;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packRawStringHeader(this.data.length);
        messagePacker.writePayload(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value2 = (Value)object;
        if (!value2.isStringValue()) {
            return false;
        }
        if (value2 instanceof ImmutableStringValueImpl) {
            ImmutableStringValueImpl immutableStringValueImpl = (ImmutableStringValueImpl)value2;
            return Arrays.equals(this.data, immutableStringValueImpl.data);
        }
        return Arrays.equals(this.data, value2.asStringValue().asByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

