/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.msgpack.value.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import org.pkl.thirdparty.msgpack.core.MessagePacker;
import org.pkl.thirdparty.msgpack.core.buffer.MessageBuffer;
import org.pkl.thirdparty.msgpack.value.ExtensionValue;
import org.pkl.thirdparty.msgpack.value.ImmutableExtensionValue;
import org.pkl.thirdparty.msgpack.value.ImmutableTimestampValue;
import org.pkl.thirdparty.msgpack.value.TimestampValue;
import org.pkl.thirdparty.msgpack.value.Value;
import org.pkl.thirdparty.msgpack.value.ValueType;
import org.pkl.thirdparty.msgpack.value.impl.AbstractImmutableValue;

public class ImmutableTimestampValueImpl
extends AbstractImmutableValue
implements ImmutableExtensionValue,
ImmutableTimestampValue {
    private final Instant instant;
    private byte[] data;

    public ImmutableTimestampValueImpl(Instant instant) {
        this.instant = instant;
    }

    @Override
    public boolean isTimestampValue() {
        return true;
    }

    @Override
    public byte getType() {
        return -1;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.EXTENSION;
    }

    @Override
    public ImmutableTimestampValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableExtensionValue asExtensionValue() {
        return this;
    }

    @Override
    public ImmutableTimestampValue asTimestampValue() {
        return this;
    }

    @Override
    public byte[] getData() {
        if (this.data == null) {
            byte[] byArray;
            long l = this.getEpochSecond();
            int n = this.getNano();
            if (l >>> 34 == 0L) {
                long l2 = (long)(n << 34) | l;
                if ((l2 & 0xFFFFFFFF00000000L) == 0L) {
                    byArray = new byte[4];
                    MessageBuffer.wrap(byArray).putInt(0, (int)l);
                } else {
                    byArray = new byte[8];
                    MessageBuffer.wrap(byArray).putLong(0, l2);
                }
            } else {
                byArray = new byte[12];
                MessageBuffer messageBuffer = MessageBuffer.wrap(byArray);
                messageBuffer.putInt(0, n);
                messageBuffer.putLong(4, l);
            }
            this.data = byArray;
        }
        return this.data;
    }

    @Override
    public long getEpochSecond() {
        return this.instant.getEpochSecond();
    }

    @Override
    public int getNano() {
        return this.instant.getNano();
    }

    @Override
    public long toEpochMillis() {
        return this.instant.toEpochMilli();
    }

    @Override
    public Instant toInstant() {
        return this.instant;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packTimestamp(this.instant);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value2 = (Value)object;
        if (!value2.isExtensionValue()) {
            return false;
        }
        ExtensionValue extensionValue = value2.asExtensionValue();
        if (extensionValue instanceof TimestampValue) {
            TimestampValue timestampValue = (TimestampValue)extensionValue;
            return this.instant.equals(timestampValue.toInstant());
        }
        return -1 == extensionValue.getType() && Arrays.equals(this.getData(), extensionValue.getData());
    }

    public int hashCode() {
        int n = -1;
        n *= 31;
        n = this.instant.hashCode();
        return n;
    }

    @Override
    public String toJson() {
        return "\"" + this.toInstant().toString() + "\"";
    }

    public String toString() {
        return this.toInstant().toString();
    }
}

