/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.pkl.thirdparty.jetbrains.annotations.Contract;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.paguro.collections.AbstractUnmodMap;
import org.pkl.thirdparty.paguro.collections.Equator;
import org.pkl.thirdparty.paguro.collections.ImMap;
import org.pkl.thirdparty.paguro.collections.MutMap;
import org.pkl.thirdparty.paguro.collections.PersistentTreeMap;
import org.pkl.thirdparty.paguro.collections.UnmodIterable;
import org.pkl.thirdparty.paguro.collections.UnmodIterator;
import org.pkl.thirdparty.paguro.collections.UnmodMap;
import org.pkl.thirdparty.paguro.function.Fn2;
import org.pkl.thirdparty.paguro.oneOf.Option;
import org.pkl.thirdparty.paguro.tuple.Tuple2;

public class PersistentHashMap<K, V>
extends AbstractUnmodMap<K, V>
implements ImMap<K, V>,
Serializable {
    @NotNull
    public static final PersistentHashMap<Object, Object> EMPTY = new PersistentHashMap(null, 0, null, false, null);
    @NotNull
    private final Equator<K> equator;
    private final int size;
    @Nullable
    private final transient INode<K, V> root;
    private final boolean hasNull;
    private final V nullValue;
    private static final long serialVersionUID = 20160903192900L;

    private static int mask(int hash, int shift) {
        return hash >>> shift & 0x1F;
    }

    private static <K> K k(Object @NotNull [] array, int i2) {
        return (K)array[i2];
    }

    private static <V> V v(Object @NotNull [] array, int i2) {
        return (V)array[i2];
    }

    private static <K, V> INode<K, V> iNode(Object @NotNull [] array, int i2) {
        return (INode)array[i2];
    }

    @NotNull
    public static <K, V> PersistentHashMap<K, V> empty() {
        return EMPTY;
    }

    @NotNull
    public static <K, V> MutHashMap<K, V> emptyMutable() {
        return PersistentHashMap.empty().mutable();
    }

    @NotNull
    public static <K, V> PersistentHashMap<K, V> empty(@Nullable Equator<K> e2) {
        return new PersistentHashMap<K, Object>(e2, 0, null, false, null);
    }

    @NotNull
    public static <K, V> MutHashMap<K, V> emptyMutable(Equator<K> e2) {
        return PersistentHashMap.empty(e2).mutable();
    }

    @NotNull
    public static <K, V> PersistentHashMap<K, V> ofEq(Equator<K> eq, @Nullable Iterable<Map.Entry<K, V>> es) {
        if (es == null) {
            return PersistentHashMap.empty(eq);
        }
        MutHashMap<K, V> map2 = PersistentHashMap.emptyMutable(eq);
        for (Map.Entry<K, V> entry : es) {
            if (entry == null) continue;
            map2.assoc((Object)entry.getKey(), (Object)entry.getValue());
        }
        return map2.immutable();
    }

    @NotNull
    public static <K, V> PersistentHashMap<K, V> of(@Nullable Iterable<Map.Entry<K, V>> kvPairs) {
        if (kvPairs == null) {
            return PersistentHashMap.empty();
        }
        PersistentHashMap<K, V> m = PersistentHashMap.empty();
        MutMap map2 = m.mutable();
        for (Map.Entry<K, V> entry : kvPairs) {
            if (entry == null) continue;
            ((MutHashMap)map2).assoc((Object)entry.getKey(), (Object)entry.getValue());
        }
        return ((MutHashMap)map2).immutable();
    }

    private PersistentHashMap(@Nullable Equator<K> eq, int sz, @Nullable INode<K, V> root, boolean hasNull, V nullValue) {
        this.equator = eq == null ? Equator.defaultEquator() : eq;
        this.size = sz;
        this.root = root;
        this.hasNull = hasNull;
        this.nullValue = nullValue;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    @NotNull
    public Equator<K> equator() {
        return this.equator;
    }

    @Override
    @NotNull
    public PersistentHashMap<K, V> assoc(K key2, V val) {
        if (key2 == null) {
            if (this.hasNull && val == this.nullValue) {
                return this;
            }
            return new PersistentHashMap<K, V>(this.equator, this.hasNull ? this.size : this.size + 1, this.root, true, val);
        }
        PersistentTreeMap.Box<Object> addedLeaf = new PersistentTreeMap.Box<Object>(null);
        INode<K, V> newroot = this.root == null ? BitmapIndexedNode.empty(this.equator) : this.root;
        if ((newroot = newroot.assoc(0, this.equator.hash(key2), key2, val, addedLeaf)) == this.root) {
            return this;
        }
        return new PersistentHashMap<K, V>(this.equator, addedLeaf.val == null ? this.size : this.size + 1, newroot, this.hasNull, this.nullValue);
    }

    @Override
    @NotNull
    public MutHashMap<K, V> mutable() {
        return new MutHashMap(this);
    }

    @Override
    @NotNull
    public Option<UnmodMap.UnEntry<K, V>> entry(K key2) {
        if (key2 == null) {
            return this.hasNull ? Option.some(Tuple2.of(null, this.nullValue)) : Option.none();
        }
        if (this.root == null) {
            return Option.none();
        }
        UnmodMap.UnEntry<K, V> entry = this.root.find(0, this.equator.hash(key2), key2);
        return Option.someOrNullNoneOf(entry);
    }

    @Override
    @NotNull
    public UnmodIterator<UnmodMap.UnEntry<K, V>> iterator() {
        return this.iterator(Tuple2::of);
    }

    @Override
    @NotNull
    public UnmodIterator<K> keyIterator() {
        return this.iterator(Fn2.Singletons.FIRST);
    }

    @Override
    @NotNull
    public UnmodIterator<V> valIterator() {
        return this.iterator(Fn2.Singletons.SECOND);
    }

    @NotNull
    private <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
        Iter<K, V, R> rootIter = this.root == null ? UnmodIterator.emptyUnmodIterator() : this.root.iterator(aFn);
        return this.hasNull ? new Iter<K, V, R>(rootIter, aFn, this.nullValue) : rootIter;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public PersistentHashMap<K, V> without(K key2) {
        if (key2 == null) {
            return this.hasNull ? new PersistentHashMap<K, Object>(this.equator, this.size - 1, this.root, false, null) : this;
        }
        if (this.root == null) {
            return this;
        }
        INode<K, V> newroot = this.root.without(0, this.equator.hash(key2), key2);
        if (newroot == this.root) {
            return this;
        }
        return new PersistentHashMap<K, V>(this.equator, this.size - 1, newroot, this.hasNull, this.nullValue);
    }

    private static <K, V> INode<K, V> @NotNull [] cloneAndSet(INode<K, V> @NotNull [] array, int i2, INode<K, V> a2) {
        INode[] clone = (INode[])array.clone();
        clone[i2] = a2;
        return clone;
    }

    private static Object @NotNull [] cloneAndSet(Object @NotNull [] array, int i2, Object a2) {
        Object[] clone = (Object[])array.clone();
        clone[i2] = a2;
        return clone;
    }

    private static Object @NotNull [] cloneAndSet(Object @NotNull [] array, int i2, int j, Object b2) {
        Object[] clone = (Object[])array.clone();
        clone[i2] = null;
        clone[j] = b2;
        return clone;
    }

    private static Object @NotNull [] removePair(Object @NotNull [] array, int i2) {
        Object[] newArray = new Object[array.length - 2];
        System.arraycopy(array, 0, newArray, 0, 2 * i2);
        System.arraycopy(array, 2 * (i2 + 1), newArray, 2 * i2, newArray.length - 2 * i2);
        return newArray;
    }

    private static <K, V> INode<K, V> createNode(@NotNull Equator<K> equator, int shift, K key1, V val1, int key2hash, K key2, V val2) {
        int key1hash = equator.hash(key1);
        if (key1hash == key2hash) {
            return new HashCollisionNode(equator, null, key1hash, 2, key1, val1, key2, val2);
        }
        PersistentTreeMap.Box<Object> addedLeaf = new PersistentTreeMap.Box<Object>(null);
        AtomicReference<Thread> edit = new AtomicReference<Thread>();
        return BitmapIndexedNode.empty(equator).assoc(edit, shift, key1hash, key1, val1, addedLeaf).assoc(edit, shift, key2hash, key2, val2, addedLeaf);
    }

    private static <K, V> INode<K, V> createNode(@NotNull Equator<K> equator, AtomicReference<Thread> edit, int shift, K key1, V val1, int key2hash, K key2, V val2) {
        int key1hash = equator.hash(key1);
        if (key1hash == key2hash) {
            return new HashCollisionNode(equator, null, key1hash, 2, key1, val1, key2, val2);
        }
        PersistentTreeMap.Box<Object> addedLeaf = new PersistentTreeMap.Box<Object>(null);
        return BitmapIndexedNode.empty(equator).assoc(edit, shift, key1hash, key1, val1, addedLeaf).assoc(edit, shift, key2hash, key2, val2, addedLeaf);
    }

    private static int bitpos(int hash, int shift) {
        return 1 << PersistentHashMap.mask(hash, shift);
    }

    private static final class NodeIter<K, V, R>
    implements UnmodIterator<R> {
        final Object[] array;
        private final Fn2<K, V, R> aFn;
        private int mutableIndex = 0;
        private R nextEntry = null;
        private boolean absent = true;
        private UnmodIterator<R> nextIter;

        NodeIter(Object[] array, Fn2<K, V, R> aFn) {
            this.array = array;
            this.aFn = aFn;
        }

        private boolean advance() {
            while (this.mutableIndex < this.array.length) {
                UnmodIterator<R> iter;
                int i2 = this.mutableIndex;
                this.mutableIndex = i2 + 2;
                if (this.array[i2] != null) {
                    this.nextEntry = this.aFn.apply((K)PersistentHashMap.k(this.array, i2), (V)PersistentHashMap.v(this.array, i2 + 1));
                    this.absent = false;
                    return true;
                }
                INode<K, V> node = PersistentHashMap.iNode(this.array, i2 + 1);
                if (node == null || (iter = node.iterator(this.aFn)) == null || !iter.hasNext()) continue;
                this.nextIter = iter;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            if (!this.absent || this.nextIter != null) {
                return true;
            }
            return this.advance();
        }

        @Override
        public R next() {
            Object ret = this.nextEntry;
            if (!this.absent) {
                this.nextEntry = null;
                this.absent = true;
                return ret;
            }
            if (this.nextIter != null) {
                ret = this.nextIter.next();
                if (!this.nextIter.hasNext()) {
                    this.nextIter = null;
                }
                return ret;
            }
            if (this.advance()) {
                return this.next();
            }
            throw new NoSuchElementException();
        }
    }

    private static final class HashCollisionNode<K, V>
    implements INode<K, V> {
        private final Equator<K> equator;
        final int hash;
        int count;
        Object[] array;
        final AtomicReference<Thread> edit;

        HashCollisionNode(Equator<K> eq, AtomicReference<Thread> edit, int hash, int count2, Object ... array) {
            this.equator = eq;
            this.edit = edit;
            this.hash = hash;
            this.count = count2;
            this.array = array;
        }

        @Override
        public INode<K, V> assoc(int shift, int hash, K key2, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            if (hash == this.hash) {
                int idx = this.findIndex(key2);
                if (idx != -1) {
                    if (this.array[idx + 1] == val) {
                        return this;
                    }
                    return new HashCollisionNode<K, V>(this.equator, null, hash, this.count, PersistentHashMap.cloneAndSet(this.array, idx + 1, val));
                }
                Object[] newArray = new Object[2 * (this.count + 1)];
                System.arraycopy(this.array, 0, newArray, 0, 2 * this.count);
                newArray[2 * this.count] = key2;
                newArray[2 * this.count + 1] = val;
                addedLeaf.val = addedLeaf;
                return new HashCollisionNode<K, V>(this.equator, this.edit, hash, this.count + 1, newArray);
            }
            return new BitmapIndexedNode<K, V>(this.equator, null, PersistentHashMap.bitpos(this.hash, shift), new Object[]{null, this}).assoc(shift, hash, key2, val, addedLeaf);
        }

        @Override
        public INode<K, V> without(int shift, int hash, K key2) {
            int idx = this.findIndex(key2);
            if (idx == -1) {
                return this;
            }
            if (this.count == 1) {
                return null;
            }
            return new HashCollisionNode<K, V>(this.equator, null, hash, this.count - 1, PersistentHashMap.removePair(this.array, idx / 2));
        }

        @Override
        public UnmodMap.UnEntry<K, V> find(int shift, int hash, K key2) {
            int idx = this.findIndex(key2);
            if (idx < 0) {
                return null;
            }
            if (this.equator.eq(key2, PersistentHashMap.k(this.array, idx))) {
                return Tuple2.of(PersistentHashMap.k(this.array, idx), PersistentHashMap.v(this.array, idx + 1));
            }
            return null;
        }

        @Override
        public <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
            return new NodeIter<K, V, R>(this.array, aFn);
        }

        private int findIndex(K key2) {
            for (int i2 = 0; i2 < 2 * this.count; i2 += 2) {
                if (!this.equator.eq(key2, PersistentHashMap.k(this.array, i2))) continue;
                return i2;
            }
            return -1;
        }

        private HashCollisionNode<K, V> ensureEditable(AtomicReference<Thread> edit) {
            if (this.edit == edit) {
                return this;
            }
            Object[] newArray = new Object[2 * (this.count + 1)];
            System.arraycopy(this.array, 0, newArray, 0, 2 * this.count);
            return new HashCollisionNode<K, V>(this.equator, edit, this.hash, this.count, newArray);
        }

        private HashCollisionNode<K, V> ensureEditable(AtomicReference<Thread> edit, int count2, Object[] array) {
            if (this.edit == edit) {
                this.array = array;
                this.count = count2;
                return this;
            }
            return new HashCollisionNode<K, V>(this.equator, edit, this.hash, count2, array);
        }

        private HashCollisionNode<K, V> editAndSet(AtomicReference<Thread> edit, int i2, Object a2) {
            HashCollisionNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i2] = a2;
            return editable;
        }

        private HashCollisionNode<K, V> editAndSet(AtomicReference<Thread> edit, int i2, Object a2, int j, Object b2) {
            HashCollisionNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i2] = a2;
            editable.array[j] = b2;
            return editable;
        }

        @Override
        public INode<K, V> assoc(AtomicReference<Thread> edit, int shift, int hash, K key2, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            if (hash == this.hash) {
                int idx = this.findIndex(key2);
                if (idx != -1) {
                    if (this.array[idx + 1] == val) {
                        return this;
                    }
                    return this.editAndSet(edit, idx + 1, val);
                }
                if (this.array.length > 2 * this.count) {
                    addedLeaf.val = addedLeaf;
                    HashCollisionNode<K, V> editable = this.editAndSet(edit, 2 * this.count, key2, 2 * this.count + 1, val);
                    ++editable.count;
                    return editable;
                }
                Object[] newArray = new Object[this.array.length + 2];
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                newArray[this.array.length] = key2;
                newArray[this.array.length + 1] = val;
                addedLeaf.val = addedLeaf;
                return this.ensureEditable(edit, this.count + 1, newArray);
            }
            return new BitmapIndexedNode<K, V>(this.equator, edit, PersistentHashMap.bitpos(this.hash, shift), new Object[]{null, this, null, null}).assoc(edit, shift, hash, key2, val, addedLeaf);
        }

        @Override
        public INode<K, V> without(AtomicReference<Thread> edit, int shift, int hash, K key2, PersistentTreeMap.Box<PersistentTreeMap.Box> removedLeaf) {
            int idx = this.findIndex(key2);
            if (idx == -1) {
                return this;
            }
            removedLeaf.val = removedLeaf;
            if (this.count == 1) {
                return null;
            }
            HashCollisionNode<K, V> editable = this.ensureEditable(edit);
            editable.array[idx] = editable.array[2 * this.count - 2];
            editable.array[idx + 1] = editable.array[2 * this.count - 1];
            editable.array[2 * this.count - 1] = null;
            editable.array[2 * this.count - 2] = null;
            --editable.count;
            return editable;
        }
    }

    private static final class BitmapIndexedNode<K, V>
    implements INode<K, V> {
        private final Equator<K> equator;
        int bitmap;
        Object[] array;
        final AtomicReference<Thread> edit;

        static <K, V> BitmapIndexedNode<K, V> empty(Equator<K> e2) {
            return new BitmapIndexedNode<K, V>(e2, null, 0, new Object[0]);
        }

        public String toString() {
            return "BitmapIndexedNode(" + this.bitmap + "," + Arrays.toString(this.array) + "," + this.edit + ")";
        }

        int index(int bit) {
            return Integer.bitCount(this.bitmap & bit - 1);
        }

        BitmapIndexedNode(Equator<K> equator, AtomicReference<Thread> edit, int bitmap, Object[] array) {
            this.equator = equator;
            this.bitmap = bitmap;
            this.array = array;
            this.edit = edit;
        }

        @Override
        public INode<K, V> assoc(int shift, int hash, K key2, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            int idx = this.index(bit);
            if ((this.bitmap & bit) != 0) {
                Object keyOrNull = PersistentHashMap.k(this.array, 2 * idx);
                Object valOrNode = this.array[2 * idx + 1];
                if (keyOrNull == null) {
                    INode<K, V> n = ((INode)valOrNode).assoc(shift + 5, hash, key2, val, addedLeaf);
                    if (n == valOrNode) {
                        return this;
                    }
                    return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx + 1, n));
                }
                if (this.equator.eq(key2, keyOrNull)) {
                    if (val == valOrNode) {
                        return this;
                    }
                    return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx + 1, val));
                }
                addedLeaf.val = addedLeaf;
                return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx, 2 * idx + 1, PersistentHashMap.createNode(this.equator, shift + 5, keyOrNull, valOrNode, hash, key2, val)));
            }
            int n = Integer.bitCount(this.bitmap);
            if (n >= 16) {
                INode[] nodes = new INode[32];
                int jdx = PersistentHashMap.mask(hash, shift);
                nodes[jdx] = BitmapIndexedNode.empty(this.equator).assoc(shift + 5, hash, key2, val, addedLeaf);
                int j = 0;
                for (int i2 = 0; i2 < 32; ++i2) {
                    if ((this.bitmap >>> i2 & 1) == 0) continue;
                    nodes[i2] = this.array[j] == null ? (INode)this.array[j + 1] : BitmapIndexedNode.empty(this.equator).assoc(shift + 5, this.equator.hash(PersistentHashMap.k(this.array, j)), PersistentHashMap.k(this.array, j), this.array[j + 1], addedLeaf);
                    j += 2;
                }
                return new ArrayNode(this.equator, null, n + 1, nodes);
            }
            Object[] newArray = new Object[2 * (n + 1)];
            System.arraycopy(this.array, 0, newArray, 0, 2 * idx);
            newArray[2 * idx] = key2;
            addedLeaf.val = addedLeaf;
            newArray[2 * idx + 1] = val;
            System.arraycopy(this.array, 2 * idx, newArray, 2 * (idx + 1), 2 * (n - idx));
            return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap | bit, newArray);
        }

        @Override
        public INode<K, V> without(int shift, int hash, K key2) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            if ((this.bitmap & bit) == 0) {
                return this;
            }
            int idx = this.index(bit);
            Object keyOrNull = this.array[2 * idx];
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                INode n = ((INode)valOrNode).without(shift + 5, hash, key2);
                if (n == valOrNode) {
                    return this;
                }
                if (n != null) {
                    return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap, PersistentHashMap.cloneAndSet(this.array, 2 * idx + 1, n));
                }
                if (this.bitmap == bit) {
                    return null;
                }
                return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap ^ bit, PersistentHashMap.removePair(this.array, idx));
            }
            if (this.equator.eq(key2, keyOrNull)) {
                return new BitmapIndexedNode<K, V>(this.equator, null, this.bitmap ^ bit, PersistentHashMap.removePair(this.array, idx));
            }
            return this;
        }

        @Override
        public UnmodMap.UnEntry<K, V> find(int shift, int hash, K key2) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            if ((this.bitmap & bit) == 0) {
                return null;
            }
            int idx = this.index(bit);
            Object keyOrNull = PersistentHashMap.k(this.array, 2 * idx);
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                return ((INode)valOrNode).find(shift + 5, hash, key2);
            }
            if (this.equator.eq(key2, keyOrNull)) {
                return Tuple2.of(keyOrNull, valOrNode);
            }
            return null;
        }

        @Override
        public <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
            return new NodeIter<K, V, R>(this.array, aFn);
        }

        private BitmapIndexedNode<K, V> ensureEditable(AtomicReference<Thread> edit) {
            if (this.edit == edit) {
                return this;
            }
            int n = Integer.bitCount(this.bitmap);
            Object[] newArray = new Object[n >= 0 ? 2 * (n + 1) : 4];
            System.arraycopy(this.array, 0, newArray, 0, 2 * n);
            return new BitmapIndexedNode<K, V>(this.equator, edit, this.bitmap, newArray);
        }

        private BitmapIndexedNode<K, V> editAndSet(AtomicReference<Thread> edit, int i2, Object a2) {
            BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i2] = a2;
            return editable;
        }

        private BitmapIndexedNode<K, V> editAndSet(AtomicReference<Thread> edit, int i2, int j, Object b2) {
            BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i2] = null;
            editable.array[j] = b2;
            return editable;
        }

        private BitmapIndexedNode<K, V> editAndRemovePair(AtomicReference<Thread> edit, int bit, int i2) {
            if (this.bitmap == bit) {
                return null;
            }
            BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
            editable.bitmap ^= bit;
            System.arraycopy(editable.array, 2 * (i2 + 1), editable.array, 2 * i2, editable.array.length - 2 * (i2 + 1));
            editable.array[editable.array.length - 2] = null;
            editable.array[editable.array.length - 1] = null;
            return editable;
        }

        @Override
        public INode<K, V> assoc(AtomicReference<Thread> edit, int shift, int hash, K key2, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            int idx = this.index(bit);
            if ((this.bitmap & bit) != 0) {
                Object keyOrNull = PersistentHashMap.k(this.array, 2 * idx);
                Object valOrNode = this.array[2 * idx + 1];
                if (keyOrNull == null) {
                    INode<K, V> n = ((INode)valOrNode).assoc(edit, shift + 5, hash, key2, val, addedLeaf);
                    if (n == valOrNode) {
                        return this;
                    }
                    return this.editAndSet(edit, 2 * idx + 1, n);
                }
                if (this.equator.eq(key2, keyOrNull)) {
                    if (val == valOrNode) {
                        return this;
                    }
                    return this.editAndSet(edit, 2 * idx + 1, val);
                }
                addedLeaf.val = addedLeaf;
                return this.editAndSet(edit, 2 * idx, 2 * idx + 1, PersistentHashMap.createNode(this.equator, edit, shift + 5, keyOrNull, valOrNode, hash, key2, val));
            }
            int n = Integer.bitCount(this.bitmap);
            if (n * 2 < this.array.length) {
                addedLeaf.val = addedLeaf;
                BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
                System.arraycopy(editable.array, 2 * idx, editable.array, 2 * (idx + 1), 2 * (n - idx));
                editable.array[2 * idx] = key2;
                editable.array[2 * idx + 1] = val;
                editable.bitmap |= bit;
                return editable;
            }
            if (n >= 16) {
                INode[] nodes = new INode[32];
                int jdx = PersistentHashMap.mask(hash, shift);
                nodes[jdx] = BitmapIndexedNode.empty(this.equator).assoc(edit, shift + 5, hash, key2, val, addedLeaf);
                int j = 0;
                for (int i2 = 0; i2 < 32; ++i2) {
                    if ((this.bitmap >>> i2 & 1) == 0) continue;
                    nodes[i2] = this.array[j] == null ? (INode)this.array[j + 1] : BitmapIndexedNode.empty(this.equator).assoc(edit, shift + 5, this.equator.hash(PersistentHashMap.k(this.array, j)), PersistentHashMap.k(this.array, j), this.array[j + 1], addedLeaf);
                    j += 2;
                }
                return new ArrayNode(this.equator, edit, n + 1, nodes);
            }
            Object[] newArray = new Object[2 * (n + 4)];
            System.arraycopy(this.array, 0, newArray, 0, 2 * idx);
            newArray[2 * idx] = key2;
            addedLeaf.val = addedLeaf;
            newArray[2 * idx + 1] = val;
            System.arraycopy(this.array, 2 * idx, newArray, 2 * (idx + 1), 2 * (n - idx));
            BitmapIndexedNode<K, V> editable = this.ensureEditable(edit);
            editable.array = newArray;
            editable.bitmap |= bit;
            return editable;
        }

        @Override
        public INode<K, V> without(AtomicReference<Thread> edit, int shift, int hash, K key2, PersistentTreeMap.Box<PersistentTreeMap.Box> removedLeaf) {
            int bit = PersistentHashMap.bitpos(hash, shift);
            if ((this.bitmap & bit) == 0) {
                return this;
            }
            int idx = this.index(bit);
            Object keyOrNull = PersistentHashMap.k(this.array, 2 * idx);
            Object valOrNode = this.array[2 * idx + 1];
            if (keyOrNull == null) {
                INode n = ((INode)valOrNode).without(edit, shift + 5, hash, key2, removedLeaf);
                if (n == valOrNode) {
                    return this;
                }
                if (n != null) {
                    return this.editAndSet(edit, 2 * idx + 1, n);
                }
                if (this.bitmap == bit) {
                    return null;
                }
                return this.editAndRemovePair(edit, bit, idx);
            }
            if (this.equator.eq(key2, keyOrNull)) {
                removedLeaf.val = removedLeaf;
                return this.editAndRemovePair(edit, bit, idx);
            }
            return this;
        }
    }

    private static final class ArrayNode<K, V>
    implements INode<K, V>,
    UnmodIterable<UnmodMap.UnEntry<K, V>> {
        private final Equator<K> equator;
        int count;
        final INode<K, V> @NotNull [] array;
        final AtomicReference<Thread> edit;

        ArrayNode(Equator<K> eq, AtomicReference<Thread> edit, int count2, INode<K, V> @NotNull [] array) {
            this.equator = eq;
            this.array = array;
            this.edit = edit;
            this.count = count2;
        }

        @Override
        public INode<K, V> assoc(int shift, int hash, K key2, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                BitmapIndexedNode<K, V> e2 = BitmapIndexedNode.empty(this.equator);
                INode n = e2.assoc(shift + 5, hash, key2, val, addedLeaf);
                return new ArrayNode<K, V>(this.equator, null, this.count + 1, PersistentHashMap.cloneAndSet(this.array, idx, n));
            }
            INode<K, V> n = node.assoc(shift + 5, hash, key2, val, addedLeaf);
            if (n == node) {
                return this;
            }
            return new ArrayNode<K, V>(this.equator, null, this.count, PersistentHashMap.cloneAndSet(this.array, idx, n));
        }

        @Override
        public INode<K, V> without(int shift, int hash, K key2) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                return this;
            }
            INode<K, V> n = node.without(shift + 5, hash, key2);
            if (n == node) {
                return this;
            }
            if (n == null) {
                if (this.count <= 8) {
                    return this.pack(null, idx);
                }
                return new ArrayNode<K, V>(this.equator, null, this.count - 1, PersistentHashMap.cloneAndSet(this.array, idx, null));
            }
            return new ArrayNode<K, V>(this.equator, null, this.count, PersistentHashMap.cloneAndSet(this.array, idx, n));
        }

        @Override
        public UnmodMap.UnEntry<K, V> find(int shift, int hash, K key2) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                return null;
            }
            return node.find(shift + 5, hash, key2);
        }

        @Override
        @NotNull
        public UnmodIterator<UnmodMap.UnEntry<K, V>> iterator() {
            return this.iterator(Tuple2::of);
        }

        @Override
        public <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
            return new Iter<K, V, R>(this.array, aFn);
        }

        private ArrayNode<K, V> ensureEditable(AtomicReference<Thread> edit) {
            if (this.edit == edit) {
                return this;
            }
            return new ArrayNode<K, V>(this.equator, edit, this.count, (INode[])this.array.clone());
        }

        private ArrayNode<K, V> editAndSet(AtomicReference<Thread> edit, int i2, INode<K, V> n) {
            ArrayNode<K, V> editable = this.ensureEditable(edit);
            editable.array[i2] = n;
            return editable;
        }

        private INode<K, V> pack(AtomicReference<Thread> edit, int idx) {
            int i2;
            Object[] newArray = new Object[2 * (this.count - 1)];
            int j = 1;
            int bitmap = 0;
            for (i2 = 0; i2 < idx; ++i2) {
                if (this.array[i2] == null) continue;
                newArray[j] = this.array[i2];
                bitmap |= 1 << i2;
                j += 2;
            }
            for (i2 = idx + 1; i2 < this.array.length; ++i2) {
                if (this.array[i2] == null) continue;
                newArray[j] = this.array[i2];
                bitmap |= 1 << i2;
                j += 2;
            }
            return new BitmapIndexedNode(this.equator, edit, bitmap, newArray);
        }

        @Override
        public INode<K, V> assoc(AtomicReference<Thread> edit, int shift, int hash, K key2, V val, PersistentTreeMap.Box<PersistentTreeMap.Box> addedLeaf) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                BitmapIndexedNode<K, V> en = BitmapIndexedNode.empty(this.equator);
                ArrayNode editable = this.editAndSet(edit, idx, en.assoc(edit, shift + 5, hash, key2, val, addedLeaf));
                ++editable.count;
                return editable;
            }
            INode<K, V> n = node.assoc(edit, shift + 5, hash, key2, val, addedLeaf);
            if (n == node) {
                return this;
            }
            return this.editAndSet(edit, idx, n);
        }

        @Override
        public INode<K, V> without(AtomicReference<Thread> edit, int shift, int hash, K key2, PersistentTreeMap.Box<PersistentTreeMap.Box> removedLeaf) {
            int idx = PersistentHashMap.mask(hash, shift);
            INode<K, V> node = this.array[idx];
            if (node == null) {
                return this;
            }
            INode<K, V> n = node.without(edit, shift + 5, hash, key2, removedLeaf);
            if (n == node) {
                return this;
            }
            if (n == null) {
                if (this.count <= 8) {
                    return this.pack(edit, idx);
                }
                ArrayNode<K, V> editable = this.editAndSet(edit, idx, null);
                --editable.count;
                return editable;
            }
            return this.editAndSet(edit, idx, n);
        }

        public String toString() {
            return UnmodIterable.toString("ArrayNode", this);
        }

        private static class Iter<K, V, R>
        implements UnmodIterator<R> {
            private final INode<K, V> @NotNull [] array;
            private final Fn2<K, V, R> aFn;
            private int i = 0;
            private UnmodIterator<R> nestedIter;

            private Iter(INode<K, V> @NotNull [] array, Fn2<K, V, R> aFn) {
                this.array = array;
                this.aFn = aFn;
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    INode<K, V> node;
                    if (this.nestedIter != null) {
                        if (this.nestedIter.hasNext()) {
                            return true;
                        }
                        this.nestedIter = null;
                    }
                    if (this.i >= this.array.length) break;
                    if ((node = this.array[this.i++]) == null) continue;
                    this.nestedIter = node.iterator(this.aFn);
                }
                return false;
            }

            @Override
            public R next() {
                if (this.hasNext()) {
                    return (R)this.nestedIter.next();
                }
                throw new NoSuchElementException();
            }
        }
    }

    private static interface INode<K, V> {
        public INode<K, V> assoc(int var1, int var2, K var3, V var4, PersistentTreeMap.Box<PersistentTreeMap.Box> var5);

        public INode<K, V> without(int var1, int var2, K var3);

        public UnmodMap.UnEntry<K, V> find(int var1, int var2, K var3);

        public INode<K, V> assoc(AtomicReference<Thread> var1, int var2, int var3, K var4, V var5, PersistentTreeMap.Box<PersistentTreeMap.Box> var6);

        public INode<K, V> without(AtomicReference<Thread> var1, int var2, int var3, K var4, PersistentTreeMap.Box<PersistentTreeMap.Box> var5);

        public <R> UnmodIterator<R> iterator(Fn2<K, V, R> var1);
    }

    public static final class MutHashMap<K, V>
    extends AbstractUnmodMap<K, V>
    implements MutMap<K, V> {
        private final AtomicReference<Thread> edit;
        private final Equator<K> equator;
        private INode<K, V> root;
        private int count;
        private boolean hasNull;
        private V nullValue;
        private final PersistentTreeMap.Box<PersistentTreeMap.Box> leafFlag = new PersistentTreeMap.Box<Object>(null);

        private MutHashMap(PersistentHashMap<K, V> m) {
            this(m.equator(), new AtomicReference<Thread>(Thread.currentThread()), m.root, m.size, m.hasNull, m.nullValue);
        }

        private MutHashMap(Equator<K> e2, AtomicReference<Thread> edit, INode<K, V> root, int count2, boolean hasNull, V nullValue) {
            this.equator = e2 == null ? Equator.defaultEquator() : e2;
            this.edit = edit;
            this.root = root;
            this.count = count2;
            this.hasNull = hasNull;
            this.nullValue = nullValue;
        }

        @Override
        public Equator<K> equator() {
            return this.equator;
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutHashMap<K, V> assoc(K key2, V val) {
            this.ensureEditable();
            if (key2 == null) {
                if (this.nullValue != val) {
                    this.nullValue = val;
                }
                if (!this.hasNull) {
                    ++this.count;
                    this.hasNull = true;
                }
                return this;
            }
            this.leafFlag.val = null;
            INode<K, V> n = this.root == null ? BitmapIndexedNode.empty(this.equator) : this.root;
            if ((n = n.assoc(this.edit, 0, this.equator.hash(key2), key2, val, this.leafFlag)) != this.root) {
                this.root = n;
            }
            if (this.leafFlag.val != null) {
                ++this.count;
            }
            return this;
        }

        @Override
        @NotNull
        public Option<UnmodMap.UnEntry<K, V>> entry(K key2) {
            this.ensureEditable();
            if (key2 == null) {
                return this.hasNull ? Option.some(Tuple2.of(null, this.nullValue)) : Option.none();
            }
            if (this.root == null) {
                return Option.none();
            }
            UnmodMap.UnEntry<K, V> entry = this.root.find(0, this.equator.hash(key2), key2);
            return Option.someOrNullNoneOf(entry);
        }

        @Override
        @NotNull
        public UnmodIterator<UnmodMap.UnEntry<K, V>> iterator() {
            return this.iterator(Tuple2::of);
        }

        @Override
        @NotNull
        public UnmodIterator<K> keyIterator() {
            return this.iterator(Fn2.Singletons.FIRST);
        }

        @Override
        @NotNull
        public UnmodIterator<V> valIterator() {
            return this.iterator(Fn2.Singletons.SECOND);
        }

        private <R> UnmodIterator<R> iterator(Fn2<K, V, R> aFn) {
            Iter<K, V, R> rootIter = this.root == null ? UnmodIterator.emptyUnmodIterator() : this.root.iterator(aFn);
            return this.hasNull ? new Iter<K, V, R>(rootIter, aFn, this.nullValue) : rootIter;
        }

        @Override
        @NotNull
        public MutHashMap<K, V> without(K key2) {
            this.ensureEditable();
            if (key2 == null) {
                if (!this.hasNull) {
                    return this;
                }
                this.hasNull = false;
                this.nullValue = null;
                --this.count;
                return this;
            }
            if (this.root == null) {
                return this;
            }
            this.leafFlag.val = null;
            INode<K, V> n = this.root.without(this.edit, 0, this.equator.hash(key2), key2, this.leafFlag);
            if (n != this.root) {
                this.root = n;
            }
            if (this.leafFlag.val != null) {
                --this.count;
            }
            return this;
        }

        @Override
        @NotNull
        public PersistentHashMap<K, V> immutable() {
            this.ensureEditable();
            this.edit.set(null);
            return new PersistentHashMap<K, V>(this.equator, this.count, this.root, this.hasNull, this.nullValue);
        }

        @Override
        public int size() {
            this.ensureEditable();
            return this.count;
        }

        private void ensureEditable() {
            if (this.edit.get() == null) {
                throw new IllegalStateException("Mutable used after immutable! call");
            }
        }
    }

    private static class SerializationProxy<K, V>
    implements Serializable {
        private final Equator<K> equator;
        private final int size;
        private transient ImMap<K, V> theMap;
        private static final long serialVersionUID = 20160827174100L;

        SerializationProxy(PersistentHashMap<K, V> phm) {
            this.equator = phm.equator;
            this.size = phm.size;
            this.theMap = phm;
        }

        private void writeObject(ObjectOutputStream s2) throws IOException {
            s2.defaultWriteObject();
            for (UnmodMap.UnEntry unEntry : this.theMap) {
                s2.writeObject(unEntry.getKey());
                s2.writeObject(unEntry.getValue());
            }
        }

        private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
            s2.defaultReadObject();
            MutMap tempMap = new PersistentHashMap<K, Object>(this.equator, 0, null, false, null).mutable();
            for (int i2 = 0; i2 < this.size; ++i2) {
                tempMap.assoc(s2.readObject(), s2.readObject());
            }
            this.theMap = tempMap.immutable();
        }

        private Object readResolve() {
            return this.theMap;
        }
    }

    private static class Iter<K, V, R>
    implements UnmodIterator<R> {
        private boolean seen = false;
        private final UnmodIterator<R> rootIter;
        private final Fn2<K, V, R> aFn;
        private final V nullValue;

        private Iter(UnmodIterator<R> ri, Fn2<K, V, R> aFn, V nv) {
            this.rootIter = ri;
            this.aFn = aFn;
            this.nullValue = nv;
        }

        @Override
        public boolean hasNext() {
            if (!this.seen) {
                return true;
            }
            return this.rootIter.hasNext();
        }

        @Override
        public R next() {
            if (!this.seen) {
                this.seen = true;
                return this.aFn.apply((K)null, this.nullValue);
            }
            return (R)this.rootIter.next();
        }
    }
}

