/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.pkl.thirdparty.jetbrains.annotations.Contract;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.paguro.collections.AbstractUnmodSet;
import org.pkl.thirdparty.paguro.collections.BaseMap;
import org.pkl.thirdparty.paguro.collections.Equator;
import org.pkl.thirdparty.paguro.collections.ImMap;
import org.pkl.thirdparty.paguro.collections.ImSet;
import org.pkl.thirdparty.paguro.collections.MutMap;
import org.pkl.thirdparty.paguro.collections.MutSet;
import org.pkl.thirdparty.paguro.collections.PersistentHashMap;
import org.pkl.thirdparty.paguro.collections.UnmodIterator;

public class PersistentHashSet<E>
extends AbstractUnmodSet<E>
implements ImSet<E>,
Serializable {
    public static final PersistentHashSet<Object> EMPTY = new PersistentHashSet<Object>(PersistentHashMap.EMPTY);
    private final ImMap<E, E> impl;
    private static final long serialVersionUID = 20160904155600L;

    public static <E> PersistentHashSet<E> empty() {
        return EMPTY;
    }

    public static <E> MutHashSet<E> emptyMutable() {
        return PersistentHashSet.empty().mutable();
    }

    public static <E> PersistentHashSet<E> empty(Equator<E> eq) {
        return new PersistentHashSet<E>(PersistentHashMap.empty(eq));
    }

    public static <E> MutHashSet<E> emptyMutable(Equator<E> eq) {
        return PersistentHashSet.empty(eq).mutable();
    }

    public static <E> PersistentHashSet<E> of(Iterable<E> elements) {
        PersistentHashSet<E> empty2 = PersistentHashSet.empty();
        MutSet ret = empty2.mutable();
        for (E e2 : elements) {
            ret.put((Object)e2);
        }
        return (PersistentHashSet)ret.immutable();
    }

    public static <E> PersistentHashSet<E> ofEq(Equator<E> eq, Iterable<E> init) {
        MutHashSet<E> ret = PersistentHashSet.emptyMutable(eq);
        for (E e2 : init) {
            ret.put((Object)e2);
        }
        return (PersistentHashSet)ret.immutable();
    }

    public static <E> PersistentHashSet<E> ofMap(ImMap<E, ?> map2) {
        return new PersistentHashSet<E>(map2);
    }

    private PersistentHashSet(ImMap<E, E> i2) {
        this.impl = i2;
    }

    private Object writeReplace() {
        return new SerializationProxy<E>(this.impl);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    public boolean contains(Object key2) {
        return this.impl.containsKey(key2);
    }

    public Equator<E> equator() {
        return this.impl.equator();
    }

    @Override
    @NotNull
    public PersistentHashSet<E> without(E key2) {
        if (this.contains(key2)) {
            return new PersistentHashSet<E>(this.impl.without((Object)key2));
        }
        return this;
    }

    @Override
    @NotNull
    public PersistentHashSet<E> put(E o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentHashSet<E>(this.impl.assoc((Object)o, (Object)o));
    }

    @Override
    @NotNull
    public UnmodIterator<E> iterator() {
        return this.impl.keyIterator();
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public MutHashSet<E> mutable() {
        return new MutHashSet<E>(this.impl.mutable());
    }

    public static final class MutHashSet<E>
    extends AbstractUnmodSet<E>
    implements MutSet<E> {
        MutMap<E, E> impl;

        MutHashSet(MutMap<E, E> impl) {
            this.impl = impl;
        }

        @Override
        public int size() {
            return this.impl.size();
        }

        @Override
        @NotNull
        public MutHashSet<E> put(E val) {
            BaseMap m = this.impl.assoc((Object)val, (Object)val);
            if (m != this.impl) {
                this.impl = m;
            }
            return this;
        }

        @Override
        @NotNull
        public UnmodIterator<E> iterator() {
            return this.impl.keyIterator();
        }

        @Override
        public boolean contains(Object key2) {
            return this.impl.entry(key2).isSome();
        }

        @Override
        @NotNull
        public MutHashSet<E> without(E key2) {
            BaseMap m = this.impl.without((Object)key2);
            if (m != this.impl) {
                this.impl = m;
            }
            return this;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public PersistentHashSet<E> immutable() {
            return new PersistentHashSet<E>(this.impl.immutable());
        }
    }

    private static class SerializationProxy<K>
    implements Serializable {
        private static final long serialVersionUID = 20160904155600L;
        private final int size;
        private transient ImMap<K, K> theMap;

        SerializationProxy(ImMap<K, K> phm) {
            this.size = phm.size();
            this.theMap = phm;
        }

        private void writeObject(ObjectOutputStream s2) throws IOException {
            s2.defaultWriteObject();
            for (Map.Entry entry : this.theMap) {
                s2.writeObject(entry.getKey());
            }
        }

        private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
            s2.defaultReadObject();
            BaseMap tempMap = PersistentHashMap.empty().mutable();
            for (int i2 = 0; i2 < this.size; ++i2) {
                Object k = s2.readObject();
                tempMap = tempMap.assoc(k, k);
            }
            this.theMap = tempMap.immutable();
        }

        private Object readResolve() {
            return PersistentHashSet.ofMap(this.theMap);
        }
    }
}

