/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.collections;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.paguro.collections.UnmodIterable;
import org.pkl.thirdparty.paguro.collections.UnmodIterator;
import org.pkl.thirdparty.paguro.collections.UnmodMap;
import org.pkl.thirdparty.paguro.collections.UnmodSortedIterator;
import org.pkl.thirdparty.paguro.collections.UnmodSortedMap;

public interface UnmodSortedIterable<T>
extends UnmodIterable<T> {
    public static boolean equal(UnmodSortedIterable a2, UnmodSortedIterable b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        UnmodIterator as = a2.iterator();
        UnmodIterator bs = b2.iterator();
        while (as.hasNext() && bs.hasNext()) {
            if (Objects.equals(as.next(), bs.next())) continue;
            return false;
        }
        return !as.hasNext() && !bs.hasNext();
    }

    @NotNull
    public static <E> UnmodSortedIterable<E> castFromSortedSet(SortedSet<E> s2) {
        class Implementation<S>
        implements UnmodSortedIterable<S>,
        Serializable {
            private static final long serialVersionUID = 20160903174100L;
            private final SortedSet<S> ss;

            private Implementation(SortedSet<S> s2) {
                this.ss = s2;
            }

            @Override
            @NotNull
            public UnmodSortedIterator<S> iterator() {
                return new UnmodSortedIterator.Wrapper(this.ss.iterator());
            }
        }
        return new Implementation<E>(s2);
    }

    @NotNull
    public static <E> UnmodSortedIterable<E> castFromList(List<E> s2) {
        class Implementation<S>
        implements UnmodSortedIterable<S>,
        Serializable {
            private static final long serialVersionUID = 20160903174100L;
            private final List<S> ss;

            private Implementation(List<S> s2) {
                this.ss = s2;
            }

            @Override
            @NotNull
            public UnmodSortedIterator<S> iterator() {
                return new UnmodSortedIterator.Wrapper<S>(this.ss.iterator());
            }
        }
        return new Implementation<E>(s2);
    }

    @NotNull
    public static <K, V> UnmodSortedIterable<UnmodMap.UnEntry<K, V>> castFromSortedMap(SortedMap<K, V> sm) {
        if (sm instanceof UnmodSortedMap) {
            return (UnmodSortedMap)sm;
        }
        class Implementation<K1, V1>
        implements UnmodSortedIterable<UnmodMap.UnEntry<K1, V1>>,
        Serializable {
            private static final long serialVersionUID = 20160903174100L;
            private final SortedMap<K1, V1> m;

            private Implementation(SortedMap<K1, V1> s2) {
                this.m = s2;
            }

            @Override
            @NotNull
            public UnmodSortedIterator<UnmodMap.UnEntry<K1, V1>> iterator() {
                return new UnmodMap.UnEntry.EntryToUnEntrySortedIter(this.m.entrySet().iterator());
            }
        }
        return new Implementation<K, V>(sm);
    }

    @Override
    @NotNull
    public UnmodSortedIterator<T> iterator();
}

