/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.paguro.function;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.paguro.oneOf.Option;
import org.pkl.thirdparty.paguro.tuple.Tuple2;

@FunctionalInterface
public interface Fn2<A, B, R>
extends BiFunction<A, B, R> {
    public R applyEx(A var1, B var2) throws Exception;

    @Override
    default public R apply(A a2, B b2) {
        try {
            return this.applyEx(a2, b2);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @NotNull
    public static <A, B, Z> Fn2<A, B, Z> memoize(final @NotNull Fn2<A, B, Z> f) {
        return new Fn2<A, B, Z>(){
            private final Map<Tuple2<A, B>, Option<Z>> map = new HashMap();

            @Override
            public synchronized Z applyEx(A a2, B b2) throws Exception {
                Tuple2 t = Tuple2.of(a2, b2);
                Option val = this.map.get(t);
                if (val != null) {
                    return val.get();
                }
                Object ret = f.applyEx(a2, b2);
                this.map.put(t, Option.some(ret));
                return ret;
            }
        };
    }

    @NotNull
    public static <A1, B1> Fn2<A1, ? super B1, A1> first() {
        return Singletons.FIRST;
    }

    @NotNull
    public static <A1, B1> Fn2<A1, ? super B1, B1> second() {
        return Singletons.SECOND;
    }

    public static enum Singletons implements Fn2
    {
        FIRST{

            public Object applyEx(Object a2, Object b2) throws Exception {
                return a2;
            }
        }
        ,
        SECOND{

            public Object applyEx(Object a2, Object b2) throws Exception {
                return b2;
            }
        };

    }
}

