/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.snakeyaml.engine.v2.api.lowlevel;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.pkl.thirdparty.snakeyaml.engine.v2.api.DumpSettings;
import org.pkl.thirdparty.snakeyaml.engine.v2.api.lowlevel.EmitableEvents;
import org.pkl.thirdparty.snakeyaml.engine.v2.events.Event;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Node;
import org.pkl.thirdparty.snakeyaml.engine.v2.serializer.Serializer;

public class Serialize {
    private final DumpSettings settings;

    public Serialize(DumpSettings settings2) {
        Objects.requireNonNull(settings2, "DumpSettings cannot be null");
        this.settings = settings2;
    }

    public List<Event> serializeOne(Node node) {
        Objects.requireNonNull(node, "Node cannot be null");
        return this.serializeAll(Collections.singletonList(node));
    }

    public List<Event> serializeAll(List<Node> nodes) {
        Objects.requireNonNull(nodes, "Nodes cannot be null");
        EmitableEvents emitableEvents = new EmitableEvents();
        Serializer serializer2 = new Serializer(this.settings, emitableEvents);
        serializer2.emitStreamStart();
        for (Node node : nodes) {
            serializer2.serializeDocument(node);
        }
        serializer2.emitStreamEnd();
        return emitableEvents.getEvents();
    }
}

