/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.snakeyaml.engine.v2.exceptions;

import java.io.Serializable;
import org.pkl.thirdparty.snakeyaml.engine.v2.common.CharConstants;

public final class Mark
implements Serializable {
    private final String name;
    private final int index;
    private final int line;
    private final int column;
    private final int[] buffer;
    private final int pointer;

    private static int[] toCodePoints(char[] str) {
        int[] codePoints2 = new int[Character.codePointCount(str, 0, str.length)];
        int i2 = 0;
        int c = 0;
        while (i2 < str.length) {
            int cp;
            codePoints2[c] = cp = Character.codePointAt(str, i2);
            i2 += Character.charCount(cp);
            ++c;
        }
        return codePoints2;
    }

    public Mark(String name, int index, int line, int column, int[] buffer, int pointer) {
        this.name = name;
        this.index = index;
        this.line = line;
        this.column = column;
        this.buffer = buffer;
        this.pointer = pointer;
    }

    public Mark(String name, int index, int line, int column, char[] str, int pointer) {
        this(name, index, line, column, Mark.toCodePoints(str), pointer);
    }

    private boolean isLineBreak(int c) {
        return CharConstants.NULL_OR_LINEBR.has(c);
    }

    public String createSnippet(int indent, int maxLength) {
        int i2;
        float half = (float)maxLength / 2.0f - 1.0f;
        int start2 = this.pointer;
        String head2 = "";
        while (start2 > 0 && !this.isLineBreak(this.buffer[start2 - 1])) {
            if (!((float)(this.pointer - --start2) > half)) continue;
            head2 = " ... ";
            start2 += 5;
            break;
        }
        String tail = "";
        int end2 = this.pointer;
        while (end2 < this.buffer.length && !this.isLineBreak(this.buffer[end2])) {
            if (!((float)(++end2 - this.pointer) > half)) continue;
            tail = " ... ";
            end2 -= 5;
            break;
        }
        StringBuilder result2 = new StringBuilder();
        for (i2 = 0; i2 < indent; ++i2) {
            result2.append(" ");
        }
        result2.append(head2);
        for (i2 = start2; i2 < end2; ++i2) {
            result2.appendCodePoint(this.buffer[i2]);
        }
        result2.append(tail);
        result2.append("\n");
        for (i2 = 0; i2 < indent + this.pointer - start2 + head2.length(); ++i2) {
            result2.append(" ");
        }
        result2.append("^");
        return result2.toString();
    }

    public String createSnippet() {
        return this.createSnippet(4, 75);
    }

    public String toString() {
        String snippet = this.createSnippet();
        return " in " + this.name + ", line " + (this.line + 1) + ", column " + (this.column + 1) + ":\n" + snippet;
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public int[] getBuffer() {
        return this.buffer;
    }

    public int getPointer() {
        return this.pointer;
    }
}

