/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.snakeyaml.engine.v2.nodes;

import java.util.Objects;
import java.util.Optional;
import org.pkl.thirdparty.snakeyaml.engine.v2.common.ScalarStyle;
import org.pkl.thirdparty.snakeyaml.engine.v2.exceptions.Mark;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Node;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.NodeType;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Tag;

public class ScalarNode
extends Node {
    private final ScalarStyle style;
    private final String value;

    public ScalarNode(Tag tag, boolean resolved, String value2, ScalarStyle style2, Optional<Mark> startMark, Optional<Mark> endMark) {
        super(tag, startMark, endMark);
        Objects.requireNonNull(value2, "value in a Node is required.");
        this.value = value2;
        Objects.requireNonNull(style2, "Scalar style must be provided.");
        this.style = style2;
        this.resolved = resolved;
    }

    public ScalarNode(Tag tag, String value2, ScalarStyle style2) {
        this(tag, true, value2, style2, Optional.empty(), Optional.empty());
    }

    public ScalarStyle getScalarStyle() {
        return this.style;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCALAR;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", value=" + this.getValue() + ")>";
    }

    public boolean isPlain() {
        return this.style == ScalarStyle.PLAIN;
    }
}

