/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.snakeyaml.engine.v2.representer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.pkl.thirdparty.snakeyaml.engine.v2.api.RepresentToNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.common.FlowStyle;
import org.pkl.thirdparty.snakeyaml.engine.v2.common.ScalarStyle;
import org.pkl.thirdparty.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.AnchorNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.MappingNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Node;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.NodeTuple;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.ScalarNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.SequenceNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Tag;

public abstract class BaseRepresenter {
    protected final Map<Class<?>, RepresentToNode> representers = new HashMap();
    protected RepresentToNode nullRepresenter;
    protected final Map<Class<?>, RepresentToNode> parentClassRepresenters = new LinkedHashMap();
    protected ScalarStyle defaultScalarStyle = ScalarStyle.PLAIN;
    protected FlowStyle defaultFlowStyle = FlowStyle.AUTO;
    protected final Map<Object, Node> representedObjects = new IdentityHashMap<Object, Node>(){

        @Override
        public Node put(Object key2, Node value2) {
            return super.put(key2, new AnchorNode(value2));
        }
    };
    protected Object objectToRepresent;

    public Node represent(Object data2) {
        Node node = this.representData(data2);
        this.representedObjects.clear();
        this.objectToRepresent = null;
        return node;
    }

    protected Optional<RepresentToNode> findRepresenterFor(Object data2) {
        Class<?> clazz = data2.getClass();
        if (this.representers.containsKey(clazz)) {
            return Optional.of(this.representers.get(clazz));
        }
        for (Map.Entry<Class<?>, RepresentToNode> parentRepresenterEntry : this.parentClassRepresenters.entrySet()) {
            if (!parentRepresenterEntry.getKey().isInstance(data2)) continue;
            return Optional.of(parentRepresenterEntry.getValue());
        }
        return Optional.empty();
    }

    protected final Node representData(Object data2) {
        this.objectToRepresent = data2;
        if (this.representedObjects.containsKey(this.objectToRepresent)) {
            return this.representedObjects.get(this.objectToRepresent);
        }
        if (data2 == null) {
            return this.nullRepresenter.representData(null);
        }
        RepresentToNode representer = this.findRepresenterFor(data2).orElseThrow(() -> new YamlEngineException("Representer is not defined for " + data2.getClass()));
        return representer.representData(data2);
    }

    protected Node representScalar(Tag tag, String value2, ScalarStyle style2) {
        if (style2 == ScalarStyle.PLAIN) {
            style2 = this.defaultScalarStyle;
        }
        return new ScalarNode(tag, value2, style2);
    }

    protected Node representScalar(Tag tag, String value2) {
        return this.representScalar(tag, value2, ScalarStyle.PLAIN);
    }

    protected Node representSequence(Tag tag, Iterable<?> sequence, FlowStyle flowStyle) {
        int size = 10;
        if (sequence instanceof List) {
            size = ((List)sequence).size();
        }
        ArrayList<Node> value2 = new ArrayList<Node>(size);
        SequenceNode node = new SequenceNode(tag, value2, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        FlowStyle bestStyle = FlowStyle.FLOW;
        for (Object item : sequence) {
            Node nodeItem = this.representData(item);
            if (!(nodeItem instanceof ScalarNode) || !((ScalarNode)nodeItem).isPlain()) {
                bestStyle = FlowStyle.BLOCK;
            }
            value2.add(nodeItem);
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }

    protected NodeTuple representMappingEntry(Map.Entry<?, ?> entry) {
        return new NodeTuple(this.representData(entry.getKey()), this.representData(entry.getValue()));
    }

    protected Node representMapping(Tag tag, Map<?, ?> mapping, FlowStyle flowStyle) {
        ArrayList<NodeTuple> value2 = new ArrayList<NodeTuple>(mapping.size());
        MappingNode node = new MappingNode(tag, value2, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        FlowStyle bestStyle = FlowStyle.FLOW;
        for (Map.Entry<?, ?> entry : mapping.entrySet()) {
            NodeTuple tuple = this.representMappingEntry(entry);
            if (!(tuple.getKeyNode() instanceof ScalarNode) || !((ScalarNode)tuple.getKeyNode()).isPlain()) {
                bestStyle = FlowStyle.BLOCK;
            }
            if (!(tuple.getValueNode() instanceof ScalarNode) || !((ScalarNode)tuple.getValueNode()).isPlain()) {
                bestStyle = FlowStyle.BLOCK;
            }
            value2.add(tuple);
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }
}

