/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.snakeyaml.engine.v2.representer;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.pkl.thirdparty.snakeyaml.engine.v2.api.DumpSettings;
import org.pkl.thirdparty.snakeyaml.engine.v2.api.RepresentToNode;
import org.pkl.thirdparty.snakeyaml.engine.v2.common.FlowStyle;
import org.pkl.thirdparty.snakeyaml.engine.v2.common.NonPrintableStyle;
import org.pkl.thirdparty.snakeyaml.engine.v2.common.ScalarStyle;
import org.pkl.thirdparty.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Node;
import org.pkl.thirdparty.snakeyaml.engine.v2.nodes.Tag;
import org.pkl.thirdparty.snakeyaml.engine.v2.representer.BaseRepresenter;
import org.pkl.thirdparty.snakeyaml.engine.v2.scanner.StreamReader;

public class StandardRepresenter
extends BaseRepresenter {
    protected Map<Class<? extends Object>, Tag> classTags;
    protected DumpSettings settings;
    public static final Pattern MULTILINE_PATTERN = Pattern.compile("\n|\u0085|\u2028|\u2029");

    public StandardRepresenter(DumpSettings settings2) {
        this.defaultFlowStyle = settings2.getDefaultFlowStyle();
        this.defaultScalarStyle = settings2.getDefaultScalarStyle();
        this.nullRepresenter = new RepresentNull();
        this.representers.put(String.class, new RepresentString());
        this.representers.put(Boolean.class, new RepresentBoolean());
        this.representers.put(Character.class, new RepresentString());
        this.representers.put(UUID.class, new RepresentUuid());
        this.representers.put(Optional.class, new RepresentOptional());
        this.representers.put(byte[].class, new RepresentByteArray());
        RepresentPrimitiveArray primitiveArray = new RepresentPrimitiveArray();
        this.representers.put(short[].class, primitiveArray);
        this.representers.put(int[].class, primitiveArray);
        this.representers.put(long[].class, primitiveArray);
        this.representers.put(float[].class, primitiveArray);
        this.representers.put(double[].class, primitiveArray);
        this.representers.put(char[].class, primitiveArray);
        this.representers.put(boolean[].class, primitiveArray);
        this.parentClassRepresenters.put(Number.class, new RepresentNumber());
        this.parentClassRepresenters.put(List.class, new RepresentList());
        this.parentClassRepresenters.put(Map.class, new RepresentMap());
        this.parentClassRepresenters.put(Set.class, new RepresentSet());
        this.parentClassRepresenters.put(Iterator.class, new RepresentIterator());
        this.parentClassRepresenters.put(new Object[0].getClass(), new RepresentArray());
        this.parentClassRepresenters.put(Enum.class, new RepresentEnum());
        this.classTags = new HashMap<Class<? extends Object>, Tag>();
        this.settings = settings2;
    }

    protected Tag getTag(Class<?> clazz, Tag defaultTag) {
        return this.classTags.getOrDefault(clazz, defaultTag);
    }

    public Tag addClassTag(Class<? extends Object> clazz, Tag tag) {
        if (tag == null) {
            throw new NullPointerException("Tag must be provided.");
        }
        return this.classTags.put(clazz, tag);
    }

    protected class RepresentOptional
    implements RepresentToNode {
        protected RepresentOptional() {
        }

        @Override
        public Node representData(Object data2) {
            Optional opt = (Optional)data2;
            if (opt.isPresent()) {
                Node node = StandardRepresenter.this.represent(opt.get());
                node.setTag(new Tag(Optional.class));
                return node;
            }
            return StandardRepresenter.this.representScalar(Tag.NULL, "null");
        }
    }

    protected class RepresentUuid
    implements RepresentToNode {
        protected RepresentUuid() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(data2.getClass(), new Tag(UUID.class)), data2.toString());
        }
    }

    protected class RepresentByteArray
    implements RepresentToNode {
        protected RepresentByteArray() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representScalar(Tag.BINARY, Base64.getEncoder().encodeToString((byte[])data2), ScalarStyle.LITERAL);
        }
    }

    protected class RepresentEnum
    implements RepresentToNode {
        protected RepresentEnum() {
        }

        @Override
        public Node representData(Object data2) {
            Tag tag = new Tag(data2.getClass());
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(data2.getClass(), tag), ((Enum)data2).name());
        }
    }

    protected class RepresentSet
    implements RepresentToNode {
        protected RepresentSet() {
        }

        @Override
        public Node representData(Object data2) {
            LinkedHashMap value2 = new LinkedHashMap();
            Set set = (Set)data2;
            for (Object key2 : set) {
                value2.put(key2, null);
            }
            return StandardRepresenter.this.representMapping(StandardRepresenter.this.getTag(data2.getClass(), Tag.SET), value2, StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    protected class RepresentMap
    implements RepresentToNode {
        protected RepresentMap() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representMapping(StandardRepresenter.this.getTag(data2.getClass(), Tag.MAP), (Map)data2, StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    protected class RepresentPrimitiveArray
    implements RepresentToNode {
        protected RepresentPrimitiveArray() {
        }

        @Override
        public Node representData(Object data2) {
            Class<?> type2 = data2.getClass().getComponentType();
            FlowStyle style2 = StandardRepresenter.this.settings.getDefaultFlowStyle();
            if (Byte.TYPE == type2) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asByteList(data2), style2);
            }
            if (Short.TYPE == type2) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asShortList(data2), style2);
            }
            if (Integer.TYPE == type2) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asIntList(data2), style2);
            }
            if (Long.TYPE == type2) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asLongList(data2), style2);
            }
            if (Float.TYPE == type2) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asFloatList(data2), style2);
            }
            if (Double.TYPE == type2) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asDoubleList(data2), style2);
            }
            if (Character.TYPE == type2) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asCharList(data2), style2);
            }
            if (Boolean.TYPE == type2) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asBooleanList(data2), style2);
            }
            throw new YamlEngineException("Unexpected primitive '" + type2.getCanonicalName() + "'");
        }

        private List<Byte> asByteList(Object in) {
            byte[] array = (byte[])in;
            ArrayList<Byte> list = new ArrayList<Byte>(array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                list.add(array[i2]);
            }
            return list;
        }

        private List<Short> asShortList(Object in) {
            short[] array = (short[])in;
            ArrayList<Short> list = new ArrayList<Short>(array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                list.add(array[i2]);
            }
            return list;
        }

        private List<Integer> asIntList(Object in) {
            int[] array = (int[])in;
            ArrayList<Integer> list = new ArrayList<Integer>(array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                list.add(array[i2]);
            }
            return list;
        }

        private List<Long> asLongList(Object in) {
            long[] array = (long[])in;
            ArrayList<Long> list = new ArrayList<Long>(array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                list.add(array[i2]);
            }
            return list;
        }

        private List<Float> asFloatList(Object in) {
            float[] array = (float[])in;
            ArrayList<Float> list = new ArrayList<Float>(array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                list.add(Float.valueOf(array[i2]));
            }
            return list;
        }

        private List<Double> asDoubleList(Object in) {
            double[] array = (double[])in;
            ArrayList<Double> list = new ArrayList<Double>(array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                list.add(array[i2]);
            }
            return list;
        }

        private List<Character> asCharList(Object in) {
            char[] array = (char[])in;
            ArrayList<Character> list = new ArrayList<Character>(array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                list.add(Character.valueOf(array[i2]));
            }
            return list;
        }

        private List<Boolean> asBooleanList(Object in) {
            boolean[] array = (boolean[])in;
            ArrayList<Boolean> list = new ArrayList<Boolean>(array.length);
            for (int i2 = 0; i2 < array.length; ++i2) {
                list.add(array[i2]);
            }
            return list;
        }
    }

    protected class RepresentArray
    implements RepresentToNode {
        protected RepresentArray() {
        }

        @Override
        public Node representData(Object data2) {
            Object[] array = (Object[])data2;
            List<Object> list = Arrays.asList(array);
            return StandardRepresenter.this.representSequence(Tag.SEQ, list, StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    private static class IteratorWrapper
    implements Iterable<Object> {
        private final Iterator<Object> iter;

        public IteratorWrapper(Iterator<Object> iter) {
            this.iter = iter;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.iter;
        }
    }

    protected class RepresentIterator
    implements RepresentToNode {
        protected RepresentIterator() {
        }

        @Override
        public Node representData(Object data2) {
            Iterator iter = (Iterator)data2;
            return StandardRepresenter.this.representSequence(StandardRepresenter.this.getTag(data2.getClass(), Tag.SEQ), new IteratorWrapper(iter), StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    protected class RepresentList
    implements RepresentToNode {
        protected RepresentList() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representSequence(StandardRepresenter.this.getTag(data2.getClass(), Tag.SEQ), (List)data2, StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    protected class RepresentNumber
    implements RepresentToNode {
        protected RepresentNumber() {
        }

        @Override
        public Node representData(Object data2) {
            String value2;
            Tag tag;
            if (data2 instanceof Byte || data2 instanceof Short || data2 instanceof Integer || data2 instanceof Long || data2 instanceof BigInteger) {
                tag = Tag.INT;
                value2 = data2.toString();
            } else {
                Number number = (Number)data2;
                tag = Tag.FLOAT;
                value2 = number.equals(Double.NaN) ? ".NaN" : (number.equals(Double.POSITIVE_INFINITY) ? ".inf" : (number.equals(Double.NEGATIVE_INFINITY) ? "-.inf" : number.toString()));
            }
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(data2.getClass(), tag), value2);
        }
    }

    protected class RepresentBoolean
    implements RepresentToNode {
        protected RepresentBoolean() {
        }

        @Override
        public Node representData(Object data2) {
            String value2 = Boolean.TRUE.equals(data2) ? "true" : "false";
            return StandardRepresenter.this.representScalar(Tag.BOOL, value2);
        }
    }

    protected class RepresentString
    implements RepresentToNode {
        protected RepresentString() {
        }

        @Override
        public Node representData(Object data2) {
            Tag tag = Tag.STR;
            ScalarStyle style2 = ScalarStyle.PLAIN;
            String value2 = data2.toString();
            if (StandardRepresenter.this.settings.getNonPrintableStyle() == NonPrintableStyle.BINARY && !StreamReader.isPrintable(value2)) {
                tag = Tag.BINARY;
                byte[] bytes = value2.getBytes(StandardCharsets.UTF_8);
                String checkValue = new String(bytes, StandardCharsets.UTF_8);
                if (!checkValue.equals(value2)) {
                    throw new YamlEngineException("invalid string value has occurred");
                }
                value2 = Base64.getEncoder().encodeToString(bytes);
                style2 = ScalarStyle.LITERAL;
            }
            if (StandardRepresenter.this.defaultScalarStyle == ScalarStyle.PLAIN && MULTILINE_PATTERN.matcher(value2).find()) {
                style2 = ScalarStyle.LITERAL;
            }
            return StandardRepresenter.this.representScalar(tag, value2, style2);
        }
    }

    protected class RepresentNull
    implements RepresentToNode {
        protected RepresentNull() {
        }

        @Override
        public Node representData(Object data2) {
            return StandardRepresenter.this.representScalar(Tag.NULL, "null");
        }
    }
}

