/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.snakeyaml.engine.v2.tokens;

import java.util.Objects;
import java.util.Optional;
import org.pkl.thirdparty.snakeyaml.engine.v2.common.ScalarStyle;
import org.pkl.thirdparty.snakeyaml.engine.v2.exceptions.Mark;
import org.pkl.thirdparty.snakeyaml.engine.v2.tokens.Token;

public final class ScalarToken
extends Token {
    private final String value;
    private final boolean plain;
    private final ScalarStyle style;

    public ScalarToken(String value2, boolean plain, Optional<Mark> startMark, Optional<Mark> endMark) {
        this(value2, plain, ScalarStyle.PLAIN, startMark, endMark);
    }

    public ScalarToken(String value2, boolean plain, ScalarStyle style2, Optional<Mark> startMark, Optional<Mark> endMark) {
        super(startMark, endMark);
        Objects.requireNonNull(value2);
        this.value = value2;
        this.plain = plain;
        Objects.requireNonNull(style2);
        this.style = style2;
    }

    public boolean isPlain() {
        return this.plain;
    }

    public String getValue() {
        return this.value;
    }

    public ScalarStyle getStyle() {
        return this.style;
    }

    @Override
    public Token.ID getTokenId() {
        return Token.ID.Scalar;
    }

    @Override
    public String toString() {
        return this.getTokenId().toString() + " plain=" + this.plain + " style=" + (Object)((Object)this.style) + " value=" + this.value;
    }
}

