/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.truffle.api;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import sun.misc.Unsafe;

public final class ArrayUtils {
    private static final Unsafe UNSAFE = ArrayUtils.getUnsafe();
    private static final long javaStringValueFieldOffset;
    private static final long javaStringCoderFieldOffset;

    private ArrayUtils() {
    }

    static long getObjectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    private static Field getStringDeclaredField(String name) {
        try {
            return String.class.getDeclaredField(name);
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException("failed to get " + name + " field offset", e2);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException e1) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e2) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e2);
            }
        }
    }

    private static byte[] getJavaStringArray(String str) {
        Object value2 = UNSAFE.getObject(str, javaStringValueFieldOffset);
        assert (value2 instanceof byte[]);
        return (byte[])value2;
    }

    private static boolean isCompactString(String s2) {
        return UNSAFE.getByte(s2, javaStringCoderFieldOffset) == 0;
    }

    public static int indexOf(String string, int fromIndex, int maxIndex, char ... values2) {
        ArrayUtils.checkArgs(string.length(), fromIndex, maxIndex, values2.length);
        if (fromIndex >= string.length()) {
            return -1;
        }
        if (values2.length <= 4) {
            if (ArrayUtils.isCompactString(string)) {
                int valuesInt = 0;
                int nValues = 0;
                for (int i2 = 0; i2 < values2.length; ++i2) {
                    if (values2[i2] > '\u00ff') continue;
                    valuesInt = valuesInt << 8 | values2[i2];
                    ++nValues;
                }
                return nValues == 0 ? -1 : ArrayUtils.indexOfBS1(ArrayUtils.getJavaStringArray(string), fromIndex, maxIndex, valuesInt, nValues);
            }
            return ArrayUtils.indexOfBS2(ArrayUtils.getJavaStringArray(string), fromIndex, maxIndex, values2, values2.length);
        }
        return ArrayUtils.runIndexOfS2(string, fromIndex, maxIndex, values2);
    }

    public static int indexOf(char[] array, int fromIndex, int maxIndex, char ... values2) {
        ArrayUtils.checkArgs(array.length, fromIndex, maxIndex, values2.length);
        if (fromIndex >= array.length) {
            return -1;
        }
        if (values2.length <= 4) {
            return ArrayUtils.indexOfCS2(array, fromIndex, maxIndex, values2, values2.length);
        }
        return ArrayUtils.runIndexOfS2(array, fromIndex, maxIndex, values2);
    }

    public static int indexOf(byte[] array, int fromIndex, int maxIndex, byte ... values2) {
        ArrayUtils.checkArgs(array.length, fromIndex, maxIndex, values2.length);
        if (fromIndex >= array.length) {
            return -1;
        }
        if (values2.length <= 4) {
            return ArrayUtils.indexOfBS1(array, fromIndex, maxIndex, values2, values2.length);
        }
        return ArrayUtils.runIndexOfS1(array, fromIndex, maxIndex, values2);
    }

    public static int indexOfWithOrMask(byte[] haystack, int fromIndex, int length2, byte[] needle, byte[] mask) {
        ArrayUtils.checkArgsIndexOf(haystack.length, fromIndex, length2);
        if (mask != null) {
            ArrayUtils.checkMaskLengthIndexOf(needle.length, mask.length);
        }
        if (needle.length == 0) {
            return fromIndex;
        }
        if (length2 - needle.length < 0) {
            return -1;
        }
        if (needle.length == 1) {
            if (mask == null) {
                return ArrayUtils.stubIndexOfB1S1(haystack, fromIndex, fromIndex + length2, Byte.toUnsignedInt(needle[0]));
            }
            return ArrayUtils.stubIndexOfWithOrMaskS1(haystack, fromIndex, fromIndex + length2, Byte.toUnsignedInt(needle[0]), Byte.toUnsignedInt(mask[0]));
        }
        int max2 = fromIndex + length2 - (needle.length - 2);
        if (mask == null) {
            for (index = fromIndex; index < max2 - 1; ++index) {
                if ((index = ArrayUtils.stubIndexOf2ConsecutiveS1(haystack, index, max2, Byte.toUnsignedInt(needle[0]), Byte.toUnsignedInt(needle[1]))) < 0) {
                    return -1;
                }
                if (needle.length != 2 && !ArrayUtils.stubRegionEqualsS1(haystack, index, needle, 0L, needle.length)) continue;
                return index;
            }
        } else {
            while (index < max2 - 1) {
                if ((index = ArrayUtils.stubIndexOf2ConsecutiveWithOrMaskS1(haystack, index, max2, Byte.toUnsignedInt(needle[0]), Byte.toUnsignedInt(needle[1]), Byte.toUnsignedInt(mask[0]), Byte.toUnsignedInt(mask[1]))) < 0) {
                    return -1;
                }
                if (needle.length == 2 || ArrayUtils.stubRegionEqualsWithOrMaskS1(haystack, index, needle, 0L, mask, mask.length)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static int indexOfWithOrMask(char[] haystack, int fromIndex, int length2, char[] needle, char[] mask) {
        ArrayUtils.checkArgsIndexOf(haystack.length, fromIndex, length2);
        if (mask != null) {
            ArrayUtils.checkMaskLengthIndexOf(needle.length, mask.length);
        }
        if (needle.length == 0) {
            return fromIndex;
        }
        if (length2 - needle.length < 0) {
            return -1;
        }
        if (needle.length == 1) {
            if (mask == null) {
                return ArrayUtils.stubIndexOfC1S2(haystack, fromIndex, fromIndex + length2, needle[0]);
            }
            return ArrayUtils.stubIndexOfWithOrMaskS2(haystack, fromIndex, fromIndex + length2, (int)needle[0], (int)mask[0]);
        }
        int max2 = fromIndex + length2 - (needle.length - 2);
        if (mask == null) {
            for (index = fromIndex; index < max2 - 1; ++index) {
                if ((index = ArrayUtils.stubIndexOf2ConsecutiveS2(haystack, index, max2, (int)needle[0], (int)needle[1])) < 0) {
                    return -1;
                }
                if (needle.length != 2 && !ArrayUtils.stubRegionEqualsS2(haystack, index, needle, 0L, needle.length)) continue;
                return index;
            }
        } else {
            while (index < max2 - 1) {
                if ((index = ArrayUtils.stubIndexOf2ConsecutiveWithOrMaskS2(haystack, index, max2, (int)needle[0], (int)needle[1], (int)mask[0], (int)mask[1])) < 0) {
                    return -1;
                }
                if (needle.length == 2 || ArrayUtils.stubRegionEqualsWithOrMaskS2(haystack, index, needle, 0L, mask, mask.length)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static int indexOfWithOrMask(String haystack, int fromIndex, int length2, String needle, String mask) {
        ArrayUtils.checkArgsIndexOf(haystack.length(), fromIndex, length2);
        if (mask != null) {
            ArrayUtils.checkMaskLengthIndexOf(needle.length(), mask.length());
        }
        if (needle.isEmpty()) {
            return fromIndex;
        }
        if (length2 - needle.length() < 0) {
            return -1;
        }
        if (needle.length() == 1) {
            return ArrayUtils.indexOfWithOrMaskJLString(haystack, fromIndex, length2, needle, mask);
        }
        int max2 = fromIndex + length2 - (needle.length() - 2);
        for (int index = fromIndex; index < max2 - 1; ++index) {
            if ((index = ArrayUtils.indexOf2ConsecutiveWithOrMaskJLString(haystack, index, needle, mask, max2)) < 0) {
                return -1;
            }
            if (needle.length() != 2 && !ArrayUtils.regionEqualsWithOrMask(haystack, index, needle, 0, needle.length(), mask)) continue;
            return index;
        }
        return -1;
    }

    private static int indexOfWithOrMaskJLString(String haystack, int fromIndex, int length2, String needle, String mask) {
        int maxIndex = fromIndex + length2;
        char v0 = needle.charAt(0);
        byte[] array = ArrayUtils.getJavaStringArray(haystack);
        if (mask == null) {
            if (ArrayUtils.isCompactString(haystack)) {
                return v0 <= '\u00ff' ? ArrayUtils.stubIndexOfB1S1(array, fromIndex, maxIndex, v0) : -1;
            }
            return ArrayUtils.stubIndexOfB1S2(array, fromIndex, maxIndex, v0);
        }
        char mask0 = mask.charAt(0);
        if (ArrayUtils.isCompactString(haystack)) {
            return (v0 ^ mask0) <= 255 ? ArrayUtils.stubIndexOfWithOrMaskS1(array, fromIndex, maxIndex, v0, mask0) : -1;
        }
        return ArrayUtils.stubIndexOfWithOrMaskS2(array, fromIndex, maxIndex, (int)v0, (int)mask0);
    }

    private static int indexOf2ConsecutiveWithOrMaskJLString(String haystack, int fromIndex, String needle, String mask, int max2) {
        char v0 = needle.charAt(0);
        char v1 = needle.charAt(1);
        byte[] array = ArrayUtils.getJavaStringArray(haystack);
        if (mask == null) {
            if (ArrayUtils.isCompactString(haystack)) {
                return v0 <= '\u00ff' && v1 <= '\u00ff' ? ArrayUtils.stubIndexOf2ConsecutiveS1(array, fromIndex, max2, v0, v1) : -1;
            }
            return ArrayUtils.stubIndexOf2ConsecutiveS2(array, fromIndex, max2, (int)v0, (int)v1);
        }
        char mask0 = mask.charAt(0);
        char mask1 = mask.charAt(1);
        if (ArrayUtils.isCompactString(haystack)) {
            return (v0 ^ mask0) <= 255 && (v1 ^ mask1) <= 255 ? ArrayUtils.stubIndexOf2ConsecutiveWithOrMaskS1(array, fromIndex, max2, v0, v1, mask0, mask1) : -1;
        }
        return ArrayUtils.stubIndexOf2ConsecutiveWithOrMaskS2(array, fromIndex, max2, (int)v0, (int)v1, (int)mask0, (int)mask1);
    }

    public static boolean regionEqualsWithOrMask(byte[] a2, int offsetA, byte[] b2, int offsetB, int length2, byte[] mask) {
        ArrayUtils.requireNonNull(a2);
        ArrayUtils.requireNonNull(b2);
        ArrayUtils.checkArgsRegionEquals(offsetA, offsetB, length2);
        if (ArrayUtils.regionEqualsOutOfBounds(a2.length, offsetA, b2.length, offsetB, length2)) {
            return false;
        }
        if (mask == null) {
            return ArrayUtils.stubRegionEqualsS1(a2, offsetA, b2, offsetB, length2);
        }
        ArrayUtils.checkMaskLengthRegionEquals(length2, mask.length);
        return ArrayUtils.stubRegionEqualsWithOrMaskS1(a2, offsetA, b2, offsetB, mask, mask.length);
    }

    public static boolean regionEqualsWithOrMask(char[] a2, int offsetA, char[] b2, int offsetB, int length2, char[] mask) {
        ArrayUtils.requireNonNull(a2);
        ArrayUtils.requireNonNull(b2);
        ArrayUtils.checkArgsRegionEquals(offsetA, offsetB, length2);
        if (ArrayUtils.regionEqualsOutOfBounds(a2.length, offsetA, b2.length, offsetB, length2)) {
            return false;
        }
        if (mask == null) {
            return ArrayUtils.stubRegionEqualsS2(a2, offsetA, b2, offsetB, length2);
        }
        ArrayUtils.checkMaskLengthRegionEquals(length2, mask.length);
        return ArrayUtils.stubRegionEqualsWithOrMaskS2(a2, offsetA, b2, offsetB, mask, mask.length);
    }

    public static boolean regionEqualsWithOrMask(String a2, int offsetA, String b2, int offsetB, int length2, String mask) {
        ArrayUtils.requireNonNull(a2);
        ArrayUtils.requireNonNull(b2);
        ArrayUtils.checkArgsRegionEquals(offsetA, offsetB, length2);
        if (ArrayUtils.regionEqualsOutOfBounds(a2.length(), offsetA, b2.length(), offsetB, length2)) {
            return false;
        }
        if (mask == null) {
            int byteLength;
            int byteOffsetB;
            int byteOffsetA;
            byte[] arrayA = ArrayUtils.getJavaStringArray(a2);
            byte[] arrayB = ArrayUtils.getJavaStringArray(b2);
            boolean compactA = ArrayUtils.isCompactString(a2);
            if (compactA != ArrayUtils.isCompactString(b2)) {
                return ArrayUtils.stubRegionEqualsS2S1(compactA ? arrayB : arrayA, compactA ? (long)offsetB : (long)offsetA, compactA ? arrayA : arrayB, compactA ? (long)offsetA : (long)offsetB, length2);
            }
            if (compactA) {
                byteOffsetA = offsetA;
                byteOffsetB = offsetB;
                byteLength = length2;
            } else {
                byteOffsetA = offsetA << 1;
                byteOffsetB = offsetB << 1;
                byteLength = length2 << 1;
            }
            return ArrayUtils.stubRegionEqualsS1(arrayA, byteOffsetA, arrayB, byteOffsetB, byteLength);
        }
        ArrayUtils.checkMaskLengthRegionEquals(length2, mask.length());
        byte[] arrayA = ArrayUtils.getJavaStringArray(a2);
        byte[] arrayB = ArrayUtils.getJavaStringArray(b2);
        byte[] arrayM = ArrayUtils.getJavaStringArray(mask);
        boolean compact1 = ArrayUtils.isCompactString(a2);
        boolean compact2 = ArrayUtils.isCompactString(b2);
        boolean compactMask = ArrayUtils.isCompactString(mask);
        if (compact2) {
            if (compactMask) {
                if (compact1) {
                    return ArrayUtils.stubRegionEqualsWithOrMaskCompactStrings(arrayA, offsetA, arrayB, offsetB, arrayM, mask.length(), true, true, true);
                }
                return ArrayUtils.stubRegionEqualsWithOrMaskCompactStrings(arrayA, offsetA, arrayB, offsetB, arrayM, mask.length(), false, true, true);
            }
            return false;
        }
        if (compactMask) {
            if (compact1) {
                return ArrayUtils.stubRegionEqualsWithOrMaskCompactStrings(arrayA, offsetA, arrayB, offsetB, arrayM, mask.length(), true, false, true);
            }
            return ArrayUtils.stubRegionEqualsWithOrMaskCompactStrings(arrayA, offsetA, arrayB, offsetB, arrayM, mask.length(), false, false, true);
        }
        if (compact1) {
            return ArrayUtils.stubRegionEqualsWithOrMaskCompactStrings(arrayA, offsetA, arrayB, offsetB, arrayM, mask.length(), true, false, false);
        }
        return ArrayUtils.stubRegionEqualsWithOrMaskCompactStrings(arrayA, offsetA, arrayB, offsetB, arrayM, mask.length(), false, false, false);
    }

    private static boolean regionEqualsOutOfBounds(int lengthA, int offsetA, int lengthB, int offsetB, int length2) {
        return lengthA - offsetA < length2 || lengthB - offsetB < length2;
    }

    private static void checkArgsRegionEquals(int offsetA, int offsetB, int length2) {
        if (offsetA < 0 || offsetB < 0 || length2 < 0) {
            ArrayUtils.illegalArgumentException("length, offsetA and offsetB must be positive");
        }
    }

    private static void checkMaskLengthRegionEquals(int length2, int maskLength) {
        if (length2 > maskLength) {
            ArrayUtils.illegalArgumentException("mask length must be greater or equal to length");
        }
    }

    private static void checkArgs(int length2, int fromIndex, int maxIndex, int nValues) {
        if (fromIndex < 0) {
            ArrayUtils.illegalArgumentException("fromIndex must be positive");
        }
        if (maxIndex > length2 || maxIndex < fromIndex) {
            ArrayUtils.illegalArgumentException("maxIndex out of range");
        }
        if (nValues == 0) {
            ArrayUtils.illegalArgumentException("no search values provided");
        }
    }

    private static void checkArgsIndexOf(int hayStackLength, int fromIndex, int length2) {
        if (fromIndex < 0 || length2 < 0) {
            ArrayUtils.illegalArgumentException("fromIndex and length must be positive");
        }
        if (Integer.toUnsignedLong(fromIndex) + Integer.toUnsignedLong(length2) > (long)hayStackLength) {
            ArrayUtils.illegalArgumentException("length out of range");
        }
    }

    private static void checkMaskLengthIndexOf(int lengthB, int maskLength) {
        if (lengthB != maskLength) {
            ArrayUtils.illegalArgumentException("mask and needle length must be equal");
        }
    }

    private static void requireNonNull(Object obj) {
        if (obj == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new NullPointerException();
        }
    }

    private static void illegalArgumentException(String msg) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException(msg);
    }

    private static int indexOfBS1(byte[] array, int fromIndex, int maxIndex, int values2, int nValues) {
        if (nValues == 1) {
            return ArrayUtils.stubIndexOfB1S1(array, fromIndex, maxIndex, values2 & 0xFF);
        }
        if (nValues == 2) {
            return ArrayUtils.stubIndexOfB2S1(array, fromIndex, maxIndex, values2 & 0xFF, values2 >>> 8 & 0xFF);
        }
        if (nValues == 3) {
            return ArrayUtils.stubIndexOfB3S1(array, fromIndex, maxIndex, values2 & 0xFF, values2 >>> 8 & 0xFF, values2 >>> 16 & 0xFF);
        }
        return ArrayUtils.stubIndexOfB4S1(array, fromIndex, maxIndex, values2 & 0xFF, values2 >>> 8 & 0xFF, values2 >>> 16 & 0xFF, values2 >>> 24 & 0xFF);
    }

    private static int indexOfBS1(byte[] array, int fromIndex, int maxIndex, byte[] bytes, int nValues) {
        if (nValues == 1) {
            return ArrayUtils.stubIndexOfB1S1(array, fromIndex, maxIndex, Byte.toUnsignedInt(bytes[0]));
        }
        if (nValues == 2) {
            return ArrayUtils.stubIndexOfB2S1(array, fromIndex, maxIndex, Byte.toUnsignedInt(bytes[0]), Byte.toUnsignedInt(bytes[1]));
        }
        if (nValues == 3) {
            return ArrayUtils.stubIndexOfB3S1(array, fromIndex, maxIndex, Byte.toUnsignedInt(bytes[0]), Byte.toUnsignedInt(bytes[1]), Byte.toUnsignedInt(bytes[2]));
        }
        return ArrayUtils.stubIndexOfB4S1(array, fromIndex, maxIndex, Byte.toUnsignedInt(bytes[0]), Byte.toUnsignedInt(bytes[1]), Byte.toUnsignedInt(bytes[2]), Byte.toUnsignedInt(bytes[3]));
    }

    private static int indexOfBS2(byte[] array, int fromIndex, int maxIndex, char[] chars2, int nValues) {
        if (nValues == 1) {
            return ArrayUtils.stubIndexOfB1S2(array, fromIndex, maxIndex, chars2[0]);
        }
        if (nValues == 2) {
            return ArrayUtils.stubIndexOfB2S2(array, fromIndex, maxIndex, chars2[0], chars2[1]);
        }
        if (nValues == 3) {
            return ArrayUtils.stubIndexOfB3S2(array, fromIndex, maxIndex, chars2[0], chars2[1], chars2[2]);
        }
        return ArrayUtils.stubIndexOfB4S2(array, fromIndex, maxIndex, chars2[0], chars2[1], chars2[2], chars2[3]);
    }

    private static int indexOfCS2(char[] array, int fromIndex, int maxIndex, char[] chars2, int nValues) {
        if (nValues == 1) {
            return ArrayUtils.stubIndexOfC1S2(array, fromIndex, maxIndex, chars2[0]);
        }
        if (nValues == 2) {
            return ArrayUtils.stubIndexOfC2S2(array, fromIndex, maxIndex, chars2[0], chars2[1]);
        }
        if (nValues == 3) {
            return ArrayUtils.stubIndexOfC3S2(array, fromIndex, maxIndex, chars2[0], chars2[1], chars2[2]);
        }
        return ArrayUtils.stubIndexOfC4S2(array, fromIndex, maxIndex, chars2[0], chars2[1], chars2[2], chars2[3]);
    }

    private static int stubIndexOfB1S1(byte[] array, int fromIndex, int maxIndex, int v1) {
        return ArrayUtils.runIndexOfS1(array, fromIndex, maxIndex, v1);
    }

    private static int stubIndexOfB2S1(byte[] array, int fromIndex, int maxIndex, int v1, int v2) {
        return ArrayUtils.runIndexOfS1(array, fromIndex, maxIndex, v1, v2);
    }

    private static int stubIndexOfB3S1(byte[] array, int fromIndex, int maxIndex, int v1, int v2, int v3) {
        return ArrayUtils.runIndexOfS1(array, fromIndex, maxIndex, v1, v2, v3);
    }

    private static int stubIndexOfB4S1(byte[] array, int fromIndex, int maxIndex, int v1, int v2, int v3, int v4) {
        return ArrayUtils.runIndexOfS1(array, fromIndex, maxIndex, v1, v2, v3, v4);
    }

    private static int stubIndexOfB1S2(byte[] array, int fromIndex, int maxIndex, int v1) {
        return ArrayUtils.runIndexOfS2(array, fromIndex, maxIndex, v1);
    }

    private static int stubIndexOfB2S2(byte[] array, int fromIndex, int maxIndex, int v1, int v2) {
        return ArrayUtils.runIndexOfS2(array, fromIndex, maxIndex, v1, v2);
    }

    private static int stubIndexOfB3S2(byte[] array, int fromIndex, int maxIndex, int v1, int v2, int v3) {
        return ArrayUtils.runIndexOfS2(array, fromIndex, maxIndex, v1, v2, v3);
    }

    private static int stubIndexOfB4S2(byte[] array, int fromIndex, int maxIndex, int v1, int v2, int v3, int v4) {
        return ArrayUtils.runIndexOfS2(array, fromIndex, maxIndex, v1, v2, v3, v4);
    }

    private static int stubIndexOfC1S2(char[] array, int fromIndex, int maxIndex, int v1) {
        return ArrayUtils.runIndexOfS2(array, fromIndex, maxIndex, v1);
    }

    private static int stubIndexOfC2S2(char[] array, int fromIndex, int maxIndex, int v1, int v2) {
        return ArrayUtils.runIndexOfS2(array, fromIndex, maxIndex, v1, v2);
    }

    private static int stubIndexOfC3S2(char[] array, int fromIndex, int maxIndex, int v1, int v2, int v3) {
        return ArrayUtils.runIndexOfS2(array, fromIndex, maxIndex, v1, v2, v3);
    }

    private static int stubIndexOfC4S2(char[] array, int fromIndex, int maxIndex, int v1, int v2, int v3, int v4) {
        return ArrayUtils.runIndexOfS2(array, fromIndex, maxIndex, v1, v2, v3, v4);
    }

    private static int stubIndexOfWithOrMaskS1(byte[] haystack, int fromIndex, int maxIndex, int needle, int mask) {
        for (int i2 = fromIndex; i2 < maxIndex; ++i2) {
            if ((Byte.toUnsignedInt(haystack[i2]) | mask) != needle) continue;
            return i2;
        }
        return -1;
    }

    private static int stubIndexOfWithOrMaskS2(byte[] haystack, int fromIndex, int maxIndex, int needle, int mask) {
        for (int i2 = fromIndex; i2 < maxIndex; ++i2) {
            if ((ArrayUtils.readChar(haystack, i2) | mask) != needle) continue;
            return i2;
        }
        return -1;
    }

    private static int stubIndexOfWithOrMaskS2(char[] haystack, int fromIndex, int maxIndex, int needle, int mask) {
        for (int i2 = fromIndex; i2 < maxIndex; ++i2) {
            if ((haystack[i2] | mask) != needle) continue;
            return i2;
        }
        return -1;
    }

    private static int stubIndexOf2ConsecutiveS1(byte[] haystack, int fromIndex, int maxIndex, int c1, int c2) {
        for (int i2 = fromIndex + 1; i2 < maxIndex; ++i2) {
            if (Byte.toUnsignedInt(haystack[i2 - 1]) != c1 || Byte.toUnsignedInt(haystack[i2]) != c2) continue;
            return i2 - 1;
        }
        return -1;
    }

    private static int stubIndexOf2ConsecutiveS2(byte[] haystack, int fromIndex, int maxIndex, int c1, int c2) {
        for (int i2 = fromIndex + 1; i2 < maxIndex; ++i2) {
            if (ArrayUtils.readChar(haystack, i2 - 1) != c1 || ArrayUtils.readChar(haystack, i2) != c2) continue;
            return i2 - 1;
        }
        return -1;
    }

    private static int stubIndexOf2ConsecutiveS2(char[] haystack, int fromIndex, int maxIndex, int c1, int c2) {
        for (int i2 = fromIndex + 1; i2 < maxIndex; ++i2) {
            if (haystack[i2 - 1] != c1 || haystack[i2] != c2) continue;
            return i2 - 1;
        }
        return -1;
    }

    private static int stubIndexOf2ConsecutiveWithOrMaskS1(byte[] haystack, int fromIndex, int maxIndex, int c1, int c2, int mask1, int mask2) {
        for (int i2 = fromIndex + 1; i2 < maxIndex; ++i2) {
            if ((Byte.toUnsignedInt(haystack[i2 - 1]) | mask1) != c1 || (Byte.toUnsignedInt(haystack[i2]) | mask2) != c2) continue;
            return i2 - 1;
        }
        return -1;
    }

    private static int stubIndexOf2ConsecutiveWithOrMaskS2(byte[] haystack, int fromIndex, int maxIndex, int c1, int c2, int mask1, int mask2) {
        for (int i2 = fromIndex + 1; i2 < maxIndex; ++i2) {
            if ((ArrayUtils.readChar(haystack, i2 - 1) | mask1) != c1 || (ArrayUtils.readChar(haystack, i2) | mask2) != c2) continue;
            return i2 - 1;
        }
        return -1;
    }

    private static int stubIndexOf2ConsecutiveWithOrMaskS2(char[] haystack, int fromIndex, int maxIndex, int c1, int c2, int mask1, int mask2) {
        for (int i2 = fromIndex + 1; i2 < maxIndex; ++i2) {
            if ((haystack[i2 - 1] | mask1) != c1 || (haystack[i2] | mask2) != c2) continue;
            return i2 - 1;
        }
        return -1;
    }

    private static boolean stubRegionEqualsS1(byte[] a2, long offsetA, byte[] b2, long offsetB, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            if (a2[(int)offsetA + i2] == b2[(int)offsetB + i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean stubRegionEqualsS2S1(byte[] a2, long offsetA, byte[] b2, long offsetB, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            if (ArrayUtils.readChar(a2, (int)offsetA + i2) == Byte.toUnsignedInt(b2[(int)offsetB + i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean stubRegionEqualsS2(char[] a2, long offsetA, char[] b2, long offsetB, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            if (a2[(int)offsetA + i2] == b2[(int)offsetB + i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean stubRegionEqualsWithOrMaskS1(byte[] a2, long offsetA, byte[] b2, long offsetB, byte[] mask, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            if ((a2[(int)offsetA + i2] | mask[i2]) == b2[(int)offsetB + i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean stubRegionEqualsWithOrMaskS2(char[] a2, long offsetA, char[] b2, long offsetB, char[] mask, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            if ((a2[(int)offsetA + i2] | mask[i2]) == b2[(int)offsetB + i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean stubRegionEqualsWithOrMaskCompactStrings(byte[] a2, long offsetA, byte[] b2, long offsetB, byte[] mask, int length2, boolean compactA, boolean compactB, boolean compactM) {
        for (int i2 = 0; i2 < length2; ++i2) {
            int vM;
            int vA = compactA ? Byte.toUnsignedInt(a2[(int)offsetA + i2]) : ArrayUtils.readChar(a2, (int)offsetA + i2);
            int vB = compactB ? Byte.toUnsignedInt(b2[(int)offsetB + i2]) : ArrayUtils.readChar(b2, (int)offsetB + i2);
            int n = vM = compactM ? Byte.toUnsignedInt(mask[i2]) : ArrayUtils.readChar(mask, i2);
            if ((vA | vM) == vB) continue;
            return false;
        }
        return true;
    }

    private static int readChar(byte[] array, int i2) {
        int byte0 = Byte.toUnsignedInt(array[i2 << 1]);
        int byte1 = Byte.toUnsignedInt(array[(i2 << 1) + 1]);
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? byte0 | byte1 << 8 : byte0 << 8 | byte1;
    }

    private static int runIndexOfS1(byte[] array, int fromIndex, int maxIndex, int ... values2) {
        for (int i2 = fromIndex; i2 < maxIndex; ++i2) {
            for (int v : values2) {
                if (Byte.toUnsignedInt(array[i2]) != v) continue;
                return i2;
            }
        }
        return -1;
    }

    private static int runIndexOfS1(byte[] array, int fromIndex, int maxIndex, byte ... values2) {
        for (int i2 = fromIndex; i2 < maxIndex; ++i2) {
            for (byte v : values2) {
                if (array[i2] != v) continue;
                return i2;
            }
        }
        return -1;
    }

    private static int runIndexOfS2(byte[] array, int fromIndex, int maxIndex, int ... values2) {
        for (int i2 = fromIndex; i2 < maxIndex; ++i2) {
            int c = ArrayUtils.readChar(array, i2);
            for (int v : values2) {
                if (c != v) continue;
                return i2;
            }
        }
        return -1;
    }

    private static int runIndexOfS2(char[] array, int fromIndex, int maxIndex, int ... values2) {
        for (int i2 = fromIndex; i2 < maxIndex; ++i2) {
            for (int v : values2) {
                if (array[i2] != v) continue;
                return i2;
            }
        }
        return -1;
    }

    private static int runIndexOfS2(char[] array, int fromIndex, int maxIndex, char ... values2) {
        for (int i2 = fromIndex; i2 < maxIndex; ++i2) {
            for (char v : values2) {
                if (array[i2] != v) continue;
                return i2;
            }
        }
        return -1;
    }

    private static int runIndexOfS2(String haystack, int fromIndex, int maxIndex, char[] needle) {
        for (int i2 = fromIndex; i2 < maxIndex; ++i2) {
            for (char c : needle) {
                if (haystack.charAt(i2) != c) continue;
                return i2;
            }
        }
        return -1;
    }

    static {
        Field valueField = ArrayUtils.getStringDeclaredField("value");
        javaStringValueFieldOffset = ArrayUtils.getObjectFieldOffset(valueField);
        Field coderField = ArrayUtils.getStringDeclaredField("coder");
        javaStringCoderFieldOffset = ArrayUtils.getObjectFieldOffset(coderField);
    }
}

